/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.flowspec.bgp;

import com.hs.atic.bis.model.FlowSpecBGP;
import com.hs.atic.bis.model.FlowSpecBGPPeer;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.flowspec.bgp.FlowSpecBuffer;
import com.huawei.atic.flowspec.bgp.FlowSpecCfg;
import com.huawei.atic.flowspec.bgp.FlowSpecUtil;
import com.huawei.atic.flowspec.bgp.model.FlowSpecDivert;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class FlowSpecThread
extends Thread {
    private static final String INDENT_1 = "    ";
    private static final String INDENT_2 = "        ";
    private static final String INDENT_3 = "            ";
    private static final String INDENT_4 = "                ";
    private static final String INDENT_5 = "                    ";
    private static final int IP_PROTO_TCP = 6;
    private static final int IP_PROTO_UDP = 17;
    private static final int IP_PROTO_ICMP = 1;
    private static final int DIVERT_ACTION_BLOCK = 1;
    private static final int DIVERT_ACTION_LIMIT = 2;
    private static final int DIVERT_ACTION_REDIRECT = 3;
    private static final int PROCESS_RESULT_SUCCESS = 0;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_FLOWSPEC);
    private int bgpPid = 0;
    private String confSampleFilePath = "";
    private String exaBGPPidFilePath = "";
    private FlowSpecBGP flowSpecBGP;
    private List<FlowSpecBGPPeer> flowSpecBGPPeerList;
    private List<FlowSpecDivert> flowSpecDivertList;
    private StringBuilder content;
    private boolean pidFlag = false;
    private boolean dataFlag = false;
    private int count = 0;

    @Override
    public void run() {
        boolean isSuportFlowSpec = FlowSpecUtil.isSupportFlowSpec();
        if (!isSuportFlowSpec) {
            this.logger.info((Object)"Not Linux system exit thread.");
            return;
        }
        this.initData();
        block4: while (true) {
            try {
                while (true) {
                    this.reset();
                    this.getExaBGP();
                    this.getDataFromBuffer();
                    this.packageInfomation();
                    this.writeToFile();
                    if (0 != this.bgpPid && (this.pidFlag || this.dataFlag)) {
                        int result = this.callExaBGP();
                        if (0 != result) {
                            this.logger.error((Object)"Signal to ExaBGP error.");
                        } else {
                            this.logger.info((Object)"Signal to ExaBGP success.");
                        }
                    } else {
                        this.logger.warn((Object)"No need to call ExaBGP process.");
                    }
                    try {
                        Thread.sleep(64000L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("Errors occur when sleep." + e.getMessage()));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Errors occur when reading infomation." + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private void initData() {
        FlowSpecBuffer.getInstance().init();
        this.confSampleFilePath = FlowSpecCfg.getConfSampleFilePath();
        if (AticUtil.isNull((String)this.confSampleFilePath)) {
            this.confSampleFilePath = "/usr/lib/python2.7/site-packages/exabgp-3.4.20-py2.7.egg/exabgp/conf-sample";
        }
        this.exaBGPPidFilePath = FlowSpecCfg.getExaBGPPidFilePath();
        if (AticUtil.isNull((String)this.exaBGPPidFilePath)) {
            this.exaBGPPidFilePath = "/tmp/exabgp.pid";
        }
        this.logger.info((Object)"initData,init FlowSpecBuffer success.");
    }

    private void reset() {
        this.count = 0;
        this.pidFlag = false;
        this.dataFlag = false;
        this.content = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getExaBGP() {
        int pid = 0;
        String pidStr = null;
        InputStreamReader issReader = null;
        BufferedReader bufferedReader = null;
        try {
            issReader = new InputStreamReader((InputStream)new FileInputStream(this.exaBGPPidFilePath), "UTF-8");
            bufferedReader = new BufferedReader(issReader);
            pidStr = bufferedReader.readLine();
            if (null == pidStr) return;
            if ("".equals(pidStr.trim())) return;
            pid = Integer.parseInt(pidStr.trim());
            this.logger.info((Object)"getExaBGP, Achieve process number success.");
            return;
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"getExaBGP, file is not found.");
            return;
        }
        catch (IOException e) {
            this.logger.error((Object)("getExaBGP, Errors occur when reading infomation." + e.getMessage()));
            return;
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("getExaBGP, Errors occur when parsing ExaBGP Pid." + e.getMessage()));
            return;
        }
        finally {
            if (null != bufferedReader) {
                try {
                    try {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                    catch (IOException e) {
                        this.logger.error((Object)("getExaBGP, Errors occur when closing bufferedReader." + e.getMessage()));
                        bufferedReader = null;
                    }
                }
                catch (Throwable throwable) {
                    bufferedReader = null;
                    throw throwable;
                }
            }
            if (null != issReader) {
                try {
                    try {
                        issReader.close();
                        issReader = null;
                    }
                    catch (IOException e) {
                        this.logger.error((Object)"getExaBGP, Errors occur when closing fileReader.");
                        issReader = null;
                    }
                }
                catch (Throwable throwable) {
                    issReader = null;
                    throw throwable;
                }
            }
            if (pid != this.bgpPid) {
                this.pidFlag = true;
                this.bgpPid = pid;
            }
        }
    }

    private void getDataFromBuffer() {
        this.count = FlowSpecBuffer.getInstance().getCountAndSet();
        this.flowSpecBGP = FlowSpecBuffer.getInstance().getFlowSpecBGP();
        this.flowSpecBGPPeerList = FlowSpecBuffer.getInstance().getFlowSpecBGPPeer();
        this.flowSpecDivertList = FlowSpecBuffer.getInstance().getFlowSpecDivertList();
        if (this.count > 0) {
            this.dataFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.confSampleFilePath, false), "UTF-8");
            bw = new BufferedWriter(fw);
            bw.write(this.content.toString());
            this.logger.info((Object)"writeToFile, Write information to file successfully.");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)"writeToFile occur UnsupportedEncodingException errors.");
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"writeToFile occur FileNotFoundException errors.");
        }
        catch (IOException e) {
            this.logger.error((Object)"writeToFile occur IOException errors.");
        }
        finally {
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"writeToFile, Errors occur when closing bw.");
                }
            }
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"writeToFile, Errors occur when closing fw.");
                }
            }
        }
    }

    private int callExaBGP() {
        try {
            String cmd = "kill -10 " + this.bgpPid;
            String[] excCmd = new String[]{"/bin/sh", "-c", cmd};
            Process process = Runtime.getRuntime().exec(excCmd);
            StreamThread error = new StreamThread(process.getErrorStream(), System.err);
            StreamThread out = new StreamThread(process.getInputStream(), System.out);
            error.start();
            out.start();
            int value = process.waitFor();
            error.join();
            out.join();
            return value;
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("callExaBGP happen error." + e.getMessage()));
        }
        catch (IOException e) {
            this.logger.error((Object)"callExaBGP happen error.");
        }
        return 1;
    }

    private void packageInfomation() {
        this.content.append("group test {\r\n");
        if (this.validBGP()) {
            this.content.append("    router-id " + this.flowSpecBGP.getBgpRouterId() + ";\r\n");
            this.packageBGPPer();
        }
        this.content.append("}\r\n");
        this.logger.info((Object)"packageInfomation, Packaging Information Successfully.");
    }

    private boolean validBGP() {
        if (null == this.flowSpecBGP) {
            return false;
        }
        return !FlowSpecUtil.checkNull(this.flowSpecBGP.getLocalAddress()) && !FlowSpecUtil.checkNull(this.flowSpecBGP.getBgpRouterId()) && null != this.flowSpecBGP.getLocalAs();
    }

    private void packageBGPPer() {
        for (FlowSpecBGPPeer bgpPeer : this.flowSpecBGPPeerList) {
            this.content.append("    neighbor " + bgpPeer.getPeerIp() + " {\r\n");
            this.content.append("        local-address " + this.flowSpecBGP.getLocalAddress() + ";\r\n");
            this.content.append("        local-as " + this.flowSpecBGP.getLocalAs() + ";\r\n");
            this.content.append("        peer-as " + bgpPeer.getPeerAs() + ";\r\n");
            this.content.append("        flow {\r\n");
            this.packageDivert();
            this.content.append("        }\r\n");
            this.content.append("    }\r\n");
        }
    }

    private void packageDivert() {
        for (FlowSpecDivert divert : this.flowSpecDivertList) {
            this.content.append("            route rule" + divert.getRuleId() + " {\r\n");
            this.content.append("                match {\r\n");
            if (!StringUtils.isEmpty((String)divert.getSourceIp())) {
                this.content.append("                    source " + divert.getSourceIp() + ";\r\n");
            }
            if (!StringUtils.isEmpty((String)divert.getDestinationIp())) {
                this.content.append("                    destination " + divert.getDestinationIp() + ";\r\n");
            }
            if (null != divert.getSourcePort() && divert.getSourcePort().length > 0) {
                this.content.append("                    source-port " + this.packagePort(divert.getSourcePort()) + ";\r\n");
            }
            if (null != divert.getDestinationPort() && divert.getDestinationPort().length > 0) {
                this.content.append("                    destination-port " + this.packagePort(divert.getDestinationPort()) + ";\r\n");
            }
            switch (divert.getProtocol()) {
                case 6: {
                    this.content.append("                    protocol tcp;\r\n");
                    break;
                }
                case 17: {
                    this.content.append("                    protocol udp;\r\n");
                    break;
                }
                case 1: {
                    this.content.append("                    protocol icmp;\r\n");
                    break;
                }
            }
            this.content.append("                }\r\n");
            this.content.append("                then {\r\n");
            switch (divert.getAction()) {
                case 1: {
                    this.content.append("                    discard;\r\n");
                    break;
                }
                case 2: {
                    this.content.append("                    rate-limit " + divert.getLimitRate() + ";\r\n");
                    break;
                }
                case 3: {
                    this.content.append("                    redirect " + divert.getNextHop() + ";\r\n");
                    break;
                }
            }
            this.content.append("                }\r\n");
            this.content.append("            }\r\n");
        }
    }

    private String packagePort(String[] ports) {
        String port;
        String[] portNums;
        StringBuilder sBuf = new StringBuilder();
        if (null == ports) {
            return "";
        }
        String[] stringArray = ports;
        int n = stringArray.length;
        for (int i = 0; i < n && (portNums = (port = stringArray[i]).split("~")).length == 2; ++i) {
            if (portNums[0].equals(portNums[1])) {
                sBuf.append(" =" + portNums[0]);
                continue;
            }
            sBuf.append(" >" + portNums[0] + "&<" + portNums[1]);
        }
        return sBuf.toString();
    }

    class StreamThread
    extends Thread {
        InputStream is;
        PrintStream os;

        StreamThread(InputStream is, PrintStream os) {
            this.is = is;
            this.os = os;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.os.print((char)c);
                }
            }
            catch (IOException ioe) {
                FlowSpecThread.this.logger.error((Object)("error: " + ioe.getMessage()));
            }
        }
    }
}

