/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.flowspec.bgp;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hs.atic.bis.model.FlowSpecBGP;
import com.hs.atic.bis.model.FlowSpecBGPPeer;
import com.hs.atic.bis.model.OutboundDivertTactics;
import com.hs.atic.bis.util.BisDivertUtil;
import com.hs.atic.sdk.bis.service.IFlowSpecBGPPeerService;
import com.hs.atic.sdk.bis.service.IFlowSpecBGPService;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsService;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.lego.core.sdk.util.IPUtil;
import com.huawei.atic.flowspec.bgp.model.FlowSpecDivert;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.util.AticInstallUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class FlowSpecUtil {
    private FlowSpecUtil() {
    }

    public static boolean checkIp(String ip) {
        return FlowSpecUtil.isIpv4(ip) || FlowSpecUtil.isIpv6(ip);
    }

    public static boolean isIpEquals(String ip1, String ip2) {
        if (FlowSpecUtil.isIpv4(ip1) && FlowSpecUtil.isIpv4(ip2) || FlowSpecUtil.isIpv6(ip1) && FlowSpecUtil.isIpv6(ip2)) {
            return 0 == IPUtil.compareTo((String)ip1, (String)ip2);
        }
        return false;
    }

    private static boolean isIpv4(String ip) {
        try {
            return IPUtil.isIpv4((String)ip);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isIpv6(String ip) {
        try {
            return IPUtil.isIpv6((String)ip);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static FlowSpecBGP getFlowSpecBGPInDB() {
        IFlowSpecBGPService flowSpecBGPService = BisDivertUtil.getFlowSpecBGPService();
        FlowSpecBGP bgp = flowSpecBGPService.getFlowSpecBGP();
        if (null == bgp || FlowSpecUtil.checkNull(bgp.getLocalAddress()) || FlowSpecUtil.checkNull(bgp.getBgpRouterId()) || null == bgp.getLocalAs()) {
            return new FlowSpecBGP();
        }
        return bgp;
    }

    public static List<FlowSpecBGPPeer> getFlowSpecBGPPeerInDB() {
        IFlowSpecBGPPeerService flowSpecBGPPeerService = BisDivertUtil.getFlowSpecBGPPeerService();
        List<FlowSpecBGPPeer> bgpPeerList = flowSpecBGPPeerService.findAllPeer();
        return bgpPeerList;
    }

    public static List<FlowSpecDivert> getFlowSpecDivertSInDB() {
        IOutboundDivertTacticsService service = BisDivertUtil.getOutboundDivertTacticsService();
        List<OutboundDivertTactics> divertList = service.getDivertListWithEnable();
        ArrayList<FlowSpecDivert> flowSpecDivertList = new ArrayList<FlowSpecDivert>();
        for (OutboundDivertTactics outboundDivert : divertList) {
            FlowSpecDivert flowSpecDivert = FlowSpecUtil.fillFlowSpecDivert(outboundDivert);
            flowSpecDivertList.add(flowSpecDivert);
        }
        return flowSpecDivertList;
    }

    private static FlowSpecDivert fillFlowSpecDivert(OutboundDivertTactics outboundDivert) {
        String desPorts;
        String sourcePorts;
        FlowSpecDivert diverterObject = new FlowSpecDivert();
        diverterObject.setRuleId(outboundDivert.getId());
        diverterObject.setSourceIp(outboundDivert.getSourceIp());
        diverterObject.setDestinationIp(outboundDivert.getDesIp());
        diverterObject.setAction(outboundDivert.getAction());
        if (null != outboundDivert.getThreshold()) {
            if (outboundDivert.getThreshold() / 1000000L == 0L) {
                diverterObject.setLimitRate(outboundDivert.getThreshold() * 1000000L);
            } else {
                diverterObject.setLimitRate(outboundDivert.getThreshold());
            }
        }
        diverterObject.setProtocol(outboundDivert.getProtocol());
        if (null != outboundDivert.getNextHop()) {
            diverterObject.setNextHop(outboundDivert.getNextHop());
        }
        if (null != (sourcePorts = outboundDivert.getSourcePort()) && !"".equals(sourcePorts)) {
            String[] sourceList = sourcePorts.split(",");
            diverterObject.setSourcePort(sourceList);
        }
        if (null != (desPorts = outboundDivert.getDesPort()) && !"".equals(desPorts)) {
            String[] desList = desPorts.split(",");
            diverterObject.setDestinationPort(desList);
        }
        return diverterObject;
    }

    public static boolean checkNull(String str) {
        return StringUtils.isEmpty((String)str);
    }

    public static boolean isOpenFlowSpec() {
        IFlowSpecBGPService flowSpecBGPService = BisDivertUtil.getFlowSpecBGPService();
        FlowSpecBGP bgp = flowSpecBGPService.getFlowSpecBGP();
        if (null == bgp) {
            return false;
        }
        return !FlowSpecUtil.checkNull(bgp.getLocalAddress()) && !FlowSpecUtil.checkNull(bgp.getBgpRouterId()) && null != bgp.getLocalAs();
    }

    public static boolean isSupportFlowSpec() {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        return 1 == version;
    }

    public static int parseResult(Result result) {
        if (null == result) {
            return 5;
        }
        int statusCode = result.getStatusCode();
        if (200 == statusCode) {
            return 0;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.disableDefaultTyping();
        String errDesc = "";
        try {
            Map json = (Map)mapper.readValue(result.getJson(), Map.class);
            errDesc = (String)json.get("errDesc");
        }
        catch (IOException io) {
            return 5;
        }
        if ("Data is null".equals(errDesc)) {
            return 1;
        }
        if ("Data is invalid".equals(errDesc)) {
            return 2;
        }
        if ("Quantity over limit".equals(errDesc)) {
            return 3;
        }
        if ("No data exists".equals(errDesc)) {
            return 4;
        }
        return 5;
    }
}

