/*
 * Decompiled with CFR 0.152.
 */
package com.restful.impl;

import com.hs.atic.collect.util.ConstantUtil;
import com.hs.atic.permission.service.IPermissionService;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.restful.model.RestDivertStatusResult;
import com.restful.model.RestZoneIpInfo;
import com.restful.model.RestfuDivertStatusInfo;
import com.restful.service.RestDivertService;
import com.restful.util.JSONUtil;
import com.restful.util.PermissionCheckUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.struts2.ServletActionContext;

@Path(value="ddos/divert")
public class RestDivertServiceImpl
implements RestDivertService {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private IAticDeviceService aticDeviceService;
    private IDivertTacticsService divertTacticsService;
    private IZoneService zoneService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private IPermissionService permissionService;

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public void setPermissionService(IPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createDivert(String json) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/divert");
        String requestMsg = "createDivert by zoneip. restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"ddos/divert");
            requestMsg = "createDivert by zoneip. restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            String jsonResult2 = this.createJsonResult(responseCode, "Illegal token");
            return responseBuilder.entity((Object)jsonResult2).build();
        }
        LOG.info((Object)("is Legal Token,json: " + json));
        RestZoneIpInfo restZoneIpInfo = null;
        try {
            this.checkJson(json);
            restZoneIpInfo = (RestZoneIpInfo)JSONUtil.getInstance().fromJSON(json, RestZoneIpInfo.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            String jsonResult3 = this.createJsonResult(responseCode, "Json format error");
            return builder.entity((Object)jsonResult3).build();
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2222L) && operationIds.contains(2225L))) {
            responseMsg = "current user can not create divert.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            String jsonResult4 = this.createJsonResult(responseCode, responseMsg);
            return builder.entity((Object)jsonResult4).build();
        }
        List<String> zoneIps = restZoneIpInfo.getZoneIp();
        if (null == zoneIps || zoneIps.size() < 1) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"json format error.");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            String jsonResult5 = this.createJsonResult(responseCode, "Json format error");
            return builder.entity((Object)jsonResult5).build();
        }
        if (zoneIps.size() > 50) {
            LOG.error((Object)"createDivert zoneIps length exceeds the 50 limit.");
            responseMsg = "createDivert zoneIps length exceeds the 50 limit.";
            responseCode = 413;
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        List cleanNeList = this.aticDeviceService.getCleanDevice(userId);
        if (cleanNeList.isEmpty()) {
            responseMsg = "The current user does not have the resources for this";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            detailPara[2] = responseCode + ", " + responseMsg;
            String[] params = new String[]{terminalIp, userName, "atic.restful.create.divert.byzoneip", "atic.restful.device"};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            return responseBuilder.status(responseCode).entity((Object)responseMsg).build();
        }
        HashMap diverts = new HashMap();
        for (String string : zoneIps) {
            ArrayList<AticDevice> cleanNes = new ArrayList<AticDevice>();
            for (AticDevice cleanNe : cleanNeList) {
                if (this.checkIpMark(string)) {
                    String[] zoneIpDetails = string.split("/");
                    String[] rangeIps = null;
                    rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
                    DivertTacticsForm divertTacticsForm = new DivertTacticsForm();
                    divertTacticsForm.setDeviceId(Long.valueOf(cleanNe.getMoId()));
                    divertTacticsForm.setStartIp(rangeIps[0]);
                    divertTacticsForm.setEndIp(rangeIps[1]);
                    List<DivertTacticsForm> existForms = this.divertTacticsService.getConflictDivert(divertTacticsForm);
                    if (null != existForms && !existForms.isEmpty()) {
                        if (1 == existForms.size() && IPUtil4Atic.convert2CompleteIp((String)rangeIps[0]).equals(existForms.get(0).getStartIp()) && IPUtil4Atic.convert2CompleteIp((String)rangeIps[1]).equals(existForms.get(0).getEndIp())) {
                            if (0 != existForms.get(0).getDivertStatus()) continue;
                            cleanNes.add(cleanNe);
                            diverts.put(string, cleanNes);
                            continue;
                        }
                        responseCode = 409;
                        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("divert ip exist. divert ip is " + string));
                        responseBuilder = responseBuilder.status(responseCode);
                        String jsonResult6 = this.createJsonResult(responseCode, "");
                        return responseBuilder.entity((Object)jsonResult6).build();
                    }
                    cleanNes.add(cleanNe);
                    diverts.put(string, cleanNes);
                    continue;
                }
                responseCode = 400;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("the zone ip format is not correct. zoneIp is " + string));
                responseBuilder = responseBuilder.status(responseCode);
                String jsonResult7 = this.createJsonResult(responseCode, "the zone ip format is not correct. zoneIp is " + string);
                return responseBuilder.entity((Object)jsonResult7).build();
            }
        }
        try {
            for (Map.Entry entry : diverts.entrySet()) {
                this.deployDivesion((String)entry.getKey(), (List)entry.getValue(), this.divertTacticsService, userName, terminalIp);
            }
        }
        catch (LegoCheckedException e) {
            void var20_37;
            String string = "";
            String curResponseMsg = "";
            if (e.getErrorCode() == 571211L) {
                responseCode = 409;
                responseBuilder = responseBuilder.status(responseCode);
                String string2 = this.createJsonResult(responseCode, "");
            } else {
                responseCode = 507;
                responseBuilder = responseBuilder.status(responseCode);
                curResponseMsg = this.createErrorDeatil(e);
                String string3 = this.createJsonResult(responseCode, curResponseMsg);
            }
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("deploy the diversion failed. zoneIps is " + zoneIps), (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            String[] params = new String[]{terminalIp, userName, "atic.restful.create.divert.byzoneip", "atic.restful.device"};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            return responseBuilder.entity((Object)var20_37).build();
        }
        catch (Exception e) {
            responseCode = 500;
            responseBuilder = responseBuilder.status(responseCode);
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("unkown exception. deploy the diversion failed. zoneIps is " + zoneIps), (Exception)e);
            detailPara[2] = responseCode + "";
            String[] stringArray = new String[]{terminalIp, userName, "atic.restful.create.divert.byzoneip", "atic.restful.device"};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])stringArray, (boolean)true);
            String jsonResult8 = this.createJsonResult(responseCode, "");
            return responseBuilder.entity((Object)jsonResult8).build();
        }
        responseCode = 201;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"createDivert by zoneip succeed");
        detailPara[2] = responseCode + "";
        String[] params = new String[]{terminalIp, userName, "atic.restful.create.divert.byzoneip", "atic.restful.device"};
        RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
        responseBuilder = responseBuilder.status(responseCode);
        String string = this.createJsonResult(responseCode, "Create Divert by zoneip succeed");
        return responseBuilder.entity((Object)string).build();
    }

    private String createErrorDeatil(LegoCheckedException e) {
        String curResponseMsg = ConstantUtil.getMessage((String)("lego.error.rest.divert." + e.getErrorCode()), (String)"AticResources", (Locale)Locale.ENGLISH);
        return curResponseMsg;
    }

    private String createJsonResult(int responseCode, String responseMsg) {
        HashMap<String, String> resultDetail = new HashMap<String, String>();
        resultDetail.put("errorCode", responseCode + "");
        if (null == responseMsg || responseMsg.trim().length() == 0) {
            responseMsg = ConstantUtil.getMessage((String)("lego.error.rest.divert." + responseCode), (String)"AticResources", (Locale)Locale.ENGLISH);
        }
        resultDetail.put("errorDetail", responseMsg);
        String jsonResult = "";
        try {
            jsonResult = JSONUtil.getInstance().toJSON(resultDetail);
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage());
            jsonResult = "{}";
        }
        return jsonResult;
    }

    private void deployDivesion(String zoneIp, List<AticDevice> cleanNeList, IDivertTacticsService currentDivertBlackholeService, String userName, String terminalIp) {
        String[] zoneIpDetails = zoneIp.split("/");
        DivertTacticsForm divertTacticsForm = this.initDivertTacticsForm(zoneIp, zoneIpDetails);
        Long id = this.zoneService.getZoneIdByIpAndMask(zoneIpDetails[0], Integer.parseInt(zoneIpDetails[1]));
        boolean isDeploy = false;
        for (AticDevice device : cleanNeList) {
            boolean dtdFlag = this.isDeliverTrafficDiversion(divertTacticsForm, device, id);
            if (!dtdFlag) continue;
            divertTacticsForm.setOperator(userName);
            divertTacticsForm.setClientIp(terminalIp + "(restful)");
            currentDivertBlackholeService.deployAndSaveDivertTactics(divertTacticsForm, 1, false);
            isDeploy = true;
        }
        if (!isDeploy) {
            throw new LegoCheckedException(571213L);
        }
    }

    private boolean isDeliverTrafficDiversion(DivertTacticsForm divertTacticsForm, AticDevice device, Long id) {
        ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm;
        long zoneId = 0L;
        if (null != id) {
            zoneId = id;
        } else {
            divertTacticsForm.setZoneId(null);
            LOG.error((Object)"getZoneIdByIpAndMask(),zoneId is null!");
        }
        if (1L != zoneId) {
            divertTacticsForm.setZoneId(Long.valueOf(zoneId));
        }
        divertTacticsForm.setDeviceId(Long.valueOf(device.getMoId()));
        divertTacticsForm.setDeviceName(device.getName());
        if (null != divertTacticsForm.getZoneId() && null == (zoneDeviceDeployStatusForm = this.zoneDeviceDeployStatusService.getByZoneIdAndDeviceId(Long.valueOf(zoneId), Long.valueOf(device.getMoId())))) {
            divertTacticsForm.setZoneId(null);
        }
        if (null == divertTacticsForm.getZoneId()) {
            zoneId = this.zoneService.getDeployDefaultZoneByDeviceId(Long.valueOf(device.getMoId()));
            if (0L != zoneId) {
                divertTacticsForm.setZoneId(Long.valueOf(zoneId));
            } else {
                return false;
            }
        }
        return true;
    }

    private DivertTacticsForm initDivertTacticsForm(String zoneIp, String[] zoneIpDetails) {
        DivertTacticsForm divertTacticsForm = new DivertTacticsForm();
        divertTacticsForm.setDivertIp(zoneIpDetails[0]);
        divertTacticsForm.setMask(Integer.valueOf(Integer.parseInt(zoneIpDetails[1])));
        divertTacticsForm.setDivertIpAndMask(zoneIp);
        divertTacticsForm.setCreateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        String[] rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
        divertTacticsForm.setStartIp(rangeIps[0]);
        divertTacticsForm.setEndIp(rangeIps[1]);
        divertTacticsForm.setDivertMode(Integer.valueOf(2));
        return divertTacticsForm;
    }

    @Override
    @DELETE
    @Path(value="/{zone_ip}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteDivert(@PathParam(value="zone_ip") String zoneIp) {
        String[] params;
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/divert/{zone_ip}");
        String requestMsg = "deleteDivert by zoneip. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/divert/" + zoneIp));
            requestMsg = "deleteDivert by zoneip. restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = "null";
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        LOG.info((Object)("is Legal Token,zoneIp: " + zoneIp));
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2226L) && operationIds.contains(2223L))) {
            String responseMsg = "current user can not delete divert.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        String startIp = "";
        String endIp = "";
        if (IPUtil.isIpv4((String)zoneIp) || IPUtil.isIpv6((String)zoneIp)) {
            startIp = zoneIp;
            endIp = zoneIp;
        } else if (zoneIp.contains("-")) {
            try {
                String[] zoneIpDetails = zoneIp.split("-");
                String[] rangeIps = IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
                startIp = rangeIps[0];
                endIp = rangeIps[1];
            }
            catch (Exception e) {
                responseCode = 400;
                RestUtil.processSysLog((String)"error ", (int)responseCode, (String)"check IP failed.", (Exception)e);
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed. becuase the divert ip error.");
                responseBuilder = responseBuilder.status(responseCode);
                responseBuilder.entity((Object)"delete diversion task failed. becuase the divert ip error.");
                return responseBuilder.build();
            }
        } else {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed. becuase the divert ip error.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"delete diversion task failed. becuase the divert ip error.");
            return responseBuilder.build();
        }
        List divertTacticsForms = this.divertTacticsService.getDivertTacticsByIp(startIp, endIp);
        if (divertTacticsForms.isEmpty()) {
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed. becuase the divert ip not exist.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"delete diversion task failed. becuase the divert ip not exist.");
            return responseBuilder.build();
        }
        Response response = this.checkDevicePermission(userName, divertTacticsForms);
        if (200 != response.getStatus()) {
            responseCode = 455;
            String responseMsg = "The current user does not have the resources for this zone.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(divertTacticsForm.getId().longValue());
            bo.setTargetName("(" + divertTacticsForm.getDeviceName() + ", IP :" + zoneIp + ")");
            boList.add(bo);
        }
        BatchOperationResult boResult = this.divertTacticsService.deleteDivertTactics(boList, true, userName, terminalIp + "(restful)");
        if (boResult.getFailCount() > 0) {
            responseCode = 500;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion task failed.");
            detailPara[2] = responseCode + "";
            params = new String[]{terminalIp, userName, "atic.restful.delete.divert.byzoneip", "atic.restful.device"};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"delete diversion task failed.");
        } else {
            responseCode = 200;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"delete diversion succeed.");
            detailPara[2] = responseCode + "";
            params = new String[]{terminalIp, userName, "atic.restful.delete.divert.byzoneip", "atic.restful.device"};
            RestUtil.processOpeLogByTarget((String[])detailPara, (int)responseCode, (String[])params, (boolean)true);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"delete diversion succeed.");
        }
        return responseBuilder.build();
    }

    @Override
    @GET
    @Path(value="/divertstatus/{divert_ip}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response querydivertstatus(@PathParam(value="divert_ip") String divertIp) {
        List operationIds;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"ddos/divert/divertstatus/{divert_ip}");
        String requestMsg = "querydivertstatus by divertIp. restful request is null.";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)("ddos/divert/divertstatus/" + divertIp));
            requestMsg = "querydivertstatus by divertIp. restful request url : " + url + ".";
        }
        int responseCode = 500;
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        boolean isAdmin = "admin".equals(userName);
        if (!(isAdmin || null != (operationIds = this.permissionService.queryUserOperationId(userName)) && operationIds.contains(2221L))) {
            String responseMsg = "current user can not query divert status.";
            responseCode = 455;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        String startIp = "";
        String endIp = "";
        try {
            int subnetmask = 32;
            if (null != divertIp && divertIp.contains(":")) {
                subnetmask = 128;
            }
            String[] rangeIps = IPUtil.getSubnetRange((String)divertIp, (int)subnetmask);
            startIp = rangeIps[0];
            endIp = rangeIps[1];
        }
        catch (RuntimeException e) {
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"query divert status failed. becuase the divert ip is error.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"query divert status failed. becuase the divert ip is error.");
            return responseBuilder.build();
        }
        List<DivertTacticsForm> divertTacticsForms = this.divertTacticsService.getDivertTacticsStatusByIp(startIp, endIp);
        if (null == divertTacticsForms || divertTacticsForms.isEmpty()) {
            responseCode = 404;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"the divert ip is not exist in diversion task!");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"the divert ip is not exist in diversion task!");
            return responseBuilder.build();
        }
        Response response = this.checkDevicePermission(userName, divertTacticsForms);
        if (200 != response.getStatus()) {
            responseCode = 455;
            String responseMsg = "The current user does not have the resources for this zone.";
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)responseMsg);
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)responseMsg);
            return responseBuilder.build();
        }
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        List devices = this.aticDeviceService.getCleanDevice(userId);
        ArrayList<DivertTacticsForm> zeroDivert = new ArrayList<DivertTacticsForm>();
        ArrayList<DivertTacticsForm> oneDivert = new ArrayList<DivertTacticsForm>();
        RestDivertStatusResult result = new RestDivertStatusResult();
        ArrayList<RestfuDivertStatusInfo> divertStatus = new ArrayList<RestfuDivertStatusInfo>();
        RestfuDivertStatusInfo info = null;
        if (devices.size() > divertTacticsForms.size()) {
            boolean oneFlag = false;
            for (AticDevice device : devices) {
                boolean flag = false;
                info = new RestfuDivertStatusInfo();
                for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                    if (device.getMoId() != divertTacticsForm.getDeviceId().longValue()) continue;
                    info.setDeviceName(device.getName());
                    if (0 == divertTacticsForm.getDivertStatus()) {
                        info.setMessage("diversion task disable!");
                    } else {
                        info.setMessage("diversion task enable!");
                        oneFlag = true;
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    info.setDeviceName(device.getName());
                    info.setMessage("diversion task is not exist!");
                }
                divertStatus.add(info);
            }
            if (!oneFlag) {
                responseCode = 507;
                RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"Not diverted. ");
                responseBuilder.status(responseCode);
                return responseBuilder.build();
            }
            responseCode = 508;
            result.setResult("Partial Diversion");
            result.setDivertStatus(divertStatus);
            String jsonResult = this.formatDivertStatusResult(result);
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("Partial Diversion. " + jsonResult));
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)jsonResult);
            return responseBuilder.build();
        }
        for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
            if (0 == divertTacticsForm.getDivertStatus()) {
                zeroDivert.add(divertTacticsForm);
                continue;
            }
            oneDivert.add(divertTacticsForm);
        }
        if (!oneDivert.isEmpty() && !zeroDivert.isEmpty()) {
            for (AticDevice device : devices) {
                info = new RestfuDivertStatusInfo();
                for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                    if (device.getMoId() != divertTacticsForm.getDeviceId().longValue()) continue;
                    info.setDeviceName(device.getName());
                    if (0 == divertTacticsForm.getDivertStatus()) {
                        info.setMessage("diversion task disable!");
                        break;
                    }
                    info.setMessage("diversion task enable!");
                    break;
                }
                divertStatus.add(info);
            }
            responseCode = 508;
            result.setResult("Partial Diversion");
            result.setDivertStatus(divertStatus);
            String jsonResult = this.formatDivertStatusResult(result);
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)("Partial Diversion. " + jsonResult));
            responseBuilder.status(responseCode);
            responseBuilder.entity((Object)jsonResult);
            return responseBuilder.build();
        }
        if (oneDivert.isEmpty()) {
            responseCode = 507;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"Not diverted. ");
            responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"In diverting. ");
        responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    private Response checkDevicePermission(String userName, List<DivertTacticsForm> divertTacticsForms) {
        ArrayList<Long> moIdlist = new ArrayList<Long>();
        for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
            moIdlist.add(divertTacticsForm.getDeviceId());
        }
        return PermissionCheckUtil.checkRestfulUserSecurity((String)userName, moIdlist);
    }

    private String formatDivertStatusResult(RestDivertStatusResult result) {
        String jsonResult = "";
        try {
            jsonResult = JSONUtil.getInstance().toJSON((Object)result);
        }
        catch (Exception e) {
            RestUtil.processSysLog((String)"divert", (int)500, (String)"convert the format from java to json  failed.", (Exception)e);
        }
        return jsonResult;
    }

    private void checkJson(String json) {
        if (null != json && json.trim().length() > 5000) {
            throw new IllegalArgumentException("the parameters of json is more than 5000.");
        }
    }

    private boolean checkIpMark(String zoneIpCheck) {
        try {
            if (!zoneIpCheck.contains("/")) {
                return false;
            }
            String[] zoneIpDetails = zoneIpCheck.split("/");
            IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
        }
        catch (Exception ew) {
            return false;
        }
        return true;
    }
}

