/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class Buffer<T> {
    protected static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    protected int size;
    protected boolean limit = false;
    protected List<T> list;
    protected ReentrantLock lock = new ReentrantLock();
    protected int dropSize;

    public Buffer(int size) {
        this.size = size;
        this.limit = true;
        this.list = new ArrayList<T>(size);
    }

    public Buffer() {
        this.list = new ArrayList<T>();
    }

    public void addPacket(T t) {
        this.lock.lock();
        try {
            if (this.limit && this.list.size() > this.size) {
                LOGGER.error((Object)("drop a packet cause limit and list.size " + this.list.size() + " > size " + this.size));
                ++this.dropSize;
            } else {
                this.list.add(t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addPacketList(List<T> pList) {
        this.lock.lock();
        try {
            if (this.limit && this.list.size() >= this.size) {
                LOGGER.error((Object)("drop all packets cause limit and list.size " + this.list.size() + " > size " + this.size));
                this.dropSize += pList.size();
            } else {
                this.list.addAll(pList);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addBuffer(Buffer<T> buffer) {
        this.lock.lock();
        try {
            this.list.addAll(buffer.getPackets());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.list.clear();
            if (this.limit && this.dropSize > 0) {
                LOGGER.warn((Object)("Drop size is " + this.dropSize));
                this.dropSize = 0;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> getPackets() {
        this.lock.lock();
        try {
            if (!this.list.isEmpty() && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("in buffer there are " + this.list.size() + " Packets"));
            }
            ((ArrayList)this.list).trimToSize();
            List<T> result = this.list;
            if (this.limit) {
                this.list = new ArrayList<T>(this.size);
                if (this.dropSize > 0) {
                    LOGGER.warn((Object)("Drop size is " + this.dropSize));
                    this.dropSize = 0;
                }
            } else {
                this.list = new ArrayList<T>();
            }
            List<T> list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPacketsNum() {
        this.lock.lock();
        try {
            if (null != this.list) {
                int n = this.list.size();
                return n;
            }
        }
        finally {
            this.lock.unlock();
        }
        return 0;
    }
}

