/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.TimeTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public abstract class Consumer<T>
extends Thread {
    protected static final int DEFAULT_WAIT_TIME = 100;
    protected static final int DEFAULT_CYCLE_NUM = 100;
    protected Logger logger = LogManager.getInstance().getReceiveLog();
    protected long previouseTimeStamp = System.currentTimeMillis() / 1000L;
    protected long previouseTimeStamp4WaitTime = System.currentTimeMillis() / 1000L;
    protected int waitTime = 100;
    protected int cycleNum = 100;
    private Buffer<T> buffer;
    private ConcurrentLinkedQueue<T> packetQueue;
    private boolean stop = false;

    public void consume() {
        List<Object> packets = new ArrayList();
        if (this.packetQueue != null) {
            if (!this.packetQueue.isEmpty()) {
                T packet;
                for (int i = 0; i < this.cycleNum && (packet = this.packetQueue.poll()) != null; ++i) {
                    packets.add(packet);
                }
            }
            this.proceedPacket(packets);
        } else if (this.buffer != null) {
            packets = this.buffer.getPackets();
            this.waitTime = !packets.isEmpty() ? 0 : 100;
            this.proceedPacket(packets);
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                if (System.currentTimeMillis() / 1000L + 3600L < this.previouseTimeStamp) {
                    this.logger.error((Object)("System time error, previouse time Stamp in collector is" + this.previouseTimeStamp + LogManager.NEXT_LINE + " current time is " + System.currentTimeMillis() + ". And collector will drop all logs before next time " + this.previouseTimeStamp));
                } else {
                    this.previouseTimeStamp = System.currentTimeMillis() / 1000L;
                    this.consume();
                }
            }
            catch (OutOfMemoryError error) {
                try {
                    this.logger.error((Object)("OutOfMemoryError buffer size is : " + this.buffer.getPackets().size()));
                    this.buffer.clear();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("consumer interupted after memory  error!" + e.getMessage()));
                    }
                    this.logger.fatal((Object)"when process packets , error happens, memory used over");
                }
                catch (Exception e) {
                    this.processLoggerIsNull(this.logger, error, e);
                }
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("when process packets , error happens." + e.getMessage()));
                }
                catch (Exception e2) {
                    this.processLoggerIsNull(this.logger, e, e2);
                }
            }
            int waitTimeTemp = this.waitTime;
            if (System.currentTimeMillis() / 1000L - this.previouseTimeStamp4WaitTime > 300L) {
                this.waitTime = 500;
                this.previouseTimeStamp4WaitTime = System.currentTimeMillis() / 1000L;
            }
            try {
                if (this.waitTime > 0) {
                    Thread.sleep(this.waitTime);
                }
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Thread sleep in error");
            }
            this.waitTime = waitTimeTemp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLoggerIsNull(Logger log, Throwable error, Throwable e) {
        if (null == log) {
            String projectPath = AticInstallUtil.getInstance().getCollectorInstallPath();
            File logFile = new File(projectPath + File.separator + "errorLog.txt");
            if (!logFile.exists()) {
                try {
                    if (!logFile.createNewFile()) {
                        this.logger.error((Object)"createNewFile in error");
                    }
                }
                catch (IOException localIOException1) {
                    this.logger.error((Object)"createNewFile in error");
                }
            }
            FileWriter writer = null;
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF-8"));
                bw.write(TimeTransformer.transferlong2String(System.currentTimeMillis()) + ",first error:" + error.getMessage());
                bw.newLine();
                bw.write(TimeTransformer.transferlong2String(System.currentTimeMillis()) + ",second error:" + e.getMessage());
                bw.newLine();
                bw.flush();
                this.freeDbResource(writer, bw);
            }
            catch (IOException localIOException2) {
                this.logger.error((Object)"processLoggerIsNull error");
            }
            finally {
                this.freeDbResource(writer, bw);
            }
        }
    }

    public void freeDbResource(FileWriter writer, BufferedWriter bw) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException localIOException5) {
                this.logger.error((Object)"FileWriter close in error");
            }
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (IOException localIOException6) {
                this.logger.error((Object)"BufferedWriter close in error");
            }
        }
    }

    public void setBuffer(Buffer<T> buffer) {
        this.buffer = buffer;
    }

    public Buffer<T> getBuffer() {
        return this.buffer;
    }

    public ConcurrentLinkedQueue<T> getPacketQueue() {
        return this.packetQueue;
    }

    public void setPacketQueue(ConcurrentLinkedQueue<T> packetQueue) {
        this.packetQueue = packetQueue;
    }

    public int getCycleNum() {
        return this.cycleNum;
    }

    public void setCycleNum(int cycleNum) {
        this.cycleNum = cycleNum;
    }

    public void stopCosume() {
        this.logger.info((Object)"consumer is stopped");
        this.stop = true;
    }

    protected abstract void proceedPacket(List<T> var1);
}

