/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import java.util.ArrayList;
import java.util.List;

public class CounterBuffer<T extends TimeDatagramPacket>
extends Buffer<T> {
    private int totalCount;
    private int packetResolvedRate;
    private long lastCounterTime;
    private int unresolvedPacketCount;
    private long unresolvedPacketMemory;

    public CounterBuffer() {
    }

    public CounterBuffer(int size) {
        super(size);
    }

    @Override
    public void addPacket(T t) {
        this.lock.lock();
        try {
            if (this.limit && this.list.size() > this.size) {
                ++this.dropSize;
            } else {
                this.list.add(t);
                ++this.unresolvedPacketCount;
                this.unresolvedPacketMemory += (long)(200 + ((TimeDatagramPacket)t).getData().length);
                ++this.totalCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<T> getPackets() {
        this.lock.lock();
        try {
            if (!this.list.isEmpty() && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("in buffer there are " + this.list.size() + " Packets"));
            }
            ((ArrayList)this.list).trimToSize();
            List result = this.list;
            if (this.limit) {
                this.list = new ArrayList(this.size);
                if (this.dropSize > 0) {
                    LOGGER.error((Object)("Drop packets size is " + this.dropSize));
                    this.dropSize = 0;
                }
            } else {
                this.list = new ArrayList();
            }
            this.unresolvedPacketCount = 0;
            this.unresolvedPacketMemory = 0L;
            if (System.currentTimeMillis() - this.lastCounterTime > 5000L) {
                this.packetResolvedRate = (int)((long)this.totalCount / ((System.currentTimeMillis() - this.lastCounterTime) / 1000L));
                this.totalCount = 0;
                this.lastCounterTime = System.currentTimeMillis();
            }
            List list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getUnresolvedPacketCount() {
        this.lock.lock();
        try {
            int n = this.unresolvedPacketCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getUnresolvedPacketMemory() {
        this.lock.lock();
        try {
            long l = this.unresolvedPacketMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPacketResolvedRate() {
        return this.packetResolvedRate;
    }
}

