/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz;

import com.hs.atic.bis.model.PcapAnalysisResult;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapAnalysisCbb;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class ParseFingerPrint {
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();

    private ParseFingerPrint() {
    }

    public static List<PcapAnalysisResult> parse(String protocol, String fileName) {
        LOGGER.info((Object)"begin to parse...");
        PcapAnalysisCbb pcapAnalysisCbb = null;
        ArrayList<PcapAnalysisResult> analysisResult = new ArrayList<PcapAnalysisResult>();
        String dir = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "pcap";
        String filePath = dir + File.separator + fileName + ".pcap";
        try {
            pcapAnalysisCbb = PcapAnalysisCbb.SYNC_INSTANCE;
            PcapAnalysisResult.ByReference fingerResult = new PcapAnalysisResult.ByReference();
            int resultNumber = pcapAnalysisCbb.startFingerAnalysis(filePath, fingerResult);
            LOGGER.info((Object)("parse state is:" + resultNumber));
            LOGGER.info((Object)("PcapAnalysisResult is:" + fingerResult.toString()));
            analysisResult.add(fingerResult);
        }
        catch (Exception e) {
            LOGGER.error((Object)("parse error." + e.getMessage()));
        }
        LOGGER.info((Object)"end to parse.");
        return analysisResult;
    }
}

