/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.alarm;

import com.hs.atic.collector.biz.alarm.DivertAlarmThread;
import com.hs.atic.collector.biz.alarm.SyslogThread;
import com.hs.atic.collector.biz.event.nfa.NfaAttackSrcFlow;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.IntelligentDefense.IntelligentDefenseThread;
import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.CleanPcapAlarmEntity;
import com.hs.atic.collector.entity.alarm.CycleAlarmEntity;
import com.hs.atic.collector.entity.alarm.DbTableAlarmEntity;
import com.hs.atic.collector.entity.alarm.DiskSpaceAlarmEntity;
import com.hs.atic.collector.entity.alarm.DnsDefendAlarmEntity;
import com.hs.atic.collector.entity.alarm.DropLogAlarmEntity;
import com.hs.atic.collector.entity.alarm.DynBlistAlarmEntity;
import com.hs.atic.collector.entity.alarm.IPReputationEntity;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpFlowInfo;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.alarm.MemoryAlarmEntity;
import com.hs.atic.collector.entity.blackhole.ConfigBlackholeNpEntity;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.FirstPageEvent;
import com.hs.atic.collector.entity.event.IPReputationEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.AttackTypeConstants;
import com.hs.atic.collector.util.BlackHoleNpCommandUtil;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.FaultSeverityRuleUtil;
import com.hs.atic.collector.util.FilterNameUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.SyslogServerUtil;
import com.hs.atic.collector.util.ZoneUitl;
import com.hs.atic.rmi.IpStateService;
import com.hs.atic.rmi.PacketNotifyAlarmService;
import com.hs.atic.rmi.StreamMonitorAlarmHandlerService;
import com.hs.atic.rmi.StreamMonitorAlarmInfo;
import com.hs.atic.rmi.ZoneNotifyAlarmService;
import com.hs.atic.sdk.bis.form.ConfigBlackholeNpForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.huawei.atic.rmi.SecneNotifyAlarmService;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public final class AlarmThread
extends Thread {
    public static final int FAULT_SEVERITY_NONE = 0;
    public static final int FAULT_ACTION_NONE = 0;
    private static final int FAULT_ACTION_DIVERT = 1;
    private static final int FAULT_ACTION_DIVERT_LINKAGE = 2;
    private static final int FAULT_ACTION_BLACKHOLE = 3;
    private static final int FAULT_ACTION_BLACKHOLE_API = 4;
    private static final int FAULT_ACTION_OUTBOUND_DIVERT = 5;
    private static final int FAULT_ACTION_BLACKHOLE_INTERFACE_BOARD = 6;
    private static final int FAULT_ACTION_STOP_DIVERT = 9;
    private static final int FAULT_ACTION_OUTBOUND_STOP_DIVERT = 98;
    private static final int FAULT_ACTION_SECOND_BLACKHOLE = 99;
    private static final String SECNE_SERVICE_NAME = "SecneNotifyAlarmService";
    private static final String ZONE_SERVICE_NAME = "ZoneNotifyAlarmService";
    private static final String SERVICE_NAME_PACKET = "PacketNotifyAlarmService";
    private static final String SERVICE_NAME_IPSTATE = "IpStateService";
    private static final String SERVICE_NAME_STREAM_MONITOR = "StreamMonitorAlarmHandlerService";
    private static final String[] DEVICE_TYPE = new String[]{"CLEAN", "DETECT"};
    private static final int CHECKED_FLAG = 1;
    private static AlarmThread instance = new AlarmThread();
    private static int alarmSizeLimit = 10000;
    private Map<String, Map<IpInfoKey, IpFlowInfo>> ipFlow70secMap = new ConcurrentHashMap<String, Map<IpInfoKey, IpFlowInfo>>();
    private Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = new ConcurrentHashMap<IpInfoKey, IpAlarmEntity>();
    private Set<IpInfoKey> waitNotifyIpSet = Collections.synchronizedSet(new HashSet());
    private List<DynBlistAlarmEntity> dynBlistAlarmEntityList = new ArrayList<DynBlistAlarmEntity>();
    private List<CleanPcapAlarmEntity> cleanPcapAlarmList = new ArrayList<CleanPcapAlarmEntity>();
    private List<DnsDefendAlarmEntity> dnsDefendAlarmList = new ArrayList<DnsDefendAlarmEntity>();
    private List<DbTableAlarmEntity> dbTableAlarmList = new ArrayList<DbTableAlarmEntity>();
    private List<IPReputationEntity> ipReputationList = new ArrayList<IPReputationEntity>();
    private Set<String> dbTableSet = new HashSet<String>();
    private List<DiskSpaceAlarmEntity> diskSpaceAlarmList = new ArrayList<DiskSpaceAlarmEntity>();
    private List<CycleAlarmEntity> cycleAlarmList = new ArrayList<CycleAlarmEntity>();
    private List<MemoryAlarmEntity> memoryAlarmList = new ArrayList<MemoryAlarmEntity>();
    private List<DropLogAlarmEntity> dropLogAlarmList = new ArrayList<DropLogAlarmEntity>();
    private List<ConfigBlackholeNpEntity> blackHoleNpList = new ArrayList<ConfigBlackholeNpEntity>();
    private List<StreamMonitorAlarmInfo> streamMonitorAlarmList = new ArrayList<StreamMonitorAlarmInfo>();
    private long sleepTime;
    private long sleep = this.sleepTime = 100L;
    private long failureSleepTime = 10000L;
    private int loopCount = 5;
    private Logger logger = LogManager.getInstance().getAlarmLog();
    private String collectorIp = "0.0.0.0";
    private SecneNotifyAlarmService secneNotifyAlarmService;
    private ZoneNotifyAlarmService zoneNotifyAlarmService;
    private PacketNotifyAlarmService packetNotifyAlarmService;
    private IpStateService ipStateService;
    private StreamMonitorAlarmHandlerService streamMonitorAlarmService;
    private SyslogThread syslogThread = SyslogThread.getInstance();
    private DivertAlarmThread blackholeAlarmThread;
    private DivertAlarmThread divertAlarmThread;

    private AlarmThread() {
        this.setName("AlarmThread");
        this.initSysConfig();
    }

    public SecneNotifyAlarmService getSecneNotifyAlarmService() {
        return this.secneNotifyAlarmService;
    }

    public void setSecneNotifyAlarmService(SecneNotifyAlarmService secneNotifyAlarmService) {
        this.secneNotifyAlarmService = secneNotifyAlarmService;
    }

    public ZoneNotifyAlarmService getZoneNotifyAlarmService() {
        return this.zoneNotifyAlarmService;
    }

    public void setZoneNotifyAlarmService(ZoneNotifyAlarmService zoneNotifyAlarmService) {
        this.zoneNotifyAlarmService = zoneNotifyAlarmService;
    }

    public static AlarmThread getInstance() {
        return instance;
    }

    public void initSysConfig() {
        try {
            AlarmThread.setAlarmSizeLimit(Integer.parseInt(EventUtil.getEventConfigProperty("AlarmSizeLimit")));
            this.logger.info((Object)("AlarmSizeLimit :" + alarmSizeLimit));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"read alarm file error!");
        }
        try {
            this.collectorIp = System.getProperty("java.rmi.server.hostname");
            this.logger.info((Object)("CollectorIp :" + this.collectorIp));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"get collectorIp error!");
        }
        SyslogServerUtil.getInstance();
    }

    @Override
    public void run() {
        while (true) {
            this.sendAlarm();
            try {
                Thread.sleep(this.sleep);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("InterruptedException error!" + e.getMessage()));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlarm() {
        if (null != this.getSecneAlarmService() && null != this.getZoneAlarmService() && null != this.getPacketAlarmService() && null != this.getIpStateService() && null != this.getStreamMonitorAlarmService()) {
            List<IPReputationEntity> ipReputationListTemp;
            List<StreamMonitorAlarmInfo> streamMonitorAlarmListTemp;
            List<DropLogAlarmEntity> dropLogAlarmListTemp;
            List<MemoryAlarmEntity> memoryAlarmListTemp;
            List<CycleAlarmEntity> cycleAlarmListTemp;
            List<ConfigBlackholeNpEntity> blackHoleNpListTemp;
            List<DiskSpaceAlarmEntity> diskSpaceAlarmListTemp;
            List<DbTableAlarmEntity> dbTableAlarmListTemp;
            List<DnsDefendAlarmEntity> dnsDefendAlarmListTemp;
            List<CleanPcapAlarmEntity> cleanPcapAlarmListTemp;
            List<DynBlistAlarmEntity> dynBlistAlarmEntityListTemp;
            Set<IpInfoKey> waitNotifyIpSetTemp;
            AlarmThread alarmThread = this;
            synchronized (alarmThread) {
                waitNotifyIpSetTemp = this.waitNotifyIpSet;
                this.waitNotifyIpSet = new HashSet<IpInfoKey>();
                dynBlistAlarmEntityListTemp = this.dynBlistAlarmEntityList;
                this.dynBlistAlarmEntityList = new ArrayList<DynBlistAlarmEntity>();
                cleanPcapAlarmListTemp = this.cleanPcapAlarmList;
                this.cleanPcapAlarmList = new ArrayList<CleanPcapAlarmEntity>();
                dnsDefendAlarmListTemp = this.dnsDefendAlarmList;
                this.dnsDefendAlarmList = new ArrayList<DnsDefendAlarmEntity>();
                dbTableAlarmListTemp = this.dbTableAlarmList;
                this.dbTableAlarmList = new ArrayList<DbTableAlarmEntity>();
                diskSpaceAlarmListTemp = this.diskSpaceAlarmList;
                this.diskSpaceAlarmList = new ArrayList<DiskSpaceAlarmEntity>();
                blackHoleNpListTemp = this.blackHoleNpList;
                this.blackHoleNpList = new ArrayList<ConfigBlackholeNpEntity>();
                cycleAlarmListTemp = this.cycleAlarmList;
                this.cycleAlarmList = new ArrayList<CycleAlarmEntity>();
                memoryAlarmListTemp = this.memoryAlarmList;
                this.memoryAlarmList = new ArrayList<MemoryAlarmEntity>();
                dropLogAlarmListTemp = this.dropLogAlarmList;
                this.dropLogAlarmList = new ArrayList<DropLogAlarmEntity>();
                streamMonitorAlarmListTemp = this.streamMonitorAlarmList;
                this.streamMonitorAlarmList = new ArrayList<StreamMonitorAlarmInfo>();
                ipReputationListTemp = this.ipReputationList;
                this.ipReputationList = new ArrayList<IPReputationEntity>();
            }
            try {
                if (!waitNotifyIpSetTemp.isEmpty()) {
                    Iterator<StreamMonitorAlarmInfo> alarmList = new ArrayList();
                    for (IpInfoKey ipInfoKey : waitNotifyIpSetTemp) {
                        IpAlarmEntity ipAlarmEntity = this.ipAlarmMap.get(ipInfoKey);
                        if (ipAlarmEntity == null) continue;
                        alarmList.add((StreamMonitorAlarmInfo)((Object)ipAlarmEntity));
                    }
                    this.logger.info((Object)("Start notify alert, alarmList size=" + alarmList.size()));
                    Iterator<IpInfoKey> iterator = alarmList.iterator();
                    while (iterator.hasNext()) {
                        IpAlarmEntity alarm = (IpAlarmEntity)((Object)iterator.next());
                        this.logger.info((Object)("notify alert, alarm=" + alarm.toString()));
                    }
                    this.zoneNotifyAlarmService.notifyAlert((List<IpAlarmEntity>)((Object)alarmList));
                    this.modifyIpAlarmState((List<IpAlarmEntity>)((Object)alarmList));
                    waitNotifyIpSetTemp.clear();
                }
                if (!dynBlistAlarmEntityListTemp.isEmpty()) {
                    dynBlistAlarmEntityListTemp.clear();
                }
                if (!cleanPcapAlarmListTemp.isEmpty()) {
                    this.packetNotifyAlarmService.notifyPcapFileCleaned(cleanPcapAlarmListTemp);
                    cleanPcapAlarmListTemp.clear();
                }
                if (!dbTableAlarmListTemp.isEmpty()) {
                    this.secneNotifyAlarmService.notifyDbTableAlert(dbTableAlarmListTemp);
                    dbTableAlarmListTemp.clear();
                }
                if (!diskSpaceAlarmListTemp.isEmpty()) {
                    this.secneNotifyAlarmService.notifyDiskSpaceAlert(diskSpaceAlarmListTemp);
                    diskSpaceAlarmListTemp.clear();
                }
                if (!blackHoleNpListTemp.isEmpty()) {
                    for (ConfigBlackholeNpEntity npEntity : blackHoleNpListTemp) {
                        this.logger.info((Object)("ConfigBlackholeNpEntity, npEntity=" + npEntity.toString()));
                    }
                    this.ipStateService.notifyBlackHoleNpCommend(blackHoleNpListTemp);
                    blackHoleNpListTemp.clear();
                }
                if (!cycleAlarmListTemp.isEmpty()) {
                    this.secneNotifyAlarmService.notifyCycleAlert(cycleAlarmListTemp);
                    cycleAlarmListTemp.clear();
                }
                if (!memoryAlarmListTemp.isEmpty()) {
                    this.secneNotifyAlarmService.notifyMemoryAlert(memoryAlarmListTemp);
                    memoryAlarmListTemp.clear();
                }
                if (!dropLogAlarmListTemp.isEmpty()) {
                    this.secneNotifyAlarmService.notifyDropLogAlert(dropLogAlarmListTemp);
                    dropLogAlarmListTemp.clear();
                }
                if (!streamMonitorAlarmListTemp.isEmpty()) {
                    this.logger.info((Object)("notiry streamMonitorAlarm size=" + streamMonitorAlarmListTemp.size()));
                    for (StreamMonitorAlarmInfo alarmTemp : streamMonitorAlarmListTemp) {
                        this.logger.debug((Object)("notiry streamMonitorAlarm" + alarmTemp.toString()));
                    }
                    this.streamMonitorAlarmService.streamMonitorAlarm(streamMonitorAlarmListTemp);
                    streamMonitorAlarmListTemp.clear();
                }
                if (!ipReputationListTemp.isEmpty()) {
                    this.zoneNotifyAlarmService.notifyIpreputation(ipReputationListTemp);
                    ipReputationListTemp.clear();
                }
            }
            catch (Exception e) {
                this.secneNotifyAlarmService = null;
                this.zoneNotifyAlarmService = null;
                this.packetNotifyAlarmService = null;
                this.ipStateService = null;
                this.streamMonitorAlarmService = null;
                AlarmThread alarmThread2 = this;
                synchronized (alarmThread2) {
                    this.waitNotifyIpSet.addAll(waitNotifyIpSetTemp);
                    this.dynBlistAlarmEntityList.addAll(dynBlistAlarmEntityListTemp);
                    this.cleanPcapAlarmList.addAll(cleanPcapAlarmListTemp);
                    this.dnsDefendAlarmList.addAll(dnsDefendAlarmListTemp);
                    this.dbTableAlarmList.addAll(dbTableAlarmListTemp);
                    this.diskSpaceAlarmList.addAll(diskSpaceAlarmListTemp);
                    this.blackHoleNpList.addAll(blackHoleNpListTemp);
                    this.cycleAlarmList.addAll(cycleAlarmListTemp);
                    this.memoryAlarmList.addAll(memoryAlarmListTemp);
                    this.dropLogAlarmList.addAll(dropLogAlarmListTemp);
                    this.streamMonitorAlarmList.addAll(streamMonitorAlarmListTemp);
                    this.ipReputationList.addAll(ipReputationListTemp);
                    waitNotifyIpSetTemp.clear();
                    dynBlistAlarmEntityListTemp.clear();
                    cleanPcapAlarmListTemp.clear();
                    dnsDefendAlarmListTemp.clear();
                    dbTableAlarmListTemp.clear();
                    diskSpaceAlarmListTemp.clear();
                    blackHoleNpListTemp.clear();
                    cycleAlarmListTemp.clear();
                    memoryAlarmListTemp.clear();
                    dropLogAlarmListTemp.clear();
                    streamMonitorAlarmListTemp.clear();
                    ipReputationListTemp.clear();
                }
                this.logger.error((Object)("sendAlarm error!" + e.getMessage()));
                this.sleep = this.failureSleepTime;
            }
        } else {
            this.sleep = this.failureSleepTime;
            this.logger.info((Object)("set sleep=" + this.sleep + ", when getAlarmService() is null."));
        }
    }

    private synchronized void modifyIpAlarmState(List<IpAlarmEntity> alarmList) {
        for (IpAlarmEntity ipAlarmEntity : alarmList) {
            int action = ipAlarmEntity.getDiversionAction();
            if (action > 0) {
                ipAlarmEntity.setDiverted(true);
                this.logger.info((Object)("Set diverted to true, alarm=" + ipAlarmEntity.toString()));
            }
            IpInfoKey ipInfoKey = new IpInfoKey();
            ipInfoKey.setZoneIp(ipAlarmEntity.getZoneIp());
            ipInfoKey.setDeviceIp(ipAlarmEntity.getDeviceIp());
            ipInfoKey.setDirection(ipAlarmEntity.getDirection());
            ipInfoKey.setDeviceType(ipAlarmEntity.getDeviceType());
            ipInfoKey.setZoneId(ipAlarmEntity.getZoneId());
            if (this.waitNotifyIpSet.contains(ipInfoKey)) continue;
            if (!ipAlarmEntity.isIsAlarm()) {
                ipAlarmEntity.setBlacked(false);
                ipAlarmEntity.setDiverted(false);
                this.ipAlarmMap.remove(ipInfoKey);
                this.logger.info((Object)("remove from ipAlarmMap of " + ipInfoKey.toString()));
                continue;
            }
            ipAlarmEntity.clearEndAbnolmal();
        }
    }

    public synchronized void addAbnormalAlarm(List<AbnormalAlarmEntity> resumeList) {
        ArrayList syslogList = new ArrayList();
        this.logger.info((Object)("* begin addAbnormalAlarm *  resumeList.size:" + resumeList.size()));
        for (AbnormalAlarmEntity alarm : resumeList) {
            int direction = alarm.getDirection();
            IpInfoKey ipInfoKey = new IpInfoKey();
            ipInfoKey.setDeviceIp(alarm.getDeviceIp());
            ipInfoKey.setDirection(direction);
            ipInfoKey.setZoneId(alarm.getZoneId());
            ipInfoKey.setZoneIp(alarm.getZoneIp());
            ipInfoKey.setDeviceType(alarm.getDeviceType());
            IpAlarmEntity ipAlarmEntity = this.ipAlarmMap.get(ipInfoKey);
            if (ipAlarmEntity == null) {
                ipAlarmEntity = new IpAlarmEntity();
                ipAlarmEntity.setZoneIp(ipInfoKey.getZoneIp());
                ipAlarmEntity.setDeviceIp(ipInfoKey.getDeviceIp());
                ipAlarmEntity.setDirection(ipInfoKey.getDirection());
                ipAlarmEntity.setDeviceType(ipInfoKey.getDeviceType());
                ipAlarmEntity.setZoneId(alarm.getZoneId());
                ipAlarmEntity.setBeginTime(alarm.getStartTime());
                ipAlarmEntity.setEndTime(alarm.getEndTime());
                this.ipAlarmMap.put(ipInfoKey, ipAlarmEntity);
            }
            ipAlarmEntity.setCurrConn(alarm.getTcpCurConnNum());
            ipAlarmEntity.setNewConn(alarm.getTcpNewConnNum());
            ipAlarmEntity.setCurrInKbps(alarm.getIpInPeakKbps());
            ipAlarmEntity.setCurrInPps(alarm.getIpInPeakPps());
            ipAlarmEntity.setMaxInPps(alarm.getIpAttackPeakPps());
            ipAlarmEntity.setMaxInKbps(alarm.getIpAttackPeakKbps());
            ipAlarmEntity.setCurrDropKbps(alarm.getDropKbps());
            ipAlarmEntity.setCurrDropPps(alarm.getDropPps());
            ipAlarmEntity.setSeverity(1);
            ipAlarmEntity.setPorts(alarm.getPorts());
            ipAlarmEntity.addAbnolmal(alarm);
            this.logger.info((Object)("addAbnormalAlarm----ipAlarmEntity:" + ipAlarmEntity.toString()));
            this.addWaitNofitySetToThread(ipInfoKey, ipAlarmEntity);
            this.logger.info((Object)("* addAbnormalAlarm * alarm.getDropPacket():" + alarm.getDropPacket()));
            this.checkCreateSyslogOfIPAlarmOrAttack(alarm.getDropPacket(), ipAlarmEntity, direction);
            this.checkCreateSyslogOfAttackDetail(ipAlarmEntity, direction);
            this.logger.info((Object)("* addAbnormalAlarm * syslogList.size:" + syslogList.size()));
        }
        this.logger.info((Object)"* end addAbnormalAlarm");
    }

    private void checkCreateSyslogOfIPAlarmOrAttack(long dropPacket, IpAlarmEntity ipAlarmEntity, int direction) {
        Map<String, Object> keysAndValuesMap = this.syslogThread.getSyslogClienMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        if (null == keys || keys.size() == 0) {
            return;
        }
        HashMap syslogClienMap = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            syslogClienMap.put(keys.get(i), values.get(i));
        }
        if (!syslogClienMap.isEmpty()) {
            for (Map.Entry syslogClientEntry : syslogClienMap.entrySet()) {
                SyslogServerEntity server = ((SyslogClientAbstrat)syslogClientEntry.getValue()).getSyslogServerEntity();
                if (1 != server.getDefaultZoneSyslog() && FoundIDUtil.getInstance().isDefaultZone(ipAlarmEntity.getZoneId())) continue;
                ArrayList<SysLog> syslogList = new ArrayList<SysLog>();
                if (dropPacket > 0L && (1 == server.getAlarmAttackLog() && 1 == direction || 1 == server.getAlarmAttackLogOutbound() && 2 == direction)) {
                    syslogList.addAll(this.createSyslogFromIpAlarmEntity(ipAlarmEntity, server.getAlarmMinLevel()));
                    syslogList.add(this.createAttackAlarmSyslog(ipAlarmEntity));
                }
                if (dropPacket == 0L && (1 == server.getAlarmAbnormityLog() && 1 == direction || 1 == server.getAlarmAbnormityLogOutbound() && 2 == direction)) {
                    syslogList.addAll(this.createSyslogFromIpAlarmEntity(ipAlarmEntity, server.getAlarmMinLevel()));
                }
                if (syslogList.isEmpty()) continue;
                this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), syslogList);
            }
        }
    }

    private SysLog createAttackAlarmSyslog(IpAlarmEntity ipAlarmEntity) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=ip_attack_alarm");
        long zoneIp = IpTransformer.string2LongFormat(ipAlarmEntity.getZoneIp());
        long startTime = ipAlarmEntity.getBeginTime();
        long timeLength = String.valueOf(startTime).length();
        long alramId = zoneIp * (long)Math.pow(10.0, timeLength) + startTime;
        info.add("alarm_id=" + alramId);
        info.add("device_ip=" + ipAlarmEntity.getDeviceIp());
        info.add("device_type=" + DEVICE_TYPE[ipAlarmEntity.getDeviceType()]);
        info.add("direction=" + CommonUtil.getDirectionStr(ipAlarmEntity.getDirection()));
        info.add("zone_id=" + ipAlarmEntity.getZoneId());
        info.add("zone_name=" + ZoneUitl.getInstance().getZoneNameById(ipAlarmEntity.getZoneId()));
        info.add("zone_ip=" + ipAlarmEntity.getZoneIp());
        info.add("start_time=\"" + EventUtil.getTimeStamp(startTime) + "\"");
        long currTime = System.currentTimeMillis();
        info.add("refresh_time=\"" + EventUtil.getTimeStamp(currTime) + "\"");
        info.add("severity=" + ipAlarmEntity.getSeverity());
        info.add("attack_type=" + this.getAttackNames(ipAlarmEntity));
        info.add("attacker_ip=" + this.getAttackerIps(ipAlarmEntity));
        long inPps = ipAlarmEntity.getCurrInPps();
        long inBps = ipAlarmEntity.getCurrInKbps() * 1000L;
        long dorpPps = ipAlarmEntity.getCurrDropPps();
        long dropBps = ipAlarmEntity.getCurrDropKbps() * 1000L;
        info.add("in_pps=" + inPps);
        info.add("in_bps=" + inBps);
        info.add("drop_pps=" + dorpPps);
        info.add("drop_bps=" + dropBps);
        info.add("forward_pps=" + (inPps - dorpPps));
        info.add("forward_bps=" + (inBps - dropBps));
        info.add("attack_status=" + this.getAttackStateDesc(ipAlarmEntity.isIsAlarm()));
        SysLog sysLog = new SysLog();
        sysLog.setContent(info);
        sysLog.setHostName(ipAlarmEntity.getDeviceIp());
        sysLog.setTimeStamp(EventUtil.getTimeStamp(currTime));
        return sysLog;
    }

    private String getAttackStateDesc(boolean alarm) {
        if (alarm) {
            return "ATTACK";
        }
        return "NORMAL";
    }

    private String getAttackerIps(IpAlarmEntity ipAlarmEntity) {
        StringBuffer attackIps = new StringBuffer();
        List<AbnormalAlarmEntity> abnolmalList = ipAlarmEntity.getAbnolmalList();
        if (null == abnolmalList) {
            return "";
        }
        int index = 0;
        attackIps.append("\"");
        for (AbnormalAlarmEntity alarm : abnolmalList) {
            String attacker = alarm.getAttacker();
            if (null == attacker || attacker.isEmpty()) continue;
            if (index > 0) {
                attackIps.append(',');
            }
            attackIps.append(attacker);
            ++index;
        }
        attackIps.append("\"");
        return attackIps.toString();
    }

    private String getAttackNames(IpAlarmEntity ipAlarmEntity) {
        StringBuffer attackNames = new StringBuffer();
        List<AbnormalAlarmEntity> abnolmalList = ipAlarmEntity.getAbnolmalList();
        if (null == abnolmalList) {
            return "\"\"";
        }
        int index = 0;
        attackNames.append("\"");
        for (AbnormalAlarmEntity alarm : abnolmalList) {
            int attackType = alarm.getAlertTypeValue();
            String attackName = "";
            attackName = attackType > 2000 && attackType < 80000 ? FilterNameUtil.getInstance().getFilgerName(attackType - 2000) : (attackType > 80000 ? FilterNameUtil.getInstance().getNPFilgerName(attackType) : AttackTypeConstants.getAttackName(attackType));
            if (null != attackName) {
                if (index > 0) {
                    attackNames.append(',');
                }
                attackNames.append(attackName);
                ++index;
                continue;
            }
            this.logger.error((Object)("get attackName error for attackType=" + attackType + ", alarm IP=" + ipAlarmEntity.getZoneIp()));
        }
        attackNames.append("\"");
        return attackNames.toString();
    }

    public synchronized void addAbnormalAlarmStart(List<ExceptionEvent> exceptionEvents) {
        try {
            ArrayList syslogList = new ArrayList();
            this.logger.info((Object)("* begin addAbnormalAlarmStart *  exceptionEvents.size:" + exceptionEvents.size()));
            for (ExceptionEvent event : exceptionEvents) {
                this.logger.info((Object)("addAbnormalAlarmStart, event:" + event.getIdentifier().toString()));
                IpInfoKey ipInfoKey = new IpInfoKey(event.getIdentifier());
                this.logger.info((Object)("addAbnormalAlarmStart----ipInfoKey: " + ipInfoKey.toString()));
                IntelligentDefenseThread.getInstance().addIpAttackInfo(event, ipInfoKey);
                AbnormalAlarmEntity alarm = this.createAbnormalAlarmEntity(event);
                alarm.setAlarm(true);
                this.logger.info((Object)("addAbnormalAlarmStart----alarm" + alarm.toString()));
                this.logger.info((Object)("addAbnormalAlarmStart----ipInfoKey: " + ipInfoKey.toString()));
                IpAlarmEntity ipAlarmEntity = this.ipAlarmMap.get(ipInfoKey);
                if (ipAlarmEntity == null) {
                    this.logger.info((Object)"addAbnormalAlarmStart, ipAlarmEntity is null.");
                    if (this.ipAlarmMap.size() >= alarmSizeLimit) {
                        this.logger.error((Object)("not create alarm cause ipAlarmMap.size():" + this.ipAlarmMap.size() + ">=" + alarmSizeLimit));
                        continue;
                    }
                    ipAlarmEntity = new IpAlarmEntity(ipInfoKey);
                    ipAlarmEntity.setBeginTime(alarm.getStartTime());
                    this.ipAlarmMap.put(ipInfoKey, ipAlarmEntity);
                }
                this.logger.info((Object)("addAbnormalAlarmStart----ipAlarmEntity:" + ipAlarmEntity.toString()));
                ipAlarmEntity.addAbnolmal(alarm);
                Optional<IpFlowInfo> ipFlowInfoOptional = this.get70secIpFlow(ipInfoKey);
                IpFlowInfo ipFlowInfo = null;
                if (ipFlowInfoOptional.isPresent()) {
                    ipFlowInfo = ipFlowInfoOptional.get();
                    ipAlarmEntity.setCurrConn(ipFlowInfo.getMaxCurrConn());
                    ipAlarmEntity.setNewConn(ipFlowInfo.getMaxNewConn());
                    ipAlarmEntity.setCurrInKbps(ipFlowInfo.getCurrInKbps());
                    ipAlarmEntity.setCurrInPps(ipFlowInfo.getCurrInPps());
                    ipAlarmEntity.setMaxInPps(ipFlowInfo.getMaxInPps());
                    ipAlarmEntity.setMaxInKbps(ipFlowInfo.getMaxInKbps());
                    ipAlarmEntity.setCurrDropKbps(ipFlowInfo.getCurrDropKbps());
                    ipAlarmEntity.setCurrDropPps(ipFlowInfo.getCurrDropPps());
                    ipAlarmEntity.setMaxDropKbps(ipFlowInfo.getMaxDropKbps());
                    ipAlarmEntity.setMaxDropPps(ipFlowInfo.getMaxDropPps());
                } else {
                    ipAlarmEntity.setCurrConn(alarm.getTcpCurConnNum());
                    ipAlarmEntity.setNewConn(alarm.getTcpNewConnNum());
                    ipAlarmEntity.setCurrInKbps(alarm.getIpInPeakKbps());
                    ipAlarmEntity.setCurrInPps(alarm.getIpInPeakPps());
                    ipAlarmEntity.setMaxInPps(alarm.getIpInPeakPps());
                    ipAlarmEntity.setMaxInKbps(alarm.getIpInPeakKbps());
                    ipAlarmEntity.setCurrDropKbps(alarm.getIpAttackPeakKbps());
                    ipAlarmEntity.setCurrDropPps(alarm.getIpAttackPeakPps());
                    ipAlarmEntity.setMaxDropKbps(alarm.getIpAttackPeakKbps());
                    ipAlarmEntity.setMaxDropPps(alarm.getIpAttackPeakPps());
                }
                int oldAction = ipAlarmEntity.getDiversionAction();
                int oldSeverity = ipAlarmEntity.getSeverity();
                int newAction = 0;
                int newSeverity = 0;
                int attackType = event.getAttackType().getTypeValue();
                if (78 == attackType) {
                    newSeverity = 4;
                } else if (73 == attackType) {
                    newSeverity = 4;
                    newAction = 99;
                    this.logger.info((Object)("addAbnormalAlarmStart--HOST_TRAFFIC_OVER_FLOW, newSeverity: " + newSeverity));
                } else if (99 != ipAlarmEntity.getDiversionAction() || !ipAlarmEntity.isContainAttackType(73)) {
                    ConfigBlackholeNpForm blackHoleNpForm = BlackHoleNpCommandUtil.getInstance().decideSeverity(ipInfoKey, ipFlowInfo);
                    if (blackHoleNpForm != null) {
                        ConfigBlackholeNpEntity blackHoleNpEntity = new ConfigBlackholeNpEntity();
                        blackHoleNpEntity.setNpIp(blackHoleNpForm.getNpIp());
                        blackHoleNpEntity.setTimeLong(blackHoleNpForm.getTimeLong());
                        blackHoleNpEntity.setBlackholeThreshold(blackHoleNpForm.getBlackholeThreshold());
                        blackHoleNpEntity.setDeviceIp(ipInfoKey.getDeviceIp());
                        this.blackHoleNpList.add(blackHoleNpEntity);
                        this.logger.info((Object)("black np addAbnormalAlarmStart blackHoleNpEntity deviceIp=" + blackHoleNpEntity.getDeviceIp() + ", npIp=" + blackHoleNpEntity.getNpIp()));
                        newSeverity = 4;
                        newAction = 0;
                    } else {
                        FaultSeverityRule rule = FaultSeverityRuleUtil.getInstance().decideSeverity(ipFlowInfo, alarm, ipAlarmEntity.getBeginTime() - 1000L, ipAlarmEntity.getZoneId(), ipAlarmEntity.getDirection());
                        if (rule != null) {
                            newSeverity = rule.getSeverity();
                            int action = rule.getDiversionAction();
                            newAction = 5 == action && attackType >= 2000 ? 0 : action;
                        } else {
                            newSeverity = 1;
                            newAction = 0;
                        }
                    }
                }
                if (newSeverity <= oldSeverity && this.isAlarmNotSend(ipInfoKey)) {
                    newAction = newAction > oldAction ? newAction : oldAction;
                    newSeverity = newSeverity > oldSeverity ? newSeverity : oldSeverity;
                    this.logger.debug((Object)("Alarm is not send, set high level action=" + newAction + ", severity=" + newSeverity + ", alarm= " + ipAlarmEntity.toString()));
                }
                ipAlarmEntity.setSeverity(newSeverity);
                ipAlarmEntity.setDiversionAction(newAction);
                if (newSeverity >= 1) {
                    this.logger.info((Object)("addAbnormalAlarmStart----newSeverity >= 1 enter-----newSeverity: " + newSeverity));
                    if (newAction != oldAction) {
                        ipAlarmEntity.setBlacked(false);
                        ipAlarmEntity.setDiverted(false);
                        this.logger.info((Object)("Set diverted to false, oldAction=" + oldAction + ", newAction=" + newAction + ", alarm=" + ipAlarmEntity.toString()));
                    }
                    this.addWaitNofitySetToThread(ipInfoKey, ipAlarmEntity);
                }
                this.logger.debug((Object)("* addAbnormalAlarmStart * alarm.getDropPacket(): " + alarm.getDropPacket()));
                this.checkCreateSyslogOfIPAlarmOrAttack(alarm.getDropPacket(), ipAlarmEntity, event.getDirection());
                this.checkCreateSyslogOfAttackDetail(ipAlarmEntity, event.getDirection());
            }
            this.logger.info((Object)"* end addAbnormalAlarmStart *");
            this.logger.info((Object)("* when end addAbnormalAlarmStart * syslogList.size:" + syslogList.size()));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("addAbormalAlarmStart error: " + exceptionEvents + " ," + e.getMessage()));
        }
    }

    private boolean isAlarmNotSend(IpInfoKey ipInfoKey) {
        if (this.waitNotifyIpSet.contains(ipInfoKey) || this.divertAlarmThread.hasAlarm(ipInfoKey) || this.blackholeAlarmThread.hasAlarm(ipInfoKey)) {
            this.logger.info((Object)"isAlarmNotSend is true");
            return true;
        }
        this.logger.info((Object)"isAlarmNotSend is false");
        return false;
    }

    public synchronized void addAbnormalAlarmEnd(List<ExceptionEvent> exceptionEvents) {
        try {
            ArrayList syslogList = new ArrayList();
            this.logger.info((Object)("* begin addAbnormalAlarmEnd *  exceptionEvents.size:" + exceptionEvents.size()));
            for (ExceptionEvent event : exceptionEvents) {
                IpInfoKey ipInfoKey = new IpInfoKey(event.getIdentifier());
                IpAlarmEntity ipAlarmEntity = this.ipAlarmMap.get(ipInfoKey);
                if (ipAlarmEntity == null) continue;
                AbnormalAlarmEntity alarm = this.createAbnormalAlarmEntity(event);
                alarm.setAlarm(false);
                ipAlarmEntity.addAbnolmal(alarm);
                if (ipAlarmEntity.getSeverity() >= 1) {
                    this.waitNotifyIpSet.add(ipInfoKey);
                } else if (!ipAlarmEntity.isIsAlarm()) {
                    this.ipAlarmMap.remove(ipInfoKey);
                }
                IntelligentDefenseThread.getInstance().removeIpAttackInfo(ipInfoKey, event.getAttackType().getTypeValue());
                this.logger.debug((Object)("* addAbnormalAlarmEnd * alarm.getDropPacket():" + alarm.getDropPacket()));
                this.checkCreateSyslogOfIPAlarmOrAttack(alarm.getDropPacket(), ipAlarmEntity, event.getDirection());
                this.checkCreateSyslogOfAttackDetail(ipAlarmEntity, event.getDirection());
            }
            this.logger.info((Object)"* end addAbnormalAlarmEnd * sendSyslogAttackEnabled:");
            this.logger.info((Object)("* when addAbnormalAlarmEnd * syslogList.size:" + syslogList.size()));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("addAbormalAlarmEnd error: " + exceptionEvents + " " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbnormalAlarmEntity createAbnormalAlarmEntity(ExceptionEvent e) {
        AbnormalAlarmEntity alarm = new AbnormalAlarmEntity();
        alarm.setPkId(e.getAbnormalPkId());
        alarm.setDeviceIp(e.getDeviceIp());
        alarm.setDeviceType(e.getDeviceType());
        alarm.setDirection(e.getDirection());
        alarm.setZoneId(e.getZoneId());
        if (e.getIdentifier().isDesZone()) {
            alarm.setZoneIp("-");
        } else {
            alarm.setZoneIp(e.getZoneIp());
        }
        alarm.setAlertTypeValue(e.getAttackType().getTypeValue());
        alarm.setProtocol(e.getAttackType().getProtocol());
        alarm.setPort(e.getAttackType().getPort());
        alarm.setStartTime(e.getAlertStartTime());
        alarm.setEndTime(e.getAlertEndTime() > e.getAttackEndTime() ? e.getAlertEndTime() : e.getAttackEndTime());
        alarm.setLimitValue(e.getNormalValue());
        alarm.setCurrentValue(e.getRealValue());
        alarm.setPpsOrKbps(e.getPpsOrKbps());
        alarm.setLimitValue1(e.getNormalValue1());
        alarm.setCurrentValue1(e.getRealValue1());
        alarm.setPpsOrKbps1(e.getPpsOrKbps1());
        alarm.setMultiCurrent(e.isConnectionFlood());
        alarm.setDropPacket(e.getDropPkgs());
        alarm.setDropKbits(e.getDropKbits());
        alarm.setDropPps(e.getAttackPeakPpsOrQps());
        alarm.setDropKbps(e.getAttackPeakKbps());
        alarm.setCurrMaxDropKbps(e.getCurrMaxDropKbps());
        alarm.setCurrMaxDropPps(e.getCurrMaxDropPps());
        alarm.setIpAttackPeakKbps(e.getIpAttackPeakKbps());
        alarm.setIpAttackPeakPps(e.getIpAttackPeakPps());
        alarm.setIpInPeakKbps(e.getIpInPeakKbps());
        alarm.setIpInPeakPps(e.getIpInPeakPps());
        alarm.setTcpCurConnNum(e.getTcpCurConnNum());
        alarm.setTcpNewConnNum(e.getTcpNewConnNum());
        alarm.setPorts(CommonUtil.tansPortsSet2String(e.getPorts()));
        List<NfaAttackSrcFlow> attackSrcFlowsFlow = e.getAttackerFlowData();
        if (null == attackSrcFlowsFlow || attackSrcFlowsFlow.isEmpty()) {
            StringBuffer attacker = new StringBuffer();
            for (String ip : e.getAttackers()) {
                attacker.append(IPUtil.compressIPv6(ip) + ",");
            }
            if (!CommonUtil.isNull(attacker.toString())) {
                attacker = new StringBuffer(attacker.substring(0, attacker.length() - 1));
            }
            alarm.setAttacker(attacker.toString());
        } else {
            ArrayList<NfaAttackSrcFlow> listCopy = new ArrayList<NfaAttackSrcFlow>();
            StringBuffer attackersBuf = new StringBuffer();
            StringBuffer attackerPpsFlow = new StringBuffer();
            StringBuffer attackerKbpsFlow = new StringBuffer();
            try {
                List<NfaAttackSrcFlow> list = attackSrcFlowsFlow;
                synchronized (list) {
                    listCopy.addAll(attackSrcFlowsFlow);
                }
                for (NfaAttackSrcFlow flow : listCopy) {
                    attackersBuf.append(IPUtil.compressIPv6(flow.getAttackSrcIp())).append(",");
                    attackerPpsFlow.append(flow.getPps()).append(",");
                    attackerKbpsFlow.append(flow.getKbps()).append(",");
                }
                if (attackersBuf.length() > 0) {
                    attackersBuf = new StringBuffer(attackersBuf.substring(0, attackersBuf.length() - 1));
                }
                if (attackerPpsFlow.length() > 0) {
                    attackerPpsFlow = new StringBuffer(attackerPpsFlow.substring(0, attackerPpsFlow.length() - 1));
                }
                if (attackerKbpsFlow.length() > 0) {
                    attackerKbpsFlow = new StringBuffer(attackerKbpsFlow.substring(0, attackerKbpsFlow.length() - 1));
                }
                alarm.setAttacker(attackersBuf.toString());
                alarm.setAttackerPpsFlow(attackerPpsFlow.toString());
                alarm.setAttackerKbpsFlow(attackerKbpsFlow.toString());
            }
            catch (Exception ex) {
                this.logger.error((Object)("process NfaAttackSrcFlow error!" + ex.getMessage()));
            }
        }
        return alarm;
    }

    public synchronized void addCleanPcapAlarmEntity(String diskName, String userLimit, int delNumbers) {
        CleanPcapAlarmEntity entity = new CleanPcapAlarmEntity(diskName, userLimit, delNumbers);
        entity.setCollectorIp(this.collectorIp);
        this.cleanPcapAlarmList.add(entity);
    }

    public synchronized void addDynBlistAlarm(List<DynBlistAlarmEntity> resume) {
        this.dynBlistAlarmEntityList.addAll(resume);
    }

    public synchronized void addDynBlistAlarmEntityStart(List<ZoneBlackListEvent> blackList) {
        for (ZoneBlackListEvent each : blackList) {
            DynBlistAlarmEntity alarm = new DynBlistAlarmEntity(each.getDeviceIp(), each.getZoneId(), each.getZoneIp(), each.getBlackIp(), each.getBlackListMode());
            alarm.setBlackListType(each.getBlackListType());
            alarm.setPort(each.getPort());
            alarm.setProtocol(each.getProtocol());
            alarm.setAlertTime(each.getLogTime());
            alarm.setIsAlarm(true);
            alarm.setZoneIp(each.getZoneIp());
            if (!this.dynBlistAlarmEntityList.contains(alarm)) {
                this.dynBlistAlarmEntityList.add(alarm);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("add addDynBlistAlarmEntityStart :" + alarm));
                continue;
            }
            DynBlistAlarmEntity t = this.dynBlistAlarmEntityList.get(this.dynBlistAlarmEntityList.indexOf(alarm));
            if (t.getIsAlarm().booleanValue()) continue;
            this.dynBlistAlarmEntityList.remove(alarm);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("remove addDynBlistAlarmEntityStart :" + alarm));
        }
    }

    public synchronized void addDynBlistAlarmEntityEnd(List<ZoneBlackListEvent> blackList) {
        for (ZoneBlackListEvent each : blackList) {
            DynBlistAlarmEntity alarm = new DynBlistAlarmEntity(each.getDeviceIp(), each.getZoneId(), each.getZoneIp(), each.getBlackIp(), each.getBlackListMode());
            alarm.setBlackListType(each.getBlackListType());
            alarm.setPort(each.getPort());
            alarm.setProtocol(each.getProtocol());
            alarm.setAlertTime(each.getLogTime());
            alarm.setIsAlarm(false);
            alarm.setZoneIp(each.getZoneIp());
            if (!this.dynBlistAlarmEntityList.contains(alarm)) {
                this.dynBlistAlarmEntityList.add(alarm);
                continue;
            }
            DynBlistAlarmEntity t = this.dynBlistAlarmEntityList.get(this.dynBlistAlarmEntityList.indexOf(alarm));
            if (t.getIsAlarm().booleanValue()) {
                this.dynBlistAlarmEntityList.remove(alarm);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("add addDynBlistAlarmEntityEnd :" + alarm));
                continue;
            }
            this.dynBlistAlarmEntityList.remove(alarm);
            this.dynBlistAlarmEntityList.add(alarm);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("remove addDynBlistAlarmEntityEnd :" + alarm));
        }
    }

    public synchronized void addDnsDefendAlarmStart(List<DnsDefendEvent> dnsList) {
        ArrayList<DnsDefendAlarmEntity> alarmList = new ArrayList<DnsDefendAlarmEntity>();
        for (DnsDefendEvent e : dnsList) {
            DnsDefendAlarmEntity alarm = new DnsDefendAlarmEntity();
            alarm.setAlermTime(System.currentTimeMillis());
            alarm.setDeviceIp(e.getDeviceIp());
            alarm.setDeviceType(e.getDeviceType());
            alarm.setDomainName(e.getDomaiName());
            alarm.setIsAlarm(true);
            alarmList.add(alarm);
        }
        this.dnsDefendAlarmList.addAll(alarmList);
    }

    public synchronized void addIpreputationAlarm(List<IPReputationEvent> ipReputationEvents) {
        ArrayList<IPReputationEntity> ipReputationEntityList = new ArrayList<IPReputationEntity>();
        for (IPReputationEvent e : ipReputationEvents) {
            IPReputationEntity entity = new IPReputationEntity();
            entity.setDeviceIp(e.getDeviceIp());
            entity.setZoneIpRptnEnableTime1(e.getZoneIpRptnEnableTime1());
            entity.setZoneIpRptnEnableTime2(e.getZoneIpRptnEnableTime2());
            entity.setReportTime(e.getReportTime());
            entity.setAtkHitTime1(e.getAtkHitTime1());
            entity.setAtkHitTime2(e.getAtkHitTime2());
            entity.setAtkHitCount(e.getAtkHitCount());
            entity.setAtkBlockTime1(e.getAtkBlockTime1());
            entity.setAtkBlockTime2(e.getAtkBlockTime2());
            entity.setAtkBlockCount(e.getAtkBlockCount());
            entity.setAtkDestIp1(e.getAtkDestIp1());
            entity.setAtkDestIp2(e.getAtkDestIp2());
            entity.setAtkType1(e.getAtkType1());
            entity.setAtkType2(e.getAtkType2());
            entity.setAtkSvcType1(e.getAtkSvcType1());
            entity.setAtkSvcType2(e.getAtkSvcType2());
            entity.setPeaceHitTime1(e.getPeaceHitTime1());
            entity.setPeaceHitTime2(e.getPeaceHitTime2());
            entity.setPeaceHitCount(e.getPeaceHitCount());
            entity.setSrcIp(e.getSrcIp());
            entity.setPeaceDestIp1(e.getPeaceDestIp1());
            entity.setPeaceDestIp2(e.getPeaceDestIp2());
            entity.setPeaceSvcType1(e.getPeaceSvcType1());
            entity.setPeaceSvcType2(e.getPeaceSvcType2());
            ipReputationEntityList.add(entity);
        }
        this.ipReputationList.addAll(ipReputationEntityList);
    }

    public synchronized void addDbTableAlarm(DbTableAlarmEntity dbTableAlarmEntity) {
        String collectorIpAd = System.getProperty("java.rmi.server.hostname");
        dbTableAlarmEntity.setCollectorIp(collectorIpAd);
        this.dbTableAlarmList.add(dbTableAlarmEntity);
        String tableName = dbTableAlarmEntity.getTableName();
        tableName = tableName.toLowerCase(Locale.ENGLISH);
        if (dbTableAlarmEntity.isAlarm()) {
            this.dbTableSet.add(tableName);
        } else {
            this.dbTableSet.remove(tableName);
        }
    }

    public synchronized boolean isTableAlarm(String tableName) {
        tableName = tableName.toLowerCase(Locale.ENGLISH);
        return this.dbTableSet.contains(tableName);
    }

    public synchronized void addCycleAlarm(CycleAlarmEntity cycleAlarmEntity) {
        String collectorIpAd = System.getProperty("java.rmi.server.hostname");
        if (this.cycleAlarmList != null) {
            this.cycleAlarmList.clear();
        } else {
            this.cycleAlarmList = new ArrayList<CycleAlarmEntity>();
        }
        cycleAlarmEntity.setCollectorIp(collectorIpAd);
        this.cycleAlarmList.add(cycleAlarmEntity);
    }

    public synchronized void addMemoryAlarm(MemoryAlarmEntity memoryAlarmEntity) {
        String collectorIpAd = System.getProperty("java.rmi.server.hostname");
        if (this.memoryAlarmList != null) {
            this.memoryAlarmList.clear();
        } else {
            this.memoryAlarmList = new ArrayList<MemoryAlarmEntity>();
        }
        memoryAlarmEntity.setCollectorIp(collectorIpAd);
        this.memoryAlarmList.add(memoryAlarmEntity);
    }

    public synchronized void addDropLogAlarm(DropLogAlarmEntity dropLogAlarmEntity) {
        String collectorIpAd = System.getProperty("java.rmi.server.hostname");
        if (this.dropLogAlarmList != null) {
            this.dropLogAlarmList.clear();
        } else {
            this.dropLogAlarmList = new ArrayList<DropLogAlarmEntity>();
        }
        dropLogAlarmEntity.setCollectorIp(collectorIpAd);
        this.dropLogAlarmList.add(dropLogAlarmEntity);
    }

    public synchronized void addStreamMonitorAlarm(List<StreamMonitorAlarmInfo> alarmList) {
        if (null != alarmList) {
            this.streamMonitorAlarmList.addAll(alarmList);
        }
    }

    private IpStateService getIpStateService() {
        if (null == this.ipStateService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.ipStateService = (IpStateService)CommonUtil.retreiveAticRmiService(SERVICE_NAME_IPSTATE);
                    this.sleepTime = 100L;
                    this.sleep = 100L;
                    this.logger.info((Object)("getIpStateService success, set sleep=" + this.sleep));
                    break;
                }
                catch (Exception e) {
                    this.logger.error((Object)("get getIpStateService failed! " + e.getMessage()));
                    try {
                        this.logger.info((Object)("getIpStateService failureSleepTime=" + this.failureSleepTime));
                        Thread.sleep(this.failureSleepTime);
                    }
                    catch (InterruptedException e2) {
                        this.logger.error((Object)("get InterruptedException!" + e2.getMessage()));
                    }
                    continue;
                }
            }
        }
        return this.ipStateService;
    }

    private SecneNotifyAlarmService getSecneAlarmService() {
        if (null == this.secneNotifyAlarmService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.secneNotifyAlarmService = (SecneNotifyAlarmService)CommonUtil.retreiveAticRmiService(SECNE_SERVICE_NAME);
                    if (this.secneNotifyAlarmService != null) {
                        this.sleepTime = 100L;
                        this.sleep = 100L;
                        this.logger.info((Object)("getSecneAlarmService success, set sleep=" + this.sleep));
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("get getSecneAlarmService failed! " + e.getMessage()));
                }
                try {
                    this.logger.info((Object)("getSecneAlarmService failureSleepTime=" + this.failureSleepTime));
                    Thread.sleep(this.failureSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("get InterruptedException!" + e.getMessage()));
                }
            }
        }
        return this.secneNotifyAlarmService;
    }

    private ZoneNotifyAlarmService getZoneAlarmService() {
        if (null == this.zoneNotifyAlarmService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.zoneNotifyAlarmService = (ZoneNotifyAlarmService)CommonUtil.retreiveAticRmiService(ZONE_SERVICE_NAME);
                    if (this.zoneNotifyAlarmService != null) {
                        this.sleepTime = 100L;
                        this.sleep = 100L;
                        this.logger.info((Object)("getZoneAlarmService success, set sleep=" + this.sleep));
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("get getZoneAlarmService failed! " + e.getMessage()));
                }
                try {
                    this.logger.info((Object)("getZoneAlarmService failureSleepTime=" + this.failureSleepTime));
                    Thread.sleep(this.failureSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("get InterruptedException!" + e.getMessage()));
                }
            }
        }
        return this.zoneNotifyAlarmService;
    }

    private PacketNotifyAlarmService getPacketAlarmService() {
        if (null == this.packetNotifyAlarmService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.packetNotifyAlarmService = (PacketNotifyAlarmService)CommonUtil.retreiveAticRmiService(SERVICE_NAME_PACKET);
                    if (this.packetNotifyAlarmService != null) {
                        this.sleepTime = 100L;
                        this.sleep = 100L;
                        this.logger.info((Object)("getPacketAlarmService success, set sleep=" + this.sleep));
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("get PacketNotifyAlarmService failed! " + e.getMessage()));
                }
                try {
                    this.logger.info((Object)("getPacketAlarmService failureSleepTime=" + this.failureSleepTime));
                    Thread.sleep(this.failureSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("get InterruptedException!" + e.getMessage()));
                }
            }
        }
        return this.packetNotifyAlarmService;
    }

    public StreamMonitorAlarmHandlerService getStreamMonitorAlarmService() {
        if (null == this.streamMonitorAlarmService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.streamMonitorAlarmService = (StreamMonitorAlarmHandlerService)CommonUtil.retreiveAticRmiService(SERVICE_NAME_STREAM_MONITOR);
                    if (this.streamMonitorAlarmService != null) {
                        this.sleepTime = 100L;
                        this.sleep = 100L;
                        this.logger.info((Object)("get StreamMonitorAlarmHandlerService success, set sleep=" + this.sleep));
                        break;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("get StreamMonitorAlarmHandlerService failed! " + e.getMessage()));
                }
                try {
                    this.logger.info((Object)("getStreamMonitorAlarmService failureSleepTime=" + this.failureSleepTime));
                    Thread.sleep(this.failureSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("getStreamMonitorAlarmService!" + e.getMessage()));
                }
            }
        }
        return this.streamMonitorAlarmService;
    }

    public synchronized void addIpFlow(List<Event> events) {
        if (!events.isEmpty()) {
            String deviceIP = events.get(0).getDeviceIp();
            this.ipFlow70secMap.remove(deviceIP);
            for (Event e : events) {
                long newConn;
                long currConn;
                IpFlowInfo ipFlowInfo;
                EventIdentifier temp = e.getIdentifierCopy();
                if (e.isZoneEvent()) {
                    temp.setZoneIp("-1");
                }
                IpInfoKey ipInfoKey = new IpInfoKey(temp);
                if (e.getIdentifier().isIpLocation()) {
                    ipInfoKey.setLocationId(e.getIdentifier().getIpLocationId());
                } else {
                    ipInfoKey.setLocationId(-1L);
                }
                FirstPageEvent event = (FirstPageEvent)((Object)e);
                Optional<IpFlowInfo> ipFlowInfoOptional = this.get70secIpFlow(ipInfoKey);
                if (!ipFlowInfoOptional.isPresent()) {
                    Map<IpInfoKey, IpFlowInfo> flowMap = this.ipFlow70secMap.get(ipInfoKey.getDeviceIp());
                    if (null == flowMap) {
                        flowMap = new HashMap<IpInfoKey, IpFlowInfo>();
                        this.ipFlow70secMap.put(ipInfoKey.getDeviceIp(), flowMap);
                    }
                    ipFlowInfo = new IpFlowInfo();
                    if (e.isZoneEvent()) {
                        ipFlowInfo.setZoneType(true);
                    }
                    flowMap.put(ipInfoKey, ipFlowInfo);
                } else {
                    ipFlowInfo = ipFlowInfoOptional.get();
                }
                if (e.isIsDropFlow()) {
                    if (e.isIsMaxEvent()) {
                        ipFlowInfo.setMaxDropPps(event.getTotalPps());
                        ipFlowInfo.setMaxDropKbps(event.getTotalKbps());
                        continue;
                    }
                    ipFlowInfo.setCurrDropPps(event.getTotalPps());
                    ipFlowInfo.setCurrDropKbps(event.getTotalKbps());
                    continue;
                }
                if (e.isIsForwardFlow()) {
                    if (!e.isIsMaxEvent()) continue;
                    ipFlowInfo.setMaxForwardPps(event.getTotalPps());
                    ipFlowInfo.setMaxForwardKbps(event.getTotalKbps());
                    continue;
                }
                if (e.isIsMaxEvent()) {
                    ipFlowInfo.setMaxInPps(event.getTotalPps());
                    ipFlowInfo.setMaxInKbps(event.getTotalKbps());
                } else {
                    ipFlowInfo.setCurrInPps(event.getTotalPps());
                    ipFlowInfo.setCurrInKbps(event.getTotalKbps());
                }
                if (e instanceof InFlowEvent) {
                    InFlowEvent tempInFlowEvent = (InFlowEvent)e;
                    if (e.isIsMaxEvent()) {
                        currConn = ipFlowInfo.getMaxCurrConn() + tempInFlowEvent.getTcpConcurCon();
                        newConn = ipFlowInfo.getMaxNewConn() + tempInFlowEvent.getTcpIncreaseCon();
                        ipFlowInfo.setMaxCurrConn(currConn);
                        ipFlowInfo.setMaxNewConn(newConn);
                        continue;
                    }
                    currConn = ipFlowInfo.getCurrConn() + tempInFlowEvent.getTcpConcurCon();
                    newConn = ipFlowInfo.getNewConn() + tempInFlowEvent.getTcpIncreaseCon();
                    ipFlowInfo.setCurrConn(currConn);
                    ipFlowInfo.setNewConn(newConn);
                    continue;
                }
                if (!(e instanceof TcpBizFlowEvent)) continue;
                TcpBizFlowEvent tempTcpBizFlowEvent = (TcpBizFlowEvent)e;
                if (e.isIsMaxEvent()) {
                    currConn = ipFlowInfo.getMaxCurrConn() + tempTcpBizFlowEvent.getCurrConn();
                    newConn = ipFlowInfo.getMaxNewConn() + tempTcpBizFlowEvent.getNewConn();
                    ipFlowInfo.setMaxCurrConn(currConn);
                    ipFlowInfo.setMaxNewConn(newConn);
                    continue;
                }
                currConn = ipFlowInfo.getCurrConn() + tempTcpBizFlowEvent.getCurrConn();
                newConn = ipFlowInfo.getNewConn() + tempTcpBizFlowEvent.getNewConn();
                ipFlowInfo.setCurrConn(currConn);
                ipFlowInfo.setNewConn(newConn);
            }
            this.logger.debug((Object)("after addIpFlow, ipFlow70secMap has " + this.ipFlow70secMap.get(deviceIP).size() + " logs of device " + deviceIP));
            this.refreshAlarmSeverity();
        }
    }

    private void refreshAlarmSeverity() {
        this.logger.info((Object)"* refreshAlarmSeverity *");
        for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : this.ipAlarmMap.entrySet()) {
            int newAction;
            int newSeverity;
            IpInfoKey ipInfoKey = entry.getKey();
            IpAlarmEntity ipAlarmEntity = entry.getValue();
            Optional<IpFlowInfo> ipFlowInfoOptional = this.get70secIpFlow(ipInfoKey);
            if (!ipFlowInfoOptional.isPresent()) continue;
            IpFlowInfo ipFlowInfo = ipFlowInfoOptional.get();
            ipAlarmEntity.setCurrConn(ipFlowInfo.getMaxCurrConn());
            ipAlarmEntity.setNewConn(ipFlowInfo.getMaxNewConn());
            ipAlarmEntity.setCurrInKbps(ipFlowInfo.getCurrInKbps());
            ipAlarmEntity.setCurrInPps(ipFlowInfo.getCurrInPps());
            ipAlarmEntity.setMaxInPps(ipFlowInfo.getMaxInPps());
            ipAlarmEntity.setMaxInKbps(ipFlowInfo.getMaxInKbps());
            ipAlarmEntity.setCurrDropKbps(ipFlowInfo.getCurrDropKbps());
            ipAlarmEntity.setCurrDropPps(ipFlowInfo.getCurrDropPps());
            ipAlarmEntity.setMaxDropKbps(ipFlowInfo.getMaxDropKbps());
            ipAlarmEntity.setMaxDropPps(ipFlowInfo.getMaxDropPps());
            if (ipInfoKey.getLocationId() >= 0L) continue;
            int direction = ipAlarmEntity.getDirection();
            int oldSeverity = ipAlarmEntity.getSeverity();
            int oldAction = ipAlarmEntity.getDiversionAction();
            ConfigBlackholeNpForm blackHoleNpForm = BlackHoleNpCommandUtil.getInstance().decideSeverity(ipInfoKey, ipFlowInfo);
            if (blackHoleNpForm != null) {
                ConfigBlackholeNpEntity blackHoleNpEntity = new ConfigBlackholeNpEntity();
                blackHoleNpEntity.setNpIp(blackHoleNpForm.getNpIp());
                blackHoleNpEntity.setTimeLong(blackHoleNpForm.getTimeLong());
                blackHoleNpEntity.setBlackholeThreshold(blackHoleNpForm.getBlackholeThreshold());
                blackHoleNpEntity.setDeviceIp(ipInfoKey.getDeviceIp());
                this.blackHoleNpList.add(blackHoleNpEntity);
                this.logger.info((Object)("black np refreshAlarmSeverity blackHoleNpEntity deviceIp=" + blackHoleNpEntity.getDeviceIp() + ", npIp=" + blackHoleNpEntity.getNpIp()));
                newSeverity = 4;
                newAction = 0;
            } else {
                FaultSeverityRule rule = FaultSeverityRuleUtil.getInstance().decideSeverity(ipFlowInfo, ipAlarmEntity.getBeginTime(), ipAlarmEntity.getZoneId(), ipAlarmEntity.getDirection());
                newSeverity = null == rule ? 1 : rule.getSeverity();
                int n = newAction = null == rule ? 0 : rule.getDiversionAction();
                if (5 == newAction) {
                    boolean isOnlyFilter = true;
                    List<AbnormalAlarmEntity> abnomalList = ipAlarmEntity.getAbnolmalList();
                    for (AbnormalAlarmEntity entity : abnomalList) {
                        if (entity.getAlertTypeValue() >= 2000) continue;
                        isOnlyFilter = false;
                        break;
                    }
                    if (isOnlyFilter) {
                        newAction = 0;
                    }
                }
            }
            if (newSeverity <= oldSeverity && this.isAlarmNotSend(ipInfoKey)) {
                newAction = newAction > oldAction ? newAction : oldAction;
                newSeverity = newSeverity > oldSeverity ? newSeverity : oldSeverity;
                this.logger.debug((Object)("Alarm is not send, set high level action=" + newAction + ", severity=" + newSeverity + ", alarm= " + ipAlarmEntity.toString()));
            }
            if (newSeverity != oldSeverity || newAction != oldAction) {
                ipAlarmEntity.setSeverity(newSeverity);
                ipAlarmEntity.setDiversionAction(newAction);
                if (newAction != oldAction) {
                    ipAlarmEntity.setBlacked(false);
                    ipAlarmEntity.setDiverted(false);
                    this.logger.info((Object)("Set diverted to false, oldAction=" + oldAction + ", newAction=" + newAction + ", alarm=" + ipAlarmEntity.toString()));
                }
                this.addWaitNofitySetToThread(ipInfoKey, ipAlarmEntity);
                this.checkCreateSyslogOfIPAlarmOrAttack(ipFlowInfo.getCurrDropPps(), ipAlarmEntity, direction);
                this.checkCreateSyslogOfAttackDetail(ipAlarmEntity, direction);
                continue;
            }
            this.checkCreateSendSyslogAttacking(ipAlarmEntity, direction);
            this.checkCreateAttackAlarmSyslog(ipFlowInfo.getCurrDropPps(), ipAlarmEntity, direction);
        }
    }

    private void addWaitNofitySetToThread(IpInfoKey ipInfoKey, IpAlarmEntity ipAlarmEntity) {
        int action = ipAlarmEntity.getDiversionAction();
        IpAlarmEntity newIpAlarmEntity = this.generateAlarmObject(ipAlarmEntity);
        if (this.isBlackholeAlarm(action)) {
            this.blackholeAlarmThread.addWaitNotifyAlarm(ipInfoKey, newIpAlarmEntity);
        } else if (this.isDivertAlarm(action)) {
            this.divertAlarmThread.addWaitNotifyAlarm(ipInfoKey, newIpAlarmEntity);
            this.blackholeAlarmThread.removeWaitNotifyAlarm(ipInfoKey, newIpAlarmEntity);
        } else {
            this.waitNotifyIpSet.add(ipInfoKey);
            this.divertAlarmThread.removeWaitNotifyAlarm(ipInfoKey, newIpAlarmEntity);
            this.blackholeAlarmThread.removeWaitNotifyAlarm(ipInfoKey, newIpAlarmEntity);
        }
    }

    private IpAlarmEntity generateAlarmObject(IpAlarmEntity ipAlarmEntity) {
        IpAlarmEntity alarmEntity = new IpAlarmEntity();
        alarmEntity.setZoneIp(ipAlarmEntity.getZoneIp());
        alarmEntity.setDirection(ipAlarmEntity.getDirection());
        alarmEntity.setDeviceIp(ipAlarmEntity.getDeviceIp());
        alarmEntity.setDeviceType(ipAlarmEntity.getDeviceType());
        alarmEntity.setIsAlarm(ipAlarmEntity.isIsAlarm());
        alarmEntity.setBeginTime(ipAlarmEntity.getBeginTime());
        alarmEntity.setEndTime(ipAlarmEntity.getEndTime());
        alarmEntity.setZoneId(ipAlarmEntity.getZoneId());
        alarmEntity.setLocationId(ipAlarmEntity.getLocationId());
        alarmEntity.setSeverity(ipAlarmEntity.getSeverity());
        alarmEntity.setDiversionAction(ipAlarmEntity.getDiversionAction());
        alarmEntity.setDiverted(ipAlarmEntity.isDiverted());
        alarmEntity.setBlacked(ipAlarmEntity.isBlacked());
        alarmEntity.setCurrInPps(ipAlarmEntity.getCurrInPps());
        alarmEntity.setCurrInKbps(ipAlarmEntity.getCurrInKbps());
        alarmEntity.setCurrDropPps(ipAlarmEntity.getCurrDropPps());
        alarmEntity.setCurrDropKbps(ipAlarmEntity.getCurrDropKbps());
        alarmEntity.setMaxInPps(ipAlarmEntity.getMaxInPps());
        alarmEntity.setMaxInKbps(ipAlarmEntity.getMaxInKbps());
        alarmEntity.setMaxDropPps(ipAlarmEntity.getMaxDropPps());
        alarmEntity.setMaxDropKbps(ipAlarmEntity.getMaxDropKbps());
        alarmEntity.setCurrConn(ipAlarmEntity.getCurrConn());
        alarmEntity.setNewConn(ipAlarmEntity.getNewConn());
        alarmEntity.setPorts(null == ipAlarmEntity.getPorts() ? null : ipAlarmEntity.getPorts());
        ArrayList<AbnormalAlarmEntity> alarmEntities = new ArrayList<AbnormalAlarmEntity>();
        alarmEntities.addAll(ipAlarmEntity.getAbnolmalList());
        alarmEntity.getAbnolmalList().addAll(alarmEntities);
        return alarmEntity;
    }

    private boolean isDivertAlarm(int action) {
        return 1 == action || 2 == action || 5 == action || 98 == action || 9 == action;
    }

    private boolean isBlackholeAlarm(int action) {
        return 3 == action || 4 == action || 6 == action || 99 == action;
    }

    private List<SysLog> createSyslogFromIpAlarmEntity(IpAlarmEntity ipAlarmEntity, int minSeverity) {
        ArrayList<SysLog> syslogList = new ArrayList<SysLog>();
        if (ipAlarmEntity.getMaxSeverity() >= minSeverity) {
            SysLog syslogIp = new SysLog(ipAlarmEntity);
            syslogList.add(syslogIp);
        }
        return syslogList;
    }

    private List<SysLog> create70sIpAndDetailSyslog(IpAlarmEntity ipAlarmEntity, int minSeverity) {
        ArrayList<SysLog> syslogList = new ArrayList<SysLog>();
        if (ipAlarmEntity.getMaxSeverity() >= minSeverity) {
            SysLog syslogIp = new SysLog(ipAlarmEntity);
            syslogList.add(syslogIp);
            for (AbnormalAlarmEntity abnormalAlarm : ipAlarmEntity.getAbnolmalList()) {
                SysLog syslogDetail = new SysLog(abnormalAlarm);
                syslogList.add(syslogDetail);
            }
        }
        return syslogList;
    }

    private void checkCreateSendSyslogAttacking(IpAlarmEntity ipAlarmEntity, int direction) {
        Map<String, Object> keysAndValuesMap = this.syslogThread.getSyslogClienMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        if (null == keys || keys.size() == 0) {
            return;
        }
        HashMap syslogClienMap = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            syslogClienMap.put(keys.get(i), values.get(i));
        }
        if (!syslogClienMap.isEmpty()) {
            for (Map.Entry syslogClientEntry : syslogClienMap.entrySet()) {
                SyslogServerEntity server = ((SyslogClientAbstrat)syslogClientEntry.getValue()).getSyslogServerEntity();
                if (1 != server.getDefaultZoneSyslog() && FoundIDUtil.getInstance().isDefaultZone(ipAlarmEntity.getZoneId())) continue;
                ArrayList<SysLog> syslogList = new ArrayList<SysLog>();
                if (1 == server.getAlarmRefreshLog() && 1 == direction) {
                    syslogList.addAll(this.create70sIpAndDetailSyslog(ipAlarmEntity, server.getAlarmMinLevel()));
                }
                if (1 == server.getAlarmRefreshLogOutbound() && 2 == direction) {
                    syslogList.addAll(this.create70sIpAndDetailSyslog(ipAlarmEntity, server.getAlarmMinLevel()));
                }
                if (syslogList.isEmpty()) continue;
                this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), syslogList);
            }
        }
    }

    private void checkCreateSyslogOfAttackDetail(IpAlarmEntity ipAlarmEntity, int direction) {
        Map<String, Object> keysAndValuesMap = this.syslogThread.getSyslogClienMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        if (null == keys || keys.size() == 0) {
            return;
        }
        HashMap syslogClienMap = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            syslogClienMap.put(keys.get(i), values.get(i));
        }
        if (!syslogClienMap.isEmpty()) {
            for (Map.Entry syslogClientEntry : syslogClienMap.entrySet()) {
                SyslogServerEntity server = ((SyslogClientAbstrat)syslogClientEntry.getValue()).getSyslogServerEntity();
                if (1 != server.getDefaultZoneSyslog() && FoundIDUtil.getInstance().isDefaultZone(ipAlarmEntity.getZoneId())) continue;
                ArrayList<SysLog> syslogList = new ArrayList<SysLog>();
                if (ipAlarmEntity.getMaxSeverity() >= server.getAlarmMinLevel() && (1 == server.getAlarmDetailLog() && 1 == direction || 1 == server.getAlarmDetailLogOutbound() && 2 == direction)) {
                    for (AbnormalAlarmEntity abnormalAlarm : ipAlarmEntity.getAbnolmalList()) {
                        SysLog syslogDetail = new SysLog(abnormalAlarm);
                        syslogList.add(syslogDetail);
                    }
                }
                if (syslogList.isEmpty()) continue;
                this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), syslogList);
            }
        }
    }

    private void checkCreateAttackAlarmSyslog(long dropPacket, IpAlarmEntity ipAlarmEntity, int direction) {
        Map<String, Object> keysAndValuesMap = this.syslogThread.getSyslogClienMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        if (null == keys || keys.size() == 0) {
            return;
        }
        HashMap syslogClienMap = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            syslogClienMap.put(keys.get(i), values.get(i));
        }
        if (!syslogClienMap.isEmpty()) {
            for (Map.Entry syslogClientEntry : syslogClienMap.entrySet()) {
                SyslogServerEntity server = ((SyslogClientAbstrat)syslogClientEntry.getValue()).getSyslogServerEntity();
                if (1 != server.getDefaultZoneSyslog() && FoundIDUtil.getInstance().isDefaultZone(ipAlarmEntity.getZoneId())) continue;
                ArrayList<SysLog> syslogList = new ArrayList<SysLog>();
                if (dropPacket > 0L && (1 == server.getAlarmAttackLog() && 1 == direction || 1 == server.getAlarmAttackLogOutbound() && 2 == direction)) {
                    syslogList.add(this.createAttackAlarmSyslog(ipAlarmEntity));
                }
                if (syslogList.isEmpty()) continue;
                this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), syslogList);
            }
        }
    }

    public Map<IpInfoKey, IpAlarmEntity> getIpAlarmMap() {
        return this.ipAlarmMap;
    }

    public synchronized List<DynBlistAlarmEntity> getDynBlistAlarmEntityList() {
        return this.dynBlistAlarmEntityList;
    }

    public synchronized List<CleanPcapAlarmEntity> getCleanPcapAlarmList() {
        return this.cleanPcapAlarmList;
    }

    public synchronized List<DnsDefendAlarmEntity> getDnsDefendAlarmList() {
        return this.dnsDefendAlarmList;
    }

    public Map<String, Map<IpInfoKey, IpFlowInfo>> getIpFlow70secMap() {
        return this.ipFlow70secMap;
    }

    public Map<IpInfoKey, IpFlowInfo> getIpFlow70secMapOfDev(String devIp) {
        return this.ipFlow70secMap.get(devIp);
    }

    public Optional<IpFlowInfo> get70secIpFlow(IpInfoKey ipInfoKey) {
        Map<IpInfoKey, IpFlowInfo> flowMap = this.ipFlow70secMap.get(ipInfoKey.getDeviceIp());
        if (null == flowMap) {
            return Optional.ofNullable(null);
        }
        return Optional.ofNullable(flowMap.get(ipInfoKey));
    }

    public Long get70secIpInboundInFLow(String devIp, String zoneIp, int deviceType, long zoneId) {
        Map<IpInfoKey, IpFlowInfo> flowMap = this.ipFlow70secMap.get(devIp);
        if (null == flowMap) {
            return 0L;
        }
        IpInfoKey ipInfoKey = new IpInfoKey();
        ipInfoKey.setZoneIp(zoneIp);
        ipInfoKey.setDeviceIp(devIp);
        ipInfoKey.setDeviceType(deviceType);
        ipInfoKey.setZoneId(zoneId);
        ipInfoKey.setDirection(1);
        IpFlowInfo ipFlowInfo = flowMap.get(ipInfoKey);
        if (null == ipFlowInfo) {
            return 0L;
        }
        return ipFlowInfo.getMaxInKbps();
    }

    public void refreshAbnormalAlarmDoing(List<ExceptionEvent> exceptionEvents) {
        try {
            for (ExceptionEvent event : exceptionEvents) {
                IpInfoKey ipInfoKey = new IpInfoKey(event.getIdentifier());
                IpAlarmEntity ipAlarmEntity = this.ipAlarmMap.get(ipInfoKey);
                if (ipAlarmEntity == null) continue;
                AbnormalAlarmEntity alarm = this.createAbnormalAlarmEntity(event);
                alarm.setAlarm(true);
                ipAlarmEntity.refreshAbnolmal(alarm);
                IntelligentDefenseThread.getInstance().addIpAttackInfo(event, ipInfoKey);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("addAbormalAlarmStart error: " + exceptionEvents + " " + e.getMessage()));
        }
    }

    public synchronized void addDiskSpaceAlarm(DiskSpaceAlarmEntity diskEntity) {
        if (this.diskSpaceAlarmList != null) {
            this.diskSpaceAlarmList.clear();
        } else {
            this.diskSpaceAlarmList = new ArrayList<DiskSpaceAlarmEntity>();
        }
        diskEntity.setCollectorIp(this.collectorIp);
        this.diskSpaceAlarmList.add(diskEntity);
    }

    public static int getAlarmSizeLimit() {
        return alarmSizeLimit;
    }

    public static void setAlarmSizeLimit(int alarmSizeLimit) {
        AlarmThread.alarmSizeLimit = alarmSizeLimit;
    }

    public DivertAlarmThread getBlackholeAlarmThread() {
        return this.blackholeAlarmThread;
    }

    public void setBlackholeAlarmThread(DivertAlarmThread blackholeAlarmThread) {
        this.blackholeAlarmThread = blackholeAlarmThread;
    }

    public DivertAlarmThread getDivertAlarmThread() {
        return this.divertAlarmThread;
    }

    public void setDivertAlarmThread(DivertAlarmThread divertAlarmThread) {
        this.divertAlarmThread = divertAlarmThread;
    }
}

