/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.alarm;

import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.SyslogServerUtil;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.huawei.secsyslog.SyslogClientAbstrat;
import com.huawei.secsyslog.TCPSysLogClientThread;
import com.huawei.secsyslog.TcpSysLogClientUtil;
import com.huawei.secsyslog.UDPSysLogClientThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public final class SyslogThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static SyslogThread instance = new SyslogThread();
    private final Object syslogListlock = new Object();
    private final Object logServerListlock = new Object();
    private Map<String, SyslogServerEntity> logServerList = new HashMap<String, SyslogServerEntity>();
    private Map<String, SyslogServerEntity> logServerListTmp = new HashMap<String, SyslogServerEntity>();
    private ConcurrentMap<String, List<SysLog>> syslogList = new ConcurrentHashMap<String, List<SysLog>>();
    private ConcurrentMap<String, List<SysLog>> syslogListTmp = new ConcurrentHashMap<String, List<SysLog>>();
    private Map<String, SyslogClientAbstrat> syslogClienMap = new HashMap<String, SyslogClientAbstrat>();

    private SyslogThread() {
        this.setName("SyslogThread");
    }

    public static SyslogThread getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Iterator<Map.Entry<String, SyslogClientAbstrat>> iterator = this.syslogListlock;
                synchronized (iterator) {
                    if (!this.syslogListTmp.isEmpty()) {
                        this.syslogList = this.syslogListTmp;
                        this.syslogListTmp = new ConcurrentHashMap<String, List<SysLog>>();
                    }
                }
                iterator = this.logServerListlock;
                synchronized (iterator) {
                    this.checkAndModifySyslogClients();
                }
                if (!this.syslogClienMap.isEmpty() && !this.syslogList.isEmpty()) {
                    LOGGER.info((Object)("syslogList.size() :" + this.syslogList.size()));
                    for (Map.Entry<String, SyslogClientAbstrat> syslogClientEntry : this.syslogClienMap.entrySet()) {
                        String ipPort = syslogClientEntry.getKey();
                        if (null == this.syslogList.get(ipPort) || ((List)this.syslogList.get(ipPort)).isEmpty()) continue;
                        ArrayList<SysLog> dataList = new ArrayList<SysLog>();
                        for (SysLog sysLog : (List)this.syslogList.get(ipPort)) {
                            dataList.add(sysLog);
                        }
                        syslogClientEntry.getValue().addSysLogList(dataList);
                        this.syslogList.remove(ipPort);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("syslog thread error!" + e.getMessage()));
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("thread sleep failed:" + e.getMessage()));
                continue;
            }
            break;
        }
    }

    public void checkAndModifySyslogClients() {
        if (!this.isServerListEmpty(this.logServerListTmp)) {
            this.modifyByLogServerChange();
        }
        if (!this.logServerList.isEmpty() && this.syslogClienMap.isEmpty()) {
            this.logServerList = new HashMap<String, SyslogServerEntity>();
        }
    }

    private void modifyByLogServerChange() {
        List<String> newLogServerList = this.getDeleteStringList(this.logServerListTmp, this.logServerList);
        List<String> deleteLogServerList = this.getDeleteStringList(this.logServerList, this.logServerListTmp);
        for (String deleteServer : deleteLogServerList) {
            SyslogClientAbstrat clientAbstrat = this.syslogClienMap.get(deleteServer);
            if (null == clientAbstrat) continue;
            clientAbstrat.stopClient();
            this.syslogClienMap.remove(deleteServer);
        }
        this.creatSyslogClientList(newLogServerList);
        this.logServerList = this.logServerListTmp;
        this.logServerListTmp = new HashMap<String, SyslogServerEntity>();
    }

    private List<String> getDeleteStringList(Map<String, SyslogServerEntity> logServerListTmp2, Map<String, SyslogServerEntity> logServerList2) {
        ArrayList<String> deleteLogServerList = new ArrayList<String>();
        for (Map.Entry<String, SyslogServerEntity> logServer : logServerListTmp2.entrySet()) {
            boolean isToDelete = true;
            for (Map.Entry<String, SyslogServerEntity> logServerTmp : logServerList2.entrySet()) {
                SyslogServerEntity serverTmp;
                SyslogServerEntity server = logServer.getValue();
                if (!SyslogServerUtil.compareSyslogServer(server, serverTmp = logServerTmp.getValue())) continue;
                isToDelete = false;
                break;
            }
            if (!isToDelete) continue;
            deleteLogServerList.add(logServer.getKey());
        }
        return deleteLogServerList;
    }

    private boolean isServerListEmpty(Map<String, SyslogServerEntity> logServerList2) {
        return logServerList2.isEmpty();
    }

    private void creatSyslogClientList(List<String> logServerList2) {
        String logProtocol = "udp";
        SyslogClientAbstrat syslogClientAbstrat = null;
        if (null != logServerList2 && !logServerList2.isEmpty()) {
            Map<String, Object> keysAndValuesMap = SyslogServerUtil.getInstance().getSyslogServerMapKeysAndValues();
            List keys = (List)keysAndValuesMap.get("keys");
            List values = (List)keysAndValuesMap.get("values");
            HashMap serverMap = new HashMap();
            if (null != keys && keys.size() > 0) {
                for (int i = 0; i < keys.size(); ++i) {
                    serverMap.put(keys.get(i), values.get(i));
                }
            }
            for (String serverIpPort : logServerList2) {
                String[] ipPort = serverIpPort.split(",");
                if (null != serverMap.get(serverIpPort)) {
                    String string = logProtocol = 1 == ((SyslogServerEntity)serverMap.get(serverIpPort)).getTransferProtocol() ? "tcp" : "udp";
                }
                if ("tcp".equals(logProtocol)) {
                    SSLSocketFactory ssf = TcpSysLogClientUtil.getInstance().getSsf();
                    if (null == ssf) {
                        LOGGER.error((Object)("error to creat TCPSysLogClientThread for ssf is null, logServers=" + logServerList2.toString()));
                        return;
                    }
                    syslogClientAbstrat = new TCPSysLogClientThread(ipPort[0], Integer.parseInt(ipPort[1]));
                    syslogClientAbstrat.setSsf(ssf);
                    if (null != serverMap.get(serverIpPort)) {
                        syslogClientAbstrat.setSyslogServerEntity((SyslogServerEntity)serverMap.get(serverIpPort));
                    }
                    syslogClientAbstrat.start();
                    this.syslogClienMap.put(serverIpPort, syslogClientAbstrat);
                    continue;
                }
                syslogClientAbstrat = new UDPSysLogClientThread(ipPort[0], Integer.parseInt(ipPort[1]));
                if (null != serverMap.get(serverIpPort)) {
                    syslogClientAbstrat.setSyslogServerEntity((SyslogServerEntity)serverMap.get(serverIpPort));
                }
                syslogClientAbstrat.start();
                this.syslogClienMap.put(serverIpPort, syslogClientAbstrat);
            }
        }
    }

    public void setLogServers(Map<String, SyslogServerEntity> serverMap) {
        if (!serverMap.isEmpty()) {
            this.logServerListTmp.clear();
            this.logServerListTmp.putAll(serverMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyslog(String keyIpPort, List<SysLog> logList) {
        if (!logList.isEmpty()) {
            Object object = this.syslogListlock;
            synchronized (object) {
                if (null == this.syslogListTmp.get(keyIpPort)) {
                    ArrayList<SysLog> listTmp = new ArrayList<SysLog>();
                    listTmp.addAll(logList);
                    this.syslogListTmp.put(keyIpPort, listTmp);
                } else {
                    ((List)this.syslogListTmp.get(keyIpPort)).addAll(logList);
                }
            }
        }
    }

    public Map<String, Object> getSyslogClienMapKeysAndValues() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<SyslogClientAbstrat> values = new ArrayList<SyslogClientAbstrat>();
        for (Map.Entry<String, SyslogClientAbstrat> serverMap : this.syslogClienMap.entrySet()) {
            keys.add(serverMap.getKey());
            values.add(serverMap.getValue());
        }
        resultMap.put("keys", keys);
        resultMap.put("values", values);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyslogClienMap(Map<String, SyslogClientAbstrat> syslogClienMap) {
        Map<String, SyslogClientAbstrat> map = syslogClienMap;
        synchronized (map) {
            this.syslogClienMap = syslogClienMap;
        }
    }
}

