/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CleanAttackEventThread
implements Runnable {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private String tableName;
    private Long maxEndTime;

    @Override
    public void run() {
        try {
            this.cleanEvents(this.tableName, this.maxEndTime);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"cleanEvents error happend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanEvents(String tablesName, Long maxEndTimes) {
        PreparedStatement update;
        Connection con;
        block4: {
            String sql = "update " + tablesName + " set ATTACK_STATUS=0 where ATTACK_STATUS<>0 AND END_TIME < ?";
            LOGGER.info((Object)("cleanAttackEventThread END_TIME=" + maxEndTimes));
            con = null;
            update = null;
            try {
                con = DBConnPool.getConnection();
                if (null == con) break block4;
                update = con.prepareStatement(sql);
                update.setLong(1, maxEndTimes);
                update.execute();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"cleanEvents event SQLException error");
                }
                catch (Throwable throwable) {
                    CommonUtil.freeDbResource(con, update);
                    throw throwable;
                }
                CommonUtil.freeDbResource(con, update);
            }
        }
        CommonUtil.freeDbResource(con, update);
        LOGGER.info((Object)"clean attackEvents ok");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getMaxEndTime() {
        return this.maxEndTime;
    }

    public void setMaxEndTime(Long maxEndTime) {
        this.maxEndTime = maxEndTime;
    }
}

