/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CleanIpAttackExactLogThread
implements Runnable {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static CleanIpAttackExactLogThread cleanAttackEventThread = new CleanIpAttackExactLogThread();
    private static final String CLEAN_ATTACK_TABLE = "ATIC_IP_ATTACK_EXACT_LOG";
    private Long minStartTime;
    private Long maxEndTime;

    public static CleanIpAttackExactLogThread getInstance() {
        return cleanAttackEventThread;
    }

    @Override
    public void run() {
        try {
            this.cleanIpAttackExactLog(this.minStartTime, this.maxEndTime);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"cleanIpAttackExactLog error happend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanIpAttackExactLog(Long minStartTimes, Long maxEndTimes) {
        String updateSql = "UPDATE ATIC_IP_ATTACK_EXACT_LOG SET ATTACK_STATUS=0 WHERE START_TIME_ALERT >= ? AND END_TIME < ?";
        LOGGER.info((Object)("cleanIpAttackExactLog sql START_TIME_ALERT=" + minStartTimes + ", END_TIME=" + maxEndTimes));
        Connection con = null;
        PreparedStatement update = null;
        try {
            con = DBConnPool.getConnection();
            if (null != con && minStartTimes != Long.MAX_VALUE) {
                update = con.prepareStatement(updateSql);
                update.setLong(1, minStartTimes);
                update.setLong(2, maxEndTimes);
                update.executeUpdate();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"cleanIpAttackExactLog event error");
        }
        finally {
            CommonUtil.freeDbResource(con, update);
        }
        LOGGER.error((Object)"clean atic_ip_attack_exact_log ok");
    }

    public Long getMinStartTime() {
        return this.minStartTime;
    }

    public void setMinStartTime(Long minStartTime) {
        this.minStartTime = minStartTime;
    }

    public Long getMaxEndTime() {
        return this.maxEndTime;
    }

    public void setMaxEndTime(Long maxEndTime) {
        this.maxEndTime = maxEndTime;
    }
}

