/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.PacketParser;
import com.hs.atic.collector.biz.SortBuffer;
import com.hs.atic.collector.biz.event.nfa.NfaPacketParser;
import com.hs.atic.collector.biz.event.process.GeneratePacketsKey;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import java.util.Collection;
import java.util.List;

public class NfaEventConsumer
extends Consumer<TimeDatagramPacket> {
    private Buffer<Event> flowBuff;
    private SortBuffer<OriginalExceptionEvent> sortExceptionBuffer;
    private List<SortBuffer<OriginalExceptionEvent>> exceptionBufferSortList;
    private PacketParser<Event> packetParser;
    private long timeOutPeroid = 300000L;
    private GeneratePacketsKey generatePacketsKey;

    public NfaEventConsumer(NfaPacketParser nfaPacketParser) {
        this.packetParser = nfaPacketParser;
    }

    @Override
    protected void proceedPacket(List<TimeDatagramPacket> packets) {
        if (!packets.isEmpty()) {
            long currentNum = 0L;
            if (null != this.generatePacketsKey) {
                currentNum = this.generatePacketsKey.getKey();
            }
            this.sortExceptionBuffer = new SortBuffer();
            for (TimeDatagramPacket packet : packets) {
                if (!this.isTimeOut(packet)) {
                    Collection<Event> all = this.packetParser.parsePacket(packet);
                    if (all.isEmpty()) continue;
                    this.addEvents(all);
                    continue;
                }
                this.logger.warn((Object)"Drop one packets for timeout.");
            }
            this.sortExceptionBuffer.setTag(currentNum);
            this.addExcptionBuffer(this.sortExceptionBuffer);
        }
    }

    private void addEvents(Collection<Event> all) {
        for (Event event : all) {
            if (event instanceof OriginalExceptionEvent) {
                if (null != this.sortExceptionBuffer) {
                    this.sortExceptionBuffer.addPacket((OriginalExceptionEvent)event);
                }
                this.logger.info((Object)"event instanceof OriginalExceptionEvent");
                continue;
            }
            if (null == this.flowBuff) continue;
            this.flowBuff.addPacket(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExcptionBuffer(SortBuffer<OriginalExceptionEvent> sortExceptionBuffers) {
        List<SortBuffer<OriginalExceptionEvent>> list = this.exceptionBufferSortList;
        synchronized (list) {
            this.exceptionBufferSortList.add(sortExceptionBuffers);
            this.logger.info((Object)("exceptionBufferSortList.size(): " + this.exceptionBufferSortList.size()));
        }
    }

    public boolean isTimeOut(TimeDatagramPacket packet) {
        return System.currentTimeMillis() - packet.getTime() >= this.timeOutPeroid;
    }

    public GeneratePacketsKey getGeneratePacketsKey() {
        return this.generatePacketsKey;
    }

    public void setGeneratePacketsKey(GeneratePacketsKey generatePacketsKey) {
        this.generatePacketsKey = generatePacketsKey;
    }

    public void setFlowBuff(Buffer<Event> flowBuff) {
        this.flowBuff = flowBuff;
    }

    public void setSortExceptionBuffer(SortBuffer<OriginalExceptionEvent> sortExceptionBuffer) {
        this.sortExceptionBuffer = sortExceptionBuffer;
    }

    public void setExceptionBufferSortList(List<SortBuffer<OriginalExceptionEvent>> exceptionBufferSortList) {
        this.exceptionBufferSortList = exceptionBufferSortList;
    }
}

