/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.event.nfa.NfaAttackSrcFlow;
import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NfaParserAttackSrcEventV2
implements NfaEventDataParser {
    public static final int PPS_TYPE = 43;
    public static final int KBPS_TYPE = 44;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    @Override
    public void parseData(IpSuitEvent suitEvent, UnsignedDataInputStream stream, int logType, int logNum) throws IOException {
        if (2 == logType) {
            for (int i = 0; i < logNum; ++i) {
                this.parseAttackSrcData(suitEvent, stream);
            }
        }
    }

    private void parseAttackSrcData(IpSuitEvent suitEvent, UnsignedDataInputStream stream) throws IOException {
        OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
        event.setAttackSrcEvent(true);
        event.setCurrentState(1);
        int iAtckType = stream.readUnsignedByte();
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(iAtckType, 0, 0);
        event.setAttackType(attackType);
        int tlvNum = stream.readUnsignedByte();
        stream.readUnsignedShort();
        for (int i = 0; i < tlvNum; ++i) {
            List<NfaAttackSrcFlow> attackSrcFlowData;
            ArrayList<String> srcList;
            int ipType = stream.readUnsignedByte();
            stream.readUnsignedByte();
            int length = stream.readUnsignedShort();
            int ipNum = 0;
            if (41 == ipType) {
                srcList = new ArrayList<String>();
                ipNum = length / 4;
                for (int j = 0; j < ipNum; ++j) {
                    String srcIp = IpTransformer.long2StringFormat(stream.readUnsignedInt());
                    event.addAttacker(srcIp);
                    srcList.add(srcIp);
                }
                attackSrcFlowData = this.processAttackSrcFlowDataMap(srcList, stream, ipType, event.getDeviceIp());
                event.setAttackerFlowData(attackSrcFlowData);
                continue;
            }
            if (42 == ipType) {
                srcList = new ArrayList();
                ipNum = length / 16;
                for (int j = 0; j < ipNum; ++j) {
                    byte[] b = new byte[16];
                    if (stream.read(b) != 16) {
                        LOGGER.debug((Object)"stream read error");
                    }
                    String srcIp = IpTransformer.byte2String(b, 6);
                    event.addAttacker(srcIp);
                    srcList.add(srcIp);
                }
                attackSrcFlowData = this.processAttackSrcFlowDataMap(srcList, stream, ipType, event.getDeviceIp());
                event.setAttackerFlowData(attackSrcFlowData);
                continue;
            }
            LOGGER.error((Object)("error ipType=" + ipType + " from device " + event.getDeviceIp()));
        }
        suitEvent.addOriginalExceptionEvent(event);
    }

    private List<NfaAttackSrcFlow> processAttackSrcFlowDataMap(List<String> srcList, UnsignedDataInputStream stream, int ipType, String deviceIp) throws IOException {
        ArrayList<NfaAttackSrcFlow> attackerData = new ArrayList<NfaAttackSrcFlow>();
        List<Long> ppsList = this.readAttackSrcIpFlow(stream, 43, srcList.size(), deviceIp);
        List<Long> kbpsList = this.readAttackSrcIpFlow(stream, 44, srcList.size(), deviceIp);
        if (0 == ppsList.size() || 0 == kbpsList.size()) {
            LOGGER.error((Object)("error ppsList == null or kbpsList == nul" + ipType + " from device " + deviceIp));
            return attackerData;
        }
        if (ppsList.size() != kbpsList.size()) {
            LOGGER.error((Object)("error ppsList!=kbpsList" + ipType + " from device " + deviceIp));
            return attackerData;
        }
        NfaAttackSrcFlow nfaAttackSrcFlow = null;
        for (int i = 0; i < ppsList.size(); ++i) {
            nfaAttackSrcFlow = new NfaAttackSrcFlow();
            nfaAttackSrcFlow.setAttackSrcIp(srcList.get(i));
            nfaAttackSrcFlow.setPps(ppsList.get(i));
            nfaAttackSrcFlow.setKbps(kbpsList.get(i));
            attackerData.add(nfaAttackSrcFlow);
            LOGGER.debug((Object)("nfa attack srcIp:" + nfaAttackSrcFlow.getAttackSrcIp() + ", pps: " + nfaAttackSrcFlow.getPps() + ", kbps: " + nfaAttackSrcFlow.getKbps()));
        }
        return attackerData;
    }

    private List<Long> readAttackSrcIpFlow(UnsignedDataInputStream stream, int ipDataType, int scrIpNum, String deviceIp) throws IOException {
        ArrayList<Long> flowList = new ArrayList<Long>();
        int ipDataTypeFlow = stream.readUnsignedByte();
        stream.readUnsignedByte();
        int length = stream.readUnsignedShort();
        int ipFlowNum = 0;
        if (ipDataType == ipDataTypeFlow) {
            ipFlowNum = length / 8;
            for (int j = 0; j < ipFlowNum; ++j) {
                long flowValue = stream.readUnsignedLong();
                LOGGER.debug((Object)("ipDataTypeFlow:" + ipDataTypeFlow + ", flowValue: " + flowValue));
                flowValue = flowValue / 64L > 0L ? flowValue / 64L : 1L;
                flowList.add(flowValue);
            }
        } else {
            LOGGER.error((Object)("error ipTypeFlow=" + ipDataTypeFlow + " from device " + deviceIp));
        }
        if (scrIpNum != flowList.size()) {
            LOGGER.error((Object)("error ipFlow num," + flowList.size() + " from device " + deviceIp));
            flowList = new ArrayList();
        }
        return flowList;
    }
}

