/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.biz.event.nfa.NfaPayloadConstants;
import com.hs.atic.collector.biz.event.nfa.NfaUtil;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class NfaParserFlowEventV1
implements NfaEventDataParser {
    @Override
    public void parseData(IpSuitEvent suitEvent, UnsignedDataInputStream stream, int logType, int logNum) throws IOException {
        if (0 == logType) {
            for (int i = 0; i < logNum; ++i) {
                this.parseFlowData(suitEvent, stream);
            }
        }
    }

    private void parseFlowData(IpSuitEvent suitEvent, UnsignedDataInputStream stream) throws IOException {
        stream.readUnsignedShort();
        int tlvNum = stream.readUnsignedByte();
        stream.readUnsignedByte();
        Map<Integer, Object> payloadMap = NfaUtil.getInstance().parsePayloadMap(stream, tlvNum);
        InFlowEvent inFlowEvent = new InFlowEvent(suitEvent.getIdentifier());
        NfaUtil.getInstance().transPayload2Params(inFlowEvent, payloadMap, NfaPayloadConstants.getFlowParamsKeyMap());
        String zoneIp = suitEvent.getIdentifier().getZoneIp();
        if (null == zoneIp || zoneIp.isEmpty() || "0.0.0.0".equals(zoneIp)) {
            inFlowEvent.getIdentifier().setZoneType();
        }
        ArrayList<InFlowEvent> events = new ArrayList<InFlowEvent>();
        events.add(inFlowEvent);
        InFlowEvent maxInFlowEvent = new InFlowEvent(suitEvent.getIdentifier());
        maxInFlowEvent.merge(events);
        maxInFlowEvent.setMaxEvent(true);
        suitEvent.setInFlowEvent(inFlowEvent);
        suitEvent.setMaxInFlowEvent(maxInFlowEvent);
    }
}

