/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.nfa;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public final class NfaUtil {
    private static final NfaUtil INSTANCE = new NfaUtil();
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final Map<String, Field[]> FIELDS_MAP = new HashMap<String, Field[]>();

    private NfaUtil() {
    }

    public static NfaUtil getInstance() {
        return INSTANCE;
    }

    public Map<Integer, Object> parsePayloadMap(UnsignedDataInputStream stream, int payloadNum) throws IOException {
        HashMap<Integer, Object> payloadMap = new HashMap<Integer, Object>();
        block6: for (int i = 0; i < payloadNum; ++i) {
            int type = stream.readUnsignedByte();
            stream.readUnsignedByte();
            int length = stream.readUnsignedShort();
            Number value = null;
            switch (length) {
                case 1: {
                    value = stream.readUnsignedByte();
                    break;
                }
                case 2: {
                    value = stream.readUnsignedShort();
                    break;
                }
                case 4: {
                    value = stream.readUnsignedInt();
                    break;
                }
                case 8: {
                    value = stream.readUnsignedLong();
                    break;
                }
                default: {
                    if (stream.skip(length) != (long)length) {
                        LOGGER.error((Object)"skip stream error");
                    }
                    LOGGER.error((Object)("Error length=" + length + " of type=" + type));
                    continue block6;
                }
            }
            payloadMap.put(type, value);
        }
        return payloadMap;
    }

    public void transPayload2Params(Event event, Map<Integer, Object> payloadMap, Map<String, Integer> paramsMap) {
        int tlvType = 0;
        Object tlvVaule = "";
        String param = "";
        try {
            Field[] fields = NfaUtil.getAllFields(event);
            for (int i = 0; i < fields.length; ++i) {
                param = fields[i].getName();
                if (!paramsMap.containsKey(param) || (tlvVaule = payloadMap.get(tlvType = paramsMap.get(param).intValue())) == null) continue;
                this.setField(fields[i], event, tlvVaule);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    private void setField(Field field, Event event, Object value) {
        try {
            field.setAccessible(true);
            field.set(event, value);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("set field error, field=" + this.getcleanedMessage(field.getName()) + ". " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("set field error, field=" + this.getcleanedMessage(field.getName()) + ". " + e.getMessage()));
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private static Field[] getAllFields(Event event) {
        Class<?> clazz = event.getClass();
        String clazzName = clazz.getName();
        Field[] allFields = FIELDS_MAP.get(clazzName);
        if (null != allFields) {
            return allFields;
        }
        Object[] fieldSelf = clazz.getDeclaredFields();
        Object[] fieldSuper = clazz.getSuperclass().getDeclaredFields();
        allFields = (Field[])ArrayUtils.addAll((Object[])fieldSelf, (Object[])fieldSuper);
        FIELDS_MAP.put(clazzName, allFields);
        return allFields;
    }
}

