/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.Cpu70secEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.alarm.CycleAlarmEntity;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllCpuMinSumHandler<T extends Event>
extends EventHandler<T, T> {
    private int configCycleTime = 0;
    private long nfaCycleTime = 70L;
    private int maxInternalTime = 0;
    private int minInternalTime = 0;
    private int internalTimeLength = 5;
    private int tolerateTimeLength = 0;
    private Map<String, Map<Type, Cpu70secEvent<T>>> devEventMaps = new HashMap<String, Map<Type, Cpu70secEvent<T>>>();
    private Map<String, Integer> deviceCycleWarnMap = new HashMap<String, Integer>();
    private Map<String, Long> deviceLastCycTimeMap = new HashMap<String, Long>();
    private Map<String, Long> deviceIntevalTimeMap = new HashMap<String, Long>();
    private Map<String, List<FlowEventTime>> learnLogIntevalMap = new HashMap<String, List<FlowEventTime>>();

    public AllCpuMinSumHandler() {
        super.setLogger(LogManager.getInstance().getFlowLog());
        int intervalTime = Integer.parseInt(EventUtil.getEventConfigProperty("deviceLogReportCycle"));
        if (intervalTime < 0 || intervalTime > 64) {
            this.configCycleTime = 64;
            this.logger.error((Object)("AllCpuMinSumHandler conf configCycleTime = " + this.configCycleTime + ", internal = " + intervalTime));
        } else {
            this.configCycleTime = intervalTime;
        }
        this.tolerateTimeLength = this.configCycleTime >= 64 ? 6 : (this.configCycleTime >= 32 ? 5 : 4);
        this.maxInternalTime = this.configCycleTime + this.tolerateTimeLength;
        this.minInternalTime = this.configCycleTime - this.tolerateTimeLength;
        this.logger.debug((Object)("AllCpuMinSumHandler conf configCycleTime = " + this.configCycleTime + "AND maxInternalTime = " + this.maxInternalTime));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        if (!events.isEmpty()) {
            this.logger.info((Object)("AllCpuMinSumHandler handelEvents, events.size=" + events.size()));
            for (Event t : events) {
                this.logger.debug((Object)("revice a packet to AllCpuMinSumHandler:" + this.getcleanedMessage(t.toString())));
            }
        }
        ArrayList<T> result = new ArrayList<T>();
        if (!this.deviceLastCycTimeMap.isEmpty()) {
            for (Map.Entry<String, Long> entry : this.deviceLastCycTimeMap.entrySet()) {
                Long lastCycTime;
                String devIp = entry.getKey();
                if (!this.isTimeToSumOnCyc(devIp, lastCycTime = entry.getValue())) continue;
                this.refreshLastCycTime(devIp, entry);
                this.logger.debug((Object)("time to minSum of device=" + devIp + ", and last sum time=" + entry.getValue()));
                result.addAll(this.sumOneDevEvents(devIp));
            }
        }
        result.addAll(this.sumEvents(events));
        return result;
    }

    private void refreshLastCycTime(String devIp, Map.Entry<String, Long> lastCycTimeEntry) {
        Long lastCycTime = lastCycTimeEntry.getValue() + Long.valueOf(this.maxInternalTime) * 1000L;
        lastCycTimeEntry.setValue(lastCycTime);
    }

    private Collection<? extends T> sumEvents(List<T> events) {
        ArrayList<T> result = new ArrayList<T>();
        for (Event t : events) {
            Map<Type, Cpu70secEvent<T>> ipEventMap;
            IpType type = new IpType(t.getEventTypeString(), t.getIdentifier(), false);
            String deviceIp = t.getDeviceIp();
            this.initDevLastCycTime(t);
            if (this.learnLogIntervalTime(deviceIp, t)) {
                this.refreshDevLastCycTime(deviceIp);
                result.addAll(this.sumOneDevEvents(deviceIp));
            }
            if (null == (ipEventMap = this.devEventMaps.get(deviceIp))) {
                ipEventMap = new HashMap<Type, Cpu70secEvent<T>>();
                ipEventMap.put(type, new Cpu70secEvent<Event>(t));
                this.devEventMaps.put(deviceIp, ipEventMap);
                continue;
            }
            if (ipEventMap.containsKey(type)) {
                ipEventMap.get(type).addEvent(t);
                continue;
            }
            ipEventMap.put(type, new Cpu70secEvent<Event>(t));
        }
        return result;
    }

    private void refreshDevLastCycTime(String devIp) {
        Long lastCycTime = this.deviceLastCycTimeMap.get(devIp);
        Long intervalTime = this.deviceIntevalTimeMap.get(devIp);
        if (null == intervalTime) {
            intervalTime = this.maxInternalTime;
        }
        if (null != lastCycTime) {
            this.deviceLastCycTimeMap.put(devIp, lastCycTime + intervalTime * 1000L);
        } else {
            this.deviceLastCycTimeMap.put(devIp, System.currentTimeMillis());
        }
    }

    private boolean learnLogIntervalTime(String deviceIp, T t) {
        if (!((Event)t).isDeviceEvent() || ((Event)t).isIsDropFlow() || ((Event)t).isIsForwardFlow() || null != this.deviceIntevalTimeMap.get(deviceIp) && null == this.deviceCycleWarnMap.get(deviceIp)) {
            return false;
        }
        FlowEventTime eventTime = new FlowEventTime((Event)t);
        List<FlowEventTime> eventTimeList = this.learnLogIntevalMap.get(deviceIp);
        if (null == eventTimeList) {
            eventTimeList = new ArrayList<FlowEventTime>();
            eventTimeList.add(eventTime);
            this.learnLogIntevalMap.put(deviceIp, eventTimeList);
            this.logger.debug((Object)("add eventTime to eventTimeList, t.getDeviceTypeName()=" + ((Event)t).getDeviceTypeName() + ",eventTime=" + eventTime.toString() + ",eventTime.getFirstLogTime()=" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(eventTime.getFirstLogTime())));
        } else {
            for (FlowEventTime temp : eventTimeList) {
                long intervalTime;
                if (!eventTime.equals(temp) || (intervalTime = (eventTime.getFirstLogTime() - temp.getFirstLogTime()) / 1000L) <= (long)this.internalTimeLength) continue;
                this.learnLogIntevalMap.remove(deviceIp);
                this.logger.debug((Object)("new log eventTime= " + eventTime.toString() + ",eventTime.getFirstLogTime()=" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(eventTime.getFirstLogTime()) + ";old log temp=" + temp.toString() + ",temp.getFirstLogTime()=" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(temp.getFirstLogTime())));
                if (!"NFA".equals(((Event)t).getDeviceTypeName())) {
                    this.cycleWarnProcess(deviceIp, (int)intervalTime);
                }
                temp.setFirstLogTime(eventTime.getFirstLogTime());
                if (intervalTime > (long)this.minInternalTime && intervalTime < (long)this.maxInternalTime) {
                    this.deviceIntevalTimeMap.put(deviceIp, intervalTime);
                    this.logger.error((Object)("learn success: intervalTime of deviceIp " + deviceIp + " is " + intervalTime));
                } else {
                    this.deviceIntevalTimeMap.put(deviceIp, Long.valueOf(this.configCycleTime));
                    this.logger.error((Object)("learn failed: intervalTime of deviceIp " + deviceIp + " is " + this.configCycleTime + " intervalTime " + intervalTime));
                }
                return true;
            }
            if (eventTimeList.size() < 10) {
                this.logger.error((Object)("add eventTime to eventTimeList, t.getDeviceTypeName()=" + ((Event)t).getDeviceTypeName() + ",eventTime=" + eventTime.toString() + ",eventTime.getFirstLogTime()=" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(eventTime.getFirstLogTime())));
                eventTimeList.add(eventTime);
            }
        }
        return false;
    }

    private void initDevLastCycTime(T t) {
        String deviceIp = ((Event)t).getDeviceIp();
        String zoneIp = ((Event)t).getZoneIp();
        Long lastCycTime = this.deviceLastCycTimeMap.get(deviceIp);
        if ("NFA".equals(((Event)t).getDeviceTypeName()) && null == this.deviceIntevalTimeMap.get(deviceIp)) {
            this.deviceIntevalTimeMap.put(deviceIp, this.nfaCycleTime);
        }
        if (null == lastCycTime && ("NFA".equals(((Event)t).getDeviceTypeName()) || zoneIp != null && !zoneIp.isEmpty())) {
            this.deviceLastCycTimeMap.put(deviceIp, System.currentTimeMillis());
            this.logger.debug((Object)("initDevLastCycTime of deviceIp=" + deviceIp + ", time=" + System.currentTimeMillis()));
        }
    }

    private Collection<? extends T> sumOneDevEvents(String devIp) {
        ArrayList<T> result = new ArrayList<T>();
        Map<Type, Cpu70secEvent<T>> ipEventMaps = this.devEventMaps.get(devIp);
        if (null == ipEventMaps || ipEventMaps.isEmpty()) {
            return result;
        }
        this.logger.info((Object)("sumOneDevEvents of devIp=" + this.getcleanedMessage(devIp) + ", packtes size=" + ipEventMaps.size()));
        for (Map.Entry<Type, Cpu70secEvent<T>> entry : ipEventMaps.entrySet()) {
            result.addAll(entry.getValue().sumEvents());
        }
        this.devEventMaps.remove(devIp);
        MBeanResourceFactory.FLOW_MESSAGE_70SEC.clearCounter(devIp);
        for (Event resTemp : result) {
            this.logger.debug((Object)("min sum flow result of devIp=" + this.getcleanedMessage(devIp) + "; resTemp=" + this.getcleanedMessage(resTemp.toString())));
        }
        return result;
    }

    private void cycleWarnProcess(String devIp, int learnCycle) {
        Integer configCycle = this.configCycleTime;
        Integer cycleWarn = this.deviceCycleWarnMap.get(devIp);
        if (null == cycleWarn) {
            cycleWarn = 0;
        }
        if (learnCycle < this.minInternalTime || learnCycle > this.maxInternalTime) {
            Integer n = cycleWarn;
            Integer n2 = cycleWarn = Integer.valueOf(cycleWarn + 1);
            if (cycleWarn % 5 == 0) {
                this.sendCycleAlarm(learnCycle, configCycle, devIp, true);
            }
            this.deviceCycleWarnMap.put(devIp, cycleWarn);
        }
        if (cycleWarn > 0 && learnCycle > this.minInternalTime && learnCycle < this.maxInternalTime) {
            if (cycleWarn >= 5) {
                this.sendCycleAlarm(learnCycle, configCycle, devIp, false);
            }
            this.deviceCycleWarnMap.remove(devIp);
        }
    }

    private boolean isTimeToSumOnCyc(String devIp, Long lastCycTime) {
        long curTime = System.currentTimeMillis();
        Long intervalTime = this.deviceIntevalTimeMap.get(devIp);
        if (null == intervalTime) {
            return (curTime - lastCycTime) / 1000L >= (long)this.maxInternalTime;
        }
        return (curTime - lastCycTime) / 1000L >= intervalTime;
    }

    public Map<String, Long> getDeviceIntevalTimeMap() {
        return this.deviceIntevalTimeMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.devEventMaps == null ? 0 : this.devEventMaps.hashCode());
        result = 31 * result + (this.deviceIntevalTimeMap == null ? 0 : this.deviceIntevalTimeMap.hashCode());
        result = 31 * result + (this.deviceLastCycTimeMap == null ? 0 : this.deviceLastCycTimeMap.hashCode());
        result = 31 * result + (this.learnLogIntevalMap == null ? 0 : this.learnLogIntevalMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllCpuMinSumHandler other = (AllCpuMinSumHandler)obj;
        if (this.devEventMaps == null ? other.devEventMaps != null : !this.devEventMaps.equals(other.devEventMaps)) {
            return false;
        }
        if (this.deviceIntevalTimeMap == null ? other.deviceIntevalTimeMap != null : !this.deviceIntevalTimeMap.equals(other.deviceIntevalTimeMap)) {
            return false;
        }
        if (this.deviceLastCycTimeMap == null ? other.deviceLastCycTimeMap != null : !this.deviceLastCycTimeMap.equals(other.deviceLastCycTimeMap)) {
            return false;
        }
        return !(this.learnLogIntevalMap == null ? other.learnLogIntevalMap != null : !this.learnLogIntevalMap.equals(other.learnLogIntevalMap));
    }

    private void sendCycleAlarm(int learnCycle, int configCycle, String deviceIp, boolean cycleWarn) {
        CycleAlarmEntity cycleEntity = new CycleAlarmEntity();
        cycleEntity.setAlarm(cycleWarn);
        cycleEntity.setLearnCycle(String.valueOf(learnCycle));
        cycleEntity.setConfigCycle(String.valueOf(configCycle));
        cycleEntity.setSeverity(3);
        cycleEntity.setDeviceIp(deviceIp);
        AlarmThread.getInstance().addCycleAlarm(cycleEntity);
    }

    private class FlowEventTime
    extends Event {
        private String clazzName;
        private long firstLogTime;

        public FlowEventTime(Event event) {
            super(event.getIdentifier());
            this.clazzName = event.getEventTypeString();
            this.firstLogTime = event.getLogTime();
        }

        public long getFirstLogTime() {
            return this.firstLogTime;
        }

        public void setFirstLogTime(long firstLogTime) {
            this.firstLogTime = firstLogTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazzName == null ? 0 : this.clazzName.hashCode());
            result = 31 * result + this.getCpu();
            result = 31 * result + (this.getDeviceIp() == null ? 0 : this.getDeviceIp().hashCode());
            result = 31 * result + this.getDeviceType();
            result = 31 * result + this.getSlotId();
            result = 31 * result + this.getVpnIndex();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowEventTime other = (FlowEventTime)obj;
            if (this.clazzName == null ? other.clazzName != null : !this.clazzName.equals(other.clazzName)) {
                return false;
            }
            if (other.getIdentifier().getType() == this.getIdentifier().getType() && other.getDirection() == this.getDirection() && this.isDeviceEvent()) {
                return other.getDeviceIp().equals(this.getDeviceIp()) && other.getDeviceType() == this.getDeviceType();
            }
            return false;
        }

        @Override
        public String toString() {
            long nowTime = System.currentTimeMillis();
            return "FlowEventTime [clazzName=" + this.clazzName + ", deviceIp=" + this.getDeviceIp() + ", direction=" + this.getDirection() + ", deviceType=" + this.getDeviceType() + ", firstLogTime=" + this.firstLogTime + ", nowTime=" + nowTime + "]";
        }

        @Override
        public void average(int number) {
        }

        @Override
        public void merge(List<? extends Event> events) {
        }
    }
}

