/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.baseline.BaseLineTask;
import com.hs.atic.collector.entity.event.BaseLineEvent;
import com.hs.atic.collector.entity.event.BaseLineNfaEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseLineTaskWrapper {
    private static final Logger LOGGER = LogManager.getInstance().getBaseLineLog();
    private long pkid;
    private long zoneId;
    private long cyc;
    private String start;
    private boolean startup;
    private Map<Type, BaseLineEvent> mainRecords = new HashMap<Type, BaseLineEvent>();
    private Map<Type, BaseLineEvent> subRrecords = new HashMap<Type, BaseLineEvent>();
    private Map<Type, BaseLineNfaEvent> nfaMainRecords = new HashMap<Type, BaseLineNfaEvent>();
    private Map<Type, BaseLineNfaEvent> nfaSubRrecords = new HashMap<Type, BaseLineNfaEvent>();

    public BaseLineTaskWrapper(BaseLineTask task) {
        this.pkid = task.getPkid();
        this.zoneId = task.getZoneId();
        this.cyc = task.getCyc();
        this.start = task.getStart();
        this.startup = task.isStartup();
    }

    public BaseLineTaskWrapper(long pkid, long zoneId, long cyc, String start) {
        this.pkid = pkid;
        this.zoneId = zoneId;
        this.cyc = cyc;
        this.start = start;
    }

    public int getRecordSize() {
        return this.mainRecords.size() + this.subRrecords.size() + this.nfaMainRecords.size() + this.nfaSubRrecords.size();
    }

    public <T extends Event> void maxEvents(List<T> events) {
        for (Event t : events) {
            if (!this.isMatch(t)) continue;
            if (t instanceof BaseLineNfaEvent) {
                this.maxNfaEvent((BaseLineNfaEvent)t);
                continue;
            }
            this.maxDDoSEvent((BaseLineEvent)t);
        }
    }

    private void maxNfaEvent(BaseLineNfaEvent nfaEvnet) {
        BaseLineNfaEvent e;
        BizType type = new BizType(nfaEvnet.getIdentifier());
        IpInfoKey localInfoKey = new IpInfoKey(nfaEvnet.getIdentifier());
        boolean notStudy = false;
        Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = AlarmThread.getInstance().getIpAlarmMap();
        if (null != ipAlarmMap && !ipAlarmMap.isEmpty()) {
            for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : ipAlarmMap.entrySet()) {
                IpInfoKey alarmInfoKey = entry.getKey();
                if (!localInfoKey.getDeviceIp().equals(alarmInfoKey.getDeviceIp()) || localInfoKey.getDeviceType() != alarmInfoKey.getDeviceType() || localInfoKey.getZoneId() != alarmInfoKey.getZoneId()) continue;
                notStudy = true;
            }
        }
        LOGGER.debug((Object)("notStudy=" + notStudy + " of " + localInfoKey.toString()));
        if (!notStudy) {
            if (this.nfaMainRecords.containsKey(type)) {
                LOGGER.debug((Object)("notStudy=" + notStudy + "MAX main date "));
                this.nfaMainRecords.get(type).max(nfaEvnet);
            } else {
                LOGGER.debug((Object)("Add event to the nfaMainRecords, nfaMainRecords=" + this.nfaMainRecords.toString()));
                LOGGER.debug((Object)("Event=" + nfaEvnet.toString()));
                e = new BaseLineNfaEvent(nfaEvnet.getIdentifierCopy());
                e.max(nfaEvnet);
                e.setChanged(true);
                e.setPkid(this.pkid);
                this.nfaMainRecords.put(type, e);
            }
        }
        if (this.nfaSubRrecords.containsKey(type)) {
            if (!notStudy && this.nfaSubRrecords.get(type).isAlert()) {
                e = new BaseLineNfaEvent(nfaEvnet.getIdentifierCopy());
                e.max(nfaEvnet);
                e.setChanged(true);
                e.setPkid(this.pkid);
                e.setHourEvent(true);
                e.setAlert(false);
                this.nfaSubRrecords.put(type, e);
            } else {
                this.nfaSubRrecords.get(type).max(nfaEvnet);
            }
        } else {
            LOGGER.debug((Object)("Add event to the nfaSubRrecords, nfaSubRrecords=" + this.nfaSubRrecords.toString()));
            LOGGER.debug((Object)("Event=" + nfaEvnet.toString()));
            e = new BaseLineNfaEvent(nfaEvnet.getIdentifierCopy());
            e.max(nfaEvnet);
            e.setChanged(true);
            e.setPkid(this.pkid);
            e.setHourEvent(true);
            this.nfaSubRrecords.put(type, e);
        }
        this.nfaSubRrecords.get(type).setAlert(notStudy);
    }

    private void maxDDoSEvent(BaseLineEvent event) {
        BaseLineEvent e;
        BizType type = new BizType(event.getIdentifier());
        boolean notStudy = this.checkDDoSStudyState(event);
        if (!notStudy) {
            if (this.mainRecords.containsKey(type)) {
                this.mainRecords.get(type).max(event);
            } else {
                LOGGER.debug((Object)("Add event to the mainRecords, mainRecords=" + this.mainRecords.toString()));
                LOGGER.debug((Object)("Event=" + event.toString()));
                e = new BaseLineEvent(event.getIdentifierCopy());
                e.max(event);
                e.setChanged(true);
                e.setBaseLinePkid(this.pkid);
                this.mainRecords.put(type, e);
            }
        }
        if (this.subRrecords.containsKey(type)) {
            if (!notStudy && this.subRrecords.get(type).isAlert()) {
                e = new BaseLineEvent(event.getIdentifierCopy());
                e.max(event);
                e.setChanged(true);
                e.setBaseLinePkid(this.pkid);
                e.setHourEvent(true);
                e.setAlert(false);
                this.subRrecords.put(type, e);
            } else {
                this.subRrecords.get(type).max(event);
            }
        } else {
            LOGGER.debug((Object)("Add event to the subRrecords, subRrecords=" + this.subRrecords.toString()));
            LOGGER.debug((Object)("Event=" + event.toString()));
            e = new BaseLineEvent(event.getIdentifierCopy());
            e.max(event);
            e.setChanged(true);
            e.setBaseLinePkid(this.pkid);
            e.setHourEvent(true);
            this.subRrecords.put(type, e);
        }
        this.subRrecords.get(type).setAlert(notStudy);
    }

    private boolean checkDDoSStudyState(BaseLineEvent event) {
        boolean notStudy = false;
        IpInfoKey localInfoKey = new IpInfoKey(event.getIdentifier());
        IpAlarmEntity ipAlarmEntity = null;
        Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = AlarmThread.getInstance().getIpAlarmMap();
        if (null != ipAlarmMap && !ipAlarmMap.isEmpty()) {
            for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : ipAlarmMap.entrySet()) {
                IpInfoKey alarmInfoKey = entry.getKey();
                if (!localInfoKey.getDeviceIp().equals(alarmInfoKey.getDeviceIp()) || localInfoKey.getDeviceType() != alarmInfoKey.getDeviceType() || localInfoKey.getZoneId() != alarmInfoKey.getZoneId()) continue;
                ipAlarmEntity = entry.getValue();
                break;
            }
        }
        if (null != ipAlarmEntity) {
            notStudy = true;
            List<AbnormalAlarmEntity> abnolmalList = ipAlarmEntity.getAbnolmalList();
            if (null != abnolmalList && !abnolmalList.isEmpty()) {
                for (AbnormalAlarmEntity alarm : abnolmalList) {
                    if (!alarm.isAlarm() || alarm.getDropKbits() <= 0L && alarm.getDropPacket() <= 0L) continue;
                    notStudy = false;
                    break;
                }
            }
        }
        return notStudy;
    }

    public List<Event> getAllEvents() {
        BaseLineNfaEvent nfaEvent;
        BaseLineEvent event;
        ArrayList<Event> changes = new ArrayList<Event>();
        for (Map.Entry<Type, BaseLineEvent> entry : this.subRrecords.entrySet()) {
            event = entry.getValue();
            if (!event.isIsChanged()) continue;
            changes.add(event);
            event.setChanged(false);
        }
        for (Map.Entry<Type, BaseLineEvent> entry : this.mainRecords.entrySet()) {
            event = entry.getValue();
            if (!event.isIsChanged()) continue;
            changes.add(event);
            event.setChanged(false);
        }
        for (Map.Entry<Type, Event> entry : this.nfaSubRrecords.entrySet()) {
            nfaEvent = (BaseLineNfaEvent)entry.getValue();
            if (!nfaEvent.isIsChanged()) continue;
            changes.add(nfaEvent);
            nfaEvent.setChanged(false);
        }
        for (Map.Entry<Type, Event> entry : this.nfaMainRecords.entrySet()) {
            nfaEvent = (BaseLineNfaEvent)entry.getValue();
            if (!nfaEvent.isIsChanged()) continue;
            changes.add(nfaEvent);
            nfaEvent.setChanged(false);
        }
        return changes;
    }

    public void clearSubRrecords() {
        this.subRrecords.clear();
        this.nfaSubRrecords.clear();
    }

    protected boolean isMatch(Event t) {
        return t.getZoneId() == this.zoneId;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public long getCyc() {
        return this.cyc;
    }

    public void setCyc(long cyc) {
        this.cyc = cyc;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public void setStartup(boolean startup) {
        this.startup = startup;
    }

    public long getPkid() {
        return this.pkid;
    }

    public void setPkid(long pkid) {
        this.pkid = pkid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.pkid ^ this.pkid >>> 32);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseLineTaskWrapper other = (BaseLineTaskWrapper)obj;
        if (this.pkid != other.pkid) {
            return false;
        }
        return this.zoneId == other.zoneId;
    }

    public String toString() {
        return "BaseLineTaskWrapper [cyc=" + this.cyc + ", pkid=" + this.pkid + ", start=" + this.start + ", startup=" + this.startup + ", zoneId=" + this.zoneId + "]";
    }
}

