/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BaseLineTaskWrapper;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.baseline.BaseLineDBUtil;
import com.hs.atic.collector.db.condition.AllCondition;
import com.hs.atic.collector.db.condition.BaseLineConditionField;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.entity.baseline.BaseLineTask;
import com.hs.atic.collector.entity.event.BaseLineEvent;
import com.hs.atic.collector.entity.event.BaseLineNfaEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.BaseLineTaskRmiService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BaselineFlowSumHandler<T extends Event>
extends EventHandler<T, T> {
    private static final Logger LOGGER = LogManager.getInstance().getBaseLineLog();
    private static final int PERIOD = 64000;
    private static final int DEFALUT_SAVE_DETAIL_TIME = 300000;
    private static boolean isNeedUdpatePkid = true;
    private static BaselineFlowSumHandler instance;
    private static final String SERVICE_NAME = "BaseLineTaskRmiService";
    private long previousTime;
    private long previous5minTime;
    private Set<BaseLineTaskWrapper> wrappers = new HashSet<BaseLineTaskWrapper>();
    private List<BaseLineTaskWrapper> waitWrappers = new ArrayList<BaseLineTaskWrapper>();
    private Repository<BaseLineEvent> resultRepository;
    private Repository<BaseLineNfaEvent> nfaResultRepository;
    private Repository<BaseLineTaskWrapper> taskRepository;
    private BaseLineTaskRmiService baselineTaskRmiService;
    private int loopCount = 5;
    private long failureSleepTime = 10000L;
    private Map<Long, Long> baselineMap = new HashMap<Long, Long>();

    private BaselineFlowSumHandler() {
        try {
            this.refreshLastTime();
            this.refreshLast5minTime();
            this.resultRepository = RepositoryFactory.getInstance().getRepository(BaseLineEvent.class.getName());
            this.nfaResultRepository = RepositoryFactory.getInstance().getRepository(BaseLineNfaEvent.class.getName());
            this.taskRepository = RepositoryFactory.getInstance().getRepository(BaseLineTaskWrapper.class.getName());
            List<BaseLineTaskWrapper> taskList = this.taskRepository.queryObject(new AllCondition());
            this.wrappers.addAll(taskList);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"BaselineFlowSumHandler init error");
        }
        catch (Exception e) {
            this.logger.error((Object)"BaselineFlowSumHandler init error");
        }
    }

    public static synchronized BaselineFlowSumHandler getInstance() {
        if (null == instance) {
            instance = new BaselineFlowSumHandler();
        }
        return instance;
    }

    private void updateBaselineTaskPkid(Set<BaseLineTaskWrapper> taskSet) {
        try {
            if (null != taskSet && !taskSet.isEmpty() && isNeedUdpatePkid) {
                ArrayList<BaseLineTaskWrapper> taskList = new ArrayList<BaseLineTaskWrapper>();
                taskList.addAll(taskSet);
                Long pkId = ((BaseLineTaskWrapper)taskList.get(0)).getPkid();
                if (null == pkId || pkId == 0L) {
                    if (null != this.getBaseLineTaskRmiService()) {
                        try {
                            this.baselineMap = this.baselineTaskRmiService.getBaseLineTask();
                            if (null != this.baselineMap && !this.baselineMap.isEmpty()) {
                                for (BaseLineTaskWrapper taskWrapper : taskSet) {
                                    Long studyId = this.baselineMap.get(taskWrapper.getZoneId());
                                    if (null == studyId || studyId == 0L) continue;
                                    taskWrapper.setPkid(studyId);
                                }
                                BaseLineDBUtil.updateBaselineStudyId(taskList);
                            }
                            BaselineFlowSumHandler.setNeedUdpatePkid(false);
                        }
                        catch (RemoteException e) {
                            LOGGER.error((Object)"getBaseLineTaskRmiService error");
                            BaselineFlowSumHandler.setNeedUdpatePkid(true);
                        }
                    }
                } else {
                    BaselineFlowSumHandler.setNeedUdpatePkid(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("updateBaselineTaskPkid error!" + e.getMessage()));
        }
    }

    private BaseLineTaskRmiService getBaseLineTaskRmiService() {
        if (null == this.baselineTaskRmiService) {
            for (int i = 0; i < this.loopCount; ++i) {
                try {
                    this.baselineTaskRmiService = (BaseLineTaskRmiService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
                    LOGGER.info((Object)"getBaseLineTaskRmiService success");
                    break;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("get getBaseLineTaskRmiService failed! " + e.getMessage()));
                    try {
                        LOGGER.info((Object)("getBaseLineTaskRmiService failureSleepTime=" + this.failureSleepTime));
                        Thread.sleep(this.failureSleepTime);
                    }
                    catch (InterruptedException e2) {
                        LOGGER.error((Object)("get getBaseLineTaskRmiService failed!" + e2.getMessage()));
                    }
                    continue;
                }
            }
        }
        return this.baselineTaskRmiService;
    }

    protected void refreshLogTime(List<T> events) {
        for (Event e : events) {
            e.setLogTime(this.getPrevious5minTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyBaseLineTask(BaseLineTask task) {
        BaseLineTaskWrapper wrapper = new BaseLineTaskWrapper(task);
        List<BaseLineTaskWrapper> list = this.waitWrappers;
        synchronized (list) {
            this.waitWrappers.add(wrapper);
        }
        return true;
    }

    protected Condition getCondition(BaseLineTaskWrapper wrapper) {
        ConditionClause idCondition = new ConditionClause();
        idCondition.setField(new BaseLineConditionField("pkid"));
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        idCondition.setSeparator(separator);
        idCondition.setValue(wrapper.getPkid());
        idCondition.addValueList(idCondition.getValue());
        return idCondition;
    }

    protected void addWrapper(BaseLineTaskWrapper wrapper) {
        Condition condition = this.getCondition(wrapper);
        if (this.wrappers.contains(wrapper)) {
            this.wrappers.remove(wrapper);
            this.taskRepository.deleteObject(condition);
        }
        this.taskRepository.createObject(wrapper);
        this.wrappers.add(wrapper);
        this.resultRepository.deleteObject(condition);
        this.nfaResultRepository.deleteObject(condition);
        LOGGER.debug((Object)("add task: " + wrapper.toString()));
    }

    protected void removeWrapper(BaseLineTaskWrapper wrapper) {
        Condition condition = this.getCondition(wrapper);
        this.wrappers.remove(wrapper);
        this.taskRepository.deleteObject(condition);
        LOGGER.debug((Object)("delete task: " + this.getcleanedMessage(wrapper.toString())));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshWrappers() {
        List<BaseLineTaskWrapper> list = this.waitWrappers;
        synchronized (list) {
            for (BaseLineTaskWrapper wrapper : this.waitWrappers) {
                if (wrapper.isStartup()) {
                    this.addWrapper(wrapper);
                    continue;
                }
                this.removeWrapper(wrapper);
            }
            this.waitWrappers.clear();
        }
    }

    @Override
    protected synchronized List<T> handelEvents(List<T> events) {
        this.updateBaselineTaskPkid(this.wrappers);
        this.refreshWrappers();
        ArrayList<Event> changes = new ArrayList<Event>();
        if (System.currentTimeMillis() - this.previousTime >= 64000L) {
            for (BaseLineTaskWrapper wrapper : this.wrappers) {
                changes.addAll(wrapper.getAllEvents());
            }
            this.refreshLogTime(changes);
            this.refreshLastTime();
            if (LOGGER.isDebugEnabled() && !changes.isEmpty()) {
                LOGGER.debug((Object)("baselineFlowHanlder:" + changes));
            }
        }
        if (System.currentTimeMillis() - this.getPrevious5minTime() >= 300000L) {
            for (BaseLineTaskWrapper wrapper : this.wrappers) {
                wrapper.clearSubRrecords();
            }
            this.refreshLast5minTime();
        }
        List<T> filterEvents = this.filter(events);
        for (BaseLineTaskWrapper wrapper : this.wrappers) {
            wrapper.maxEvents(filterEvents);
        }
        return changes;
    }

    protected List<T> filter(List<T> events) {
        Map<Type, List<T>> map = EventUtil.groupEventsByBiz(events);
        ArrayList<Event> result = new ArrayList<Event>();
        for (Map.Entry<Type, List<T>> entry : map.entrySet()) {
            List<T> list = entry.getValue();
            if (list.isEmpty()) continue;
            Event first = (Event)list.get(0);
            EventIdentifier header = first.getIdentifierCopy();
            if ("NFA".equals(first.getDeviceTypeName())) {
                BaseLineNfaEvent nfaEvent = new BaseLineNfaEvent(header);
                nfaEvent.maxWithOtherEvent(list);
                result.add(nfaEvent);
                continue;
            }
            BaseLineEvent event = new BaseLineEvent(header);
            event.maxWithOtherEvent(list);
            result.add(event);
        }
        return result;
    }

    public synchronized int getBaseLineTaskNum() {
        return this.wrappers.size();
    }

    public synchronized int getBaseLineRecodeNum() {
        int num = 0;
        for (BaseLineTaskWrapper wrapper : this.wrappers) {
            num += wrapper.getRecordSize();
        }
        return num;
    }

    protected void refreshLastTime() {
        this.previousTime += 64000L;
    }

    protected void refreshLast5minTime() {
        this.previous5minTime = EventUtil.getIntegralTime(300000);
    }

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event t : events) {
            if (t.isIpLocationEvent() || !t.getIdentifier().isZoneIp() || !t.isIsMaxEvent() || !t.isIsForwardFlow() && (t.isFromCleanDevice() || t.isIsDropFlow())) continue;
            list.add(t);
        }
        return list;
    }

    public static boolean isNeedUdpatePkid() {
        return isNeedUdpatePkid;
    }

    public static void setNeedUdpatePkid(boolean isNeedUdpatePkids) {
        isNeedUdpatePkid = isNeedUdpatePkids;
    }

    public long getPrevious5minTime() {
        return this.previous5minTime;
    }

    public void setPrevious5minTime(long previous5minTime) {
        this.previous5minTime = previous5minTime;
    }
}

