/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.BizEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BizEventParserV3
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getBizEventLog();
    private static final int BIZ = 6;
    private static final int TCP_PROTOCOL = 6;
    private static final int UDP_PROTOCOL = 17;
    private static final int GGP = 3;
    private static final int IPINIP = 4;
    private static final int GRE = 47;
    private static final int ESP = 50;
    private static final int AH = 51;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 6) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stram error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit) throws IOException {
        BizEvent bizEvent = new BizEvent(suit.getIdentifier());
        this.readBizEvent(stream, bizEvent);
        suit.addBizEvent(bizEvent);
    }

    private String getProtocolNameById(int protocolId, int port) {
        switch (protocolId) {
            case 6: {
                switch (port) {
                    case 53: {
                        return "TCP_DNS";
                    }
                    case 80: {
                        return "HTTP";
                    }
                    case 443: {
                        return "HTTPS";
                    }
                }
                return "TCP";
            }
            case 17: {
                switch (port) {
                    case 53: {
                        return "UDP_DNS";
                    }
                    case 5060: {
                        return "SIP";
                    }
                }
                return "UDP";
            }
            case 3: {
                return "GGP";
            }
            case 4: {
                return "IP_IN_IP";
            }
            case 47: {
                return "GRE";
            }
            case 50: {
                return "ESP";
            }
            case 51: {
                return "AH";
            }
        }
        return "Other";
    }

    private void readBizEvent(UnsignedDataInputStream stream, BizEvent bizEvent) throws IOException {
        int ipProtocol = stream.readUnsignedByte();
        bizEvent.setIpProtocol(ipProtocol);
        stream.readUnsignedByte();
        int bizDstPort = stream.readUnsignedShort();
        long pps = stream.readUnsignedInt();
        bizEvent.setSrvPps(pps);
        long kbps = stream.readUnsignedInt();
        bizEvent.setSrvKbps(kbps);
        int nameCount = stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedShort();
        String protocolName = this.getProtocolNameById(ipProtocol, bizDstPort);
        if (nameCount == 0) {
            bizEvent.setServiceName(protocolName + "_" + bizDstPort);
            return;
        }
        int srvId = stream.readUnsignedShort();
        bizEvent.setSrvId(srvId);
        int srvLen = stream.readUnsignedShort();
        StringBuffer serviceName = new StringBuffer();
        if (srvLen != 0) {
            byte[] srvByte = new byte[srvLen];
            if (stream.read(srvByte) != srvLen) {
                LOGGER.error((Object)"stream read error");
            }
            String ucSrvName = new String(srvByte, "utf-8");
            bizEvent.setSrvName(ucSrvName);
            serviceName.append(ucSrvName);
        }
        int protoId = stream.readUnsignedShort();
        bizEvent.setProtoId(protoId);
        int protoLen = stream.readUnsignedShort();
        if (protoLen != 0) {
            byte[] protoByte = new byte[protoLen];
            if (stream.read(protoByte) != protoLen) {
                LOGGER.error((Object)"stream read error");
            }
            String ucProtoName = new String(protoByte, "utf-8");
            bizEvent.setProtoName(ucProtoName);
            serviceName.append("_" + ucProtoName);
        }
        int appId = stream.readUnsignedShort();
        bizEvent.setAppId(appId);
        int appLen = stream.readUnsignedShort();
        if (appLen != 0) {
            byte[] appByte = new byte[appLen];
            if (stream.read(appByte) != appLen) {
                LOGGER.error((Object)"stream read error");
            }
            String ucAppName = new String(appByte, "utf-8");
            bizEvent.setAppnName(ucAppName);
            serviceName.append("_" + ucAppName);
        }
        if (protoId == 0 && appId == 0 && srvId == 0) {
            if (ipProtocol == 6 || ipProtocol == 17) {
                bizEvent.setServiceName(protocolName + "_" + bizDstPort);
            } else {
                bizDstPort = 0;
                if (ipProtocol == 3 || ipProtocol == 4 || ipProtocol == 47 || ipProtocol == 50 || ipProtocol == 51) {
                    bizEvent.setServiceName(protocolName);
                } else {
                    bizEvent.setServiceName(protocolName + "_" + ipProtocol);
                }
            }
        } else {
            bizEvent.setServiceName(serviceName.toString());
        }
        bizEvent.setBizDstPort(bizDstPort);
    }
}

