/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.FilterType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BizType
extends FilterType {
    private int deviceType;
    private int direction = 1;
    private long zoneId;
    private long bizId;
    private String deviceIpBiz;
    private boolean isDrop;
    private boolean isForward;
    private boolean isMaxEvent;

    public BizType(Event event) {
        super(event.getType());
        this.deviceIpBiz = event.getDeviceIp();
        this.deviceType = event.getDeviceType();
        this.zoneId = event.getZoneId();
        this.bizId = event.getBizId();
        this.direction = event.getDirection();
    }

    public BizType(Type type, Event event) {
        super(type);
        this.deviceIpBiz = event.getDeviceIp();
        this.deviceType = event.getDeviceType();
        this.zoneId = event.getZoneId();
        this.bizId = event.getBizId();
        this.direction = event.getDirection();
    }

    public BizType(EventIdentifier identifer, boolean isDrop, boolean isMaxEvent, boolean isForward) {
        this(identifer);
        this.isDrop = isDrop;
        this.isForward = isForward;
        this.isMaxEvent = isMaxEvent;
    }

    public BizType(Event event, boolean ignoreMaxEvent) {
        this(event);
        if (!ignoreMaxEvent) {
            this.isMaxEvent = event.isIsMaxEvent();
        }
    }

    public BizType(EventIdentifier identifer) {
        super(null);
        this.deviceIpBiz = identifer.getDeviceIp();
        this.deviceType = identifer.getDeviceType();
        this.zoneId = identifer.getZoneId();
        this.bizId = identifer.getBizId();
        this.direction = identifer.getDirection();
    }

    public boolean equals(Object o) {
        if (o instanceof BizType) {
            BizType bizType = (BizType)o;
            if (this.type != null) {
                return this.type.equals(bizType.getType()) && this.deviceIpBiz.equals(bizType.getDeviceIpBiz()) && this.zoneId == bizType.getZoneId() && this.bizId == bizType.getBizId() && this.deviceType == bizType.getDeviceType() && this.isDrop == bizType.isIsDrop() && this.isForward == bizType.isIsForward() && this.isIsMaxEvent() == bizType.isMaxEvent && this.direction == bizType.getDirection();
            }
            return this.zoneId == bizType.getZoneId() && this.deviceIpBiz.equals(bizType.getDeviceIpBiz()) && this.bizId == bizType.getBizId() && this.deviceType == bizType.getDeviceType() && this.isDrop == bizType.isIsDrop() && this.isForward == bizType.isIsForward() && this.isIsMaxEvent() == bizType.isMaxEvent && this.direction == bizType.getDirection();
        }
        return false;
    }

    public long getBizId() {
        return this.bizId;
    }

    public String getDeviceIpBiz() {
        return this.deviceIpBiz;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public int hashCode() {
        int result = 17;
        if (null != this.type) {
            result += 19 * this.type.hashCode();
        }
        result += 19 * (int)(this.zoneId ^ this.zoneId >>> 32);
        result += 17 * (int)(this.bizId ^ this.bizId >>> 32);
        result += 19 * this.deviceType;
        result += this.isDrop ? 0 : 1;
        result += this.isForward ? 0 : 1;
        result += this.isMaxEvent ? 0 : 1;
        return result += 19 * this.direction;
    }

    public boolean isIsDrop() {
        return this.isDrop;
    }

    public boolean isIsForward() {
        return this.isForward;
    }

    public void setBizId(long bizId) {
        this.bizId = bizId;
    }

    public void setDeviceIpBiz(String deviceIp) {
        this.deviceIpBiz = deviceIp;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public void setDrop(boolean isDrops) {
        this.isDrop = isDrops;
    }

    public void setForwrad(boolean isForwards) {
        this.isForward = isForwards;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public boolean isIsMaxEvent() {
        return this.isMaxEvent;
    }

    public void setMaxEvent(boolean isMaxEvents) {
        this.isMaxEvent = isMaxEvents;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("deviceIp", (Object)this.deviceIpBiz).append("direction", this.direction).append("zoneId", this.zoneId).append("type", (Object)this.type).append("deviceType", (Object)DeviceObj.getDeviceTypeDescriptor(this.deviceType)).toString();
    }
}

