/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.entity.event.Event;
import java.util.ArrayList;
import java.util.List;

public class CpuCycleEvent<T extends Event> {
    private T in;
    private T discard;
    private T maxIn;
    private T maxDiscard;
    private int count;

    public CpuCycleEvent(T t) {
        if (((Event)t).isIsDropFlow() && !((Event)t).isIsMaxEvent()) {
            this.initOutEvent(t);
        } else if (((Event)t).isIsDropFlow() && ((Event)t).isIsMaxEvent()) {
            this.initMaxOutEvent(t);
        } else if (!((Event)t).isIsDropFlow() && ((Event)t).isIsMaxEvent()) {
            this.initMaxInEvent(t);
        } else {
            this.initInEvent(t);
            ++this.count;
        }
    }

    private void initInEvent(T t) {
        this.in = ((Event)t).getCopyEvent();
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(t);
        ((Event)this.in).merge(temp);
    }

    private void initOutEvent(T t) {
        this.discard = ((Event)t).getCopyEvent();
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(t);
        ((Event)this.discard).merge(temp);
    }

    private void initMaxInEvent(T t) {
        this.maxIn = ((Event)t).getCopyEvent();
        ((Event)this.maxIn).setMaxEvent(true);
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(t);
        ((Event)this.maxIn).merge(temp);
    }

    private void initMaxOutEvent(T t) {
        this.maxDiscard = ((Event)t).getCopyEvent();
        ((Event)this.maxDiscard).setMaxEvent(true);
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(t);
        ((Event)this.maxDiscard).merge(temp);
    }

    private void addDropEvent(T event) {
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(event);
        if (this.discard == null) {
            this.initOutEvent(event);
        } else {
            ((Event)this.discard).merge(temp);
            ((Event)this.discard).setIdentifer(((Event)event).getIdentifierCopy());
        }
    }

    private void addMaxDropEvent(T event) {
        if (this.maxDiscard == null) {
            this.initMaxOutEvent(event);
        } else {
            ((Event)this.maxDiscard).max((Event)event);
            ((Event)this.maxDiscard).setIdentifer(((Event)event).getIdentifierCopy());
        }
    }

    private void addInEvent(T event) {
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(event);
        if (this.in == null) {
            this.initInEvent(event);
        } else {
            ((Event)this.in).merge(temp);
            ((Event)this.in).setIdentifer(((Event)event).getIdentifierCopy());
        }
    }

    private void addMaxInEvent(T event) {
        if (this.maxIn == null) {
            this.initMaxInEvent(event);
        } else {
            ((Event)this.maxIn).max((Event)event);
            ((Event)this.maxIn).setIdentifer(((Event)event).getIdentifierCopy());
        }
    }

    public void addEvent(T event) {
        ArrayList<T> temp = new ArrayList<T>(1);
        temp.add(event);
        if (((Event)event).isIsDropFlow() && !((Event)event).isIsMaxEvent()) {
            this.addDropEvent(event);
        } else if (((Event)event).isIsDropFlow() && ((Event)event).isIsMaxEvent()) {
            this.addMaxDropEvent(event);
        } else if (!((Event)event).isIsDropFlow() && ((Event)event).isIsMaxEvent()) {
            this.addMaxInEvent(event);
        } else {
            this.addInEvent(event);
            ++this.count;
        }
    }

    public List<T> average() {
        ArrayList<T> result = new ArrayList<T>();
        if (null != this.in) {
            ((Event)this.in).average(this.count);
        }
        if (null != this.discard) {
            ((Event)this.discard).average(this.count);
        }
        if (null != this.in && ((Event)this.in).isValid()) {
            result.add(this.in);
        }
        if (null != this.discard && ((Event)this.discard).isValid()) {
            result.add(this.discard);
        }
        if (null != this.maxIn && ((Event)this.maxIn).isValid()) {
            result.add(this.maxIn);
        }
        if (null != this.maxDiscard && ((Event)this.maxDiscard).isValid()) {
            result.add(this.maxDiscard);
        }
        return result;
    }
}

