/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.report.homepage.DashboradTask;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.FirstPageEvent;
import com.hs.atic.collector.entity.homepage.DashboardQueryBean;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class DashboardEventHandler<T extends Event>
extends EventHandler<T, T> {
    public static final DashboardEventHandler<Event> HANDLER = new DashboardEventHandler();
    public static final long CHECK_TIME = 60000L;
    private static final Logger LOGGER = LogManager.getInstance().getReportLogger();
    private static final long OVER_MINITUS = 180000L;
    private Map<DashboradTask, Long> map = new HashMap<DashboradTask, Long>();
    private Set<DashboradTask> processors = new HashSet<DashboradTask>();

    private DashboardEventHandler() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    DashboardEventHandler.this.check();
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOGGER.error((Object)("InterruptedException error!" + e.getMessage()));
                        continue;
                    }
                    break;
                }
            }
        });
        t.setName("dashborad cheack thread");
        t.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
        t.start();
    }

    public static DashboardEventHandler<Event> getInstance() {
        return HANDLER;
    }

    public synchronized int getProcessorsSize() {
        return this.processors.size();
    }

    public synchronized void check() {
        Iterator<DashboradTask> it = this.processors.iterator();
        while (it.hasNext()) {
            DashboradTask t = it.next();
            if (!t.isValid()) continue;
            it.remove();
            LOGGER.info((Object)("a task remove from processors.task is " + t));
        }
    }

    public synchronized List<DashboardQueryBean> queryAllData(List<DashboardQueryBean> queryBeans) {
        ArrayList<DashboardQueryBean> newQueryBeans = new ArrayList<DashboardQueryBean>();
        for (DashboardQueryBean bean : queryBeans) {
            if (3 == bean.getDirection()) {
                bean.setDirection(1);
                this.addAndQureyTask(bean);
                DashboardQueryBean outboundBean = new DashboardQueryBean(bean);
                outboundBean.setDirection(2);
                this.addAndQureyTask(outboundBean);
                newQueryBeans.add(outboundBean);
                continue;
            }
            this.addAndQureyTask(bean);
        }
        LOGGER.debug((Object)("dashboad query data is :" + queryBeans));
        queryBeans.addAll(newQueryBeans);
        return queryBeans;
    }

    private void addAndQureyTask(DashboardQueryBean bean) {
        DashboradTask task = new DashboradTask(bean);
        if (!this.processors.add(task)) {
            for (DashboradTask t : this.processors) {
                t.queryData(bean);
            }
        } else {
            LOGGER.info((Object)("add a new task ." + task));
        }
    }

    @Override
    protected synchronized List<T> handelEvents(List<T> events) {
        this.checkDevHasData(events);
        for (DashboradTask task : this.processors) {
            task.merge(events);
        }
        return events;
    }

    private void checkDevHasData(List<T> events) {
        block0: for (Event e : events) {
            for (DashboradTask task : this.processors) {
                if (!task.isMatch(e)) continue;
                this.map.put(task, System.currentTimeMillis());
                continue block0;
            }
        }
        ArrayList<DashboradTask> removeDevList = new ArrayList<DashboradTask>();
        for (DashboradTask task : this.processors) {
            Long devHasDataTime = this.map.get(task);
            if (null == devHasDataTime || System.currentTimeMillis() - devHasDataTime < 180000L) continue;
            task.clearDashboradData();
            if (removeDevList.contains(task)) continue;
            removeDevList.add(task);
        }
        for (DashboradTask task : removeDevList) {
            this.map.remove(task);
        }
    }

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> r = new ArrayList<Event>();
        for (Event t : events) {
            if (!t.isNeedSum() || !(t instanceof FirstPageEvent) || t.getIdentifier().isDesZone() || t.getIdentifier().isIpLocation()) continue;
            r.add(t);
        }
        return r;
    }
}

