/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.List;

public class DnsDefendEventHandler
extends EventHandler<DnsDefendEvent, DnsDefendEvent>
implements Processor<DnsDefendEvent> {
    List<DnsDefendEvent> cacheList = new ArrayList<DnsDefendEvent>();
    private long lastTime;
    private final int period;

    public DnsDefendEventHandler(int period) {
        this.period = period;
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    protected void refreshLogTime(List<DnsDefendEvent> eventsAfterMergeByIp) {
        this.lastTime = EventUtil.getIntegralTime(this.period);
        long time = this.lastTime - (long)this.period;
        for (DnsDefendEvent event : eventsAfterMergeByIp) {
            event.setLogTime(time);
        }
    }

    @Override
    public void handel(List<DnsDefendEvent> events) {
        if (this.isTimeToMerge()) {
            ArrayList<DnsDefendEvent> list = new ArrayList<DnsDefendEvent>();
            list.addAll(this.cacheList);
            this.cacheList.clear();
            this.refreshLogTime(list);
            EventUtil.createEvents(list);
            this.notifyFollowHandlers(list);
        }
        this.handelEvents(events);
    }

    @Override
    protected List<DnsDefendEvent> handelEvents(List<DnsDefendEvent> events) {
        ArrayList<DnsDefendEvent> alarmList = new ArrayList<DnsDefendEvent>();
        for (DnsDefendEvent e : events) {
            if (this.cacheList.contains(e)) {
                this.cacheList.get(this.cacheList.indexOf(e)).merge(e);
                continue;
            }
            this.cacheList.add(e);
            alarmList.add(e);
        }
        AlarmThread.getInstance().addDnsDefendAlarmStart(alarmList);
        return new ArrayList<DnsDefendEvent>();
    }

    @Override
    public void processMetaData(List<DnsDefendEvent> datas) {
        this.handel(datas);
    }

    @Override
    protected List<DnsDefendEvent> debugEvents(List<DnsDefendEvent> events) {
        return events;
    }

    public List<DnsDefendEvent> getCacheList() {
        return this.cacheList;
    }
}

