/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DnsDefendParserV3
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getBizEventLog();
    private static final int STATIC_DNS_DEFEND = 14;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 14) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stram error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent event) throws IOException {
        DnsDefendEvent dnsDefendEvent = new DnsDefendEvent(event.getIdentifier());
        dnsDefendEvent.setRequestNum(stream.readUnsignedInt());
        int domainLen = stream.readUnsignedShort();
        if (stream.skip(2L) != 2L) {
            LOGGER.error((Object)"stream read error");
        }
        int ipNum = stream.readUnsignedByte();
        if (stream.skip(3L) != 3L) {
            LOGGER.error((Object)"stream read error");
        }
        if (domainLen > 0) {
            byte[] domain = new byte[domainLen];
            if (stream.read(domain) != domainLen) {
                LOGGER.error((Object)"stream read error");
            }
            dnsDefendEvent.setDomaiName(new String(domain, "utf-8"));
        }
        for (int i = 0; i < ipNum; ++i) {
            int ipType = stream.readUnsignedByte();
            byte[] ipByte = new byte[16];
            if (stream.read(ipByte) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            dnsDefendEvent.addSrcIp(IpTransformer.byte2String(ipByte, ipType));
        }
        if (null != dnsDefendEvent.getDomaiName() && !"".equals(dnsDefendEvent.getDomaiName())) {
            event.addDnsDefendEvent(dnsDefendEvent);
        }
    }
}

