/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.SrcTopnWirteFileThread;
import com.hs.atic.collector.biz.event.process.SumCycEvent;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.SrcTopnEvent;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DnsEventHandler
extends EventHandler<Event, Event>
implements Processor<Event> {
    protected static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final long CYC = 80L;
    private long lastTime;
    private final int period;
    private long lastCycTime;
    private Map<Type, SumCycEvent<Event>> ipEventMaps = new HashMap<Type, SumCycEvent<Event>>();
    private SrcTopnWirteFileThread srcTopnWirteFileThread = null;

    public DnsEventHandler(int peroid) {
        this.period = peroid;
        this.refreshLastTime();
        this.lastCycTime = System.currentTimeMillis() / 1000L;
    }

    protected boolean isTimeToSumOnCyc() {
        return System.currentTimeMillis() / 1000L - this.lastCycTime >= 80L;
    }

    protected void sumOnOneCyc() {
        for (Map.Entry<Type, SumCycEvent<Event>> entry : this.ipEventMaps.entrySet()) {
            entry.getValue().sumOnOneCyc();
        }
    }

    @Override
    protected List<Event> handelEvents(List<Event> events) {
        try {
            if (this.isTimeToSumOnCyc()) {
                this.lastCycTime = System.currentTimeMillis() / 1000L;
                this.sumOnOneCyc();
            }
            if (this.isTimeToMerge()) {
                ArrayList<Event> list = new ArrayList<Event>();
                ArrayList<SrcTopnEvent> srcTopnList = new ArrayList<SrcTopnEvent>();
                HashMap<Type, Event> remove = new HashMap<Type, Event>();
                boolean isSaveDb = true;
                for (Map.Entry<Type, SumCycEvent<Event>> entry : this.ipEventMaps.entrySet()) {
                    isSaveDb = true;
                    Event t = entry.getValue().getInEvent();
                    if (null != t && t.isValid()) {
                        SrcTopnEvent srcTopn;
                        if (!t.isZoneEvent()) {
                            t.getIdentifier().setZoneIpType();
                        }
                        if (t instanceof SrcTopnEvent && 100 == (srcTopn = (SrcTopnEvent)t).getTopnType()) {
                            isSaveDb = false;
                            srcTopnList.add(srcTopn);
                        }
                        if (isSaveDb) {
                            list.add(t);
                        }
                    }
                    entry.getValue().reset();
                    if (!entry.getValue().isCanDestroy()) continue;
                    remove.put(entry.getKey(), t);
                }
                for (Map.Entry<Type, SumCycEvent<Event>> entry : remove.entrySet()) {
                    this.ipEventMaps.remove(entry.getKey());
                    MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.sub5minEvent((Event)((Object)entry.getValue()));
                }
                if (!srcTopnList.isEmpty()) {
                    this.checkAndStartThread();
                    this.refreshSrcTopnLogTime(srcTopnList);
                    this.srcTopnWirteFileThread.addSrcTopnEvent(srcTopnList);
                }
                this.refreshLastTime();
                this.refreshLogTime(list);
                EventUtil.createEvents(list);
                this.notifyFollowHandlers(list);
            }
            this.processEventsForCpu(events);
        }
        catch (OutOfMemoryError error) {
            LOGGER.error((Object)"out of memory ,then I clear the  data");
        }
        return new ArrayList<Event>();
    }

    private void checkAndStartThread() {
        if (null == this.srcTopnWirteFileThread) {
            this.srcTopnWirteFileThread = new SrcTopnWirteFileThread();
            this.srcTopnWirteFileThread.setTimePeriod(this.period);
            this.srcTopnWirteFileThread.start();
        }
    }

    private void processEventsForCpu(List<Event> events) {
        for (Event event : events) {
            BizType type = new BizType(event);
            if (this.ipEventMaps.containsKey(type)) {
                this.ipEventMaps.get(type).addEvent(event);
                continue;
            }
            this.ipEventMaps.put(type, new SumCycEvent<Event>(event));
            MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.add5minEvent(event);
        }
    }

    private void refreshLogTime(List<Event> events) {
        long time = EventUtil.getIntegralTime(this.period);
        time -= (long)this.period;
        for (Event event : events) {
            event.setLogTime(time);
        }
    }

    private void refreshSrcTopnLogTime(List<SrcTopnEvent> srcTopnList) {
        long time = EventUtil.getIntegralTime(this.period);
        time -= (long)this.period;
        for (Event event : srcTopnList) {
            event.setLogTime(time);
        }
    }

    @Override
    public void processMetaData(List<Event> datas) {
        this.handelEvents(datas);
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    private void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(this.period);
    }
}

