/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.ContentTopnEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DnsTopnEventParserV2
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int DNS_TOPN = 9;
    private static final int DNS_TOPN_TYPE = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent event, int type, int number) throws IOException {
        if (type == 9) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, event);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stram error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent suit) throws IOException {
        ContentTopnEvent dnsTopnEvent = new ContentTopnEvent(suit.getIdentifier());
        this.readDnsTopnEvent(stream, dnsTopnEvent);
        if (!dnsTopnEvent.getDomianName().trim().equals("")) {
            suit.addDnsTopnEvent(dnsTopnEvent);
        } else {
            LOGGER.info((Object)("I drop a DnsTopnEvent.Domian name is empty. " + dnsTopnEvent));
        }
    }

    private void readDnsTopnEvent(UnsignedDataInputStream stream, ContentTopnEvent dnsTopnEvent) throws IOException {
        stream.readUnsignedShort();
        stream.readUnsignedShort();
        dnsTopnEvent.setRequestPps(stream.readUnsignedInt());
        dnsTopnEvent.setRequsetKbps(stream.readUnsignedInt());
        int dnsLen = stream.readUnsignedShort();
        dnsTopnEvent.setDnsLen(dnsLen);
        stream.readUnsignedShort();
        dnsTopnEvent.setRequestType(0);
        byte[] name = new byte[dnsLen];
        if (stream.read(name) != dnsLen) {
            LOGGER.error((Object)"stream read error");
        }
        dnsTopnEvent.setDomianName(new String(name, "utf-8").trim());
        dnsTopnEvent.setTopnType(9);
    }
}

