/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class EventHandler<T extends Event, S extends Event> {
    protected Logger logger = LogManager.getInstance().getFlowLog();
    private Collection<EventHandler<T, S>> followHandles = new ArrayList<EventHandler<T, S>>();

    public void addFollowHandle(EventHandler handle) {
        this.followHandles.add(handle);
    }

    public Collection<EventHandler<T, S>> getFollowHandles() {
        return this.followHandles;
    }

    public void handel(List<T> events) {
        long preTime = System.currentTimeMillis() / 1000L;
        this.eventPrintLog(events);
        List<T> list = this.debugEvents(events);
        this.evenHandleUsedTimeLog(0, preTime);
        List<S> result = this.handelEvents(list);
        this.evenHandleUsedTimeLog(1, preTime);
        this.notifyFollowHandlers(result);
    }

    public void evenHandleUsedTimeLog(int flag, long preTime) {
        long curTime = 0L;
        long usedTim = 0L;
        String className = this.getClass().getName();
        if (this.logger.isInfoEnabled()) {
            boolean usedTimeFlag = false;
            if (className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.AllCpuMinSumHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.AllCpu5minSumHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.SysLogHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.DashboardEventHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.Alarm70secFlowHandler")) {
                usedTimeFlag = true;
            } else if (className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.AlarmThread") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.SumMinFlowHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.BaselineFlowSumHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.BaselineRepositoryHandlerThread")) {
                usedTimeFlag = true;
            } else if (className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.ZoneFlowEventHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.IpAverageEventHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.IpLocation5minSumHandler") || className.equalsIgnoreCase("com.hs.atic.collector.biz.event.process.SumAllFlowHandler")) {
                usedTimeFlag = true;
            }
            if (usedTimeFlag && (usedTim = (curTime = System.currentTimeMillis() / 1000L) - preTime) > 1L) {
                this.logger.info((Object)(" class = " + className + " usedTime = " + usedTim + " flag = " + flag + " preTime = " + preTime + " curTime = " + curTime));
            }
        }
    }

    public void eventPrintLog(List<T> events) {
        String className = this.getClass().getName();
        if (this.logger.isInfoEnabled()) {
            for (Event t : events) {
                if (!t.isDeviceEvent()) continue;
                this.logger.info((Object)(" className = " + className + " isDeviceEvent = " + t.toString()));
            }
        }
    }

    public void removeHandle(EventHandler<T, S> handle) {
        this.followHandles.remove(handle);
    }

    protected List<T> debugEvents(List<T> events) {
        return events;
    }

    protected abstract List<S> handelEvents(List<T> var1);

    protected void notifyFollowHandlers(List<S> result) {
        for (EventHandler<S, S> eventHandler : this.followHandles) {
            try {
                eventHandler.handel(result);
            }
            catch (Exception e) {
                this.logger.error((Object)(eventHandler + " handle error!" + e.getMessage()));
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

