/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.nfa.NfaEventDataParser;
import com.hs.atic.collector.biz.event.nfa.NfaParserAttackSrcEventV1;
import com.hs.atic.collector.biz.event.nfa.NfaParserAttackSrcEventV2;
import com.hs.atic.collector.biz.event.nfa.NfaParserExceptionEventV1;
import com.hs.atic.collector.biz.event.nfa.NfaParserFlowEventV1;
import com.hs.atic.collector.biz.event.process.AttackEventParserV6;
import com.hs.atic.collector.biz.event.process.AttackEventParserV7;
import com.hs.atic.collector.biz.event.process.BizEventParserV3;
import com.hs.atic.collector.biz.event.process.BlackListEventParserV3;
import com.hs.atic.collector.biz.event.process.ContentTopnEventParserV4;
import com.hs.atic.collector.biz.event.process.DnsDefendParserV3;
import com.hs.atic.collector.biz.event.process.DnsStatisEventParserV2;
import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV6;
import com.hs.atic.collector.biz.event.process.ExceptionEventParserV7;
import com.hs.atic.collector.biz.event.process.FlowEventParserV6;
import com.hs.atic.collector.biz.event.process.FlowEventParserV7;
import com.hs.atic.collector.biz.event.process.IPReputationParserV1;
import com.hs.atic.collector.biz.event.process.SecondFlowParserV1;
import com.hs.atic.collector.biz.event.process.SrcTopnEventParserV4;
import com.hs.atic.collector.biz.event.process.StaticFingerParserV3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventPacketParserFactory {
    private static EventPacketParserFactory instance = new EventPacketParserFactory();
    private static Map<Integer, List<EventDataParser>> cache = new HashMap<Integer, List<EventDataParser>>();
    private static Map<Integer, List<NfaEventDataParser>> nfaCache = new HashMap<Integer, List<NfaEventDataParser>>();

    public static EventPacketParserFactory getInstance() {
        return instance;
    }

    public List<EventDataParser> getEventDataParsers(int version) {
        if (cache.containsKey(version)) {
            return cache.get(version);
        }
        if (1 == version || 2 == version || 3 == version || 4 == version || 5 == version) {
            return null;
        }
        ArrayList<EventDataParser> dataParsers = new ArrayList<EventDataParser>();
        if (6 == version) {
            dataParsers.add(new FlowEventParserV6());
            dataParsers.add(new ExceptionEventParserV6());
            dataParsers.add(new AttackEventParserV6());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            dataParsers.add(new SecondFlowParserV1());
            cache.put(version, dataParsers);
        } else if (7 == version) {
            dataParsers.add(new FlowEventParserV7());
            dataParsers.add(new ExceptionEventParserV7());
            dataParsers.add(new AttackEventParserV7());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            dataParsers.add(new SecondFlowParserV1());
            dataParsers.add(new IPReputationParserV1());
            cache.put(version, dataParsers);
        } else if (8 == version) {
            dataParsers.add(new FlowEventParserV7());
            dataParsers.add(new ExceptionEventParserV7());
            dataParsers.add(new AttackEventParserV7());
            dataParsers.add(new BlackListEventParserV3());
            dataParsers.add(new BizEventParserV3());
            dataParsers.add(new DnsStatisEventParserV2());
            dataParsers.add(new SrcTopnEventParserV4());
            dataParsers.add(new ContentTopnEventParserV4());
            dataParsers.add(new StaticFingerParserV3());
            dataParsers.add(new DnsDefendParserV3());
            dataParsers.add(new SecondFlowParserV1());
            dataParsers.add(new IPReputationParserV1());
            cache.put(version, dataParsers);
        }
        return dataParsers;
    }

    public List<NfaEventDataParser> getNfaEventParsers(int version) {
        if (nfaCache.containsKey(version)) {
            return nfaCache.get(version);
        }
        ArrayList<NfaEventDataParser> parserList = new ArrayList<NfaEventDataParser>();
        if (1 == version) {
            parserList.add(new NfaParserFlowEventV1());
            parserList.add(new NfaParserExceptionEventV1());
            parserList.add(new NfaParserAttackSrcEventV1());
            nfaCache.put(version, parserList);
        }
        if (2 == version) {
            parserList.add(new NfaParserFlowEventV1());
            parserList.add(new NfaParserExceptionEventV1());
            parserList.add(new NfaParserAttackSrcEventV2());
            nfaCache.put(version, parserList);
        }
        return parserList;
    }
}

