/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.init.CollectorVersionRepository;
import com.hs.atic.collector.util.AttackEventUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.SevenEventPaserUtil;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ExceptionEventParserV7
implements EventDataParser {
    private static final int ALERT = 4;
    private static final long DEFAULT_BIZ_ID = 0L;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (type == 4) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    OriginalExceptionEvent event = new OriginalExceptionEvent(suitEvent.getIdentifier());
                    ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
                    int abnormalType = this.parseAlert((UnsignedDataInputStream)stream, event, subAttackEventList);
                    if (event.getIdentifier().getBizId() != 0L || event.getIdentifier().isDesZone() || !CollectorVersionRepository.getInstance().isNeedDrop()) {
                        if (subAttackEventList.isEmpty()) {
                            AttackEventUtil.setExceptionEventType(event, abnormalType);
                            suitEvent.addOriginalExceptionEvent(event);
                            continue;
                        }
                        for (OriginalExceptionEvent subAttackEvent : subAttackEventList) {
                            AttackEventUtil.setExceptionEventType(subAttackEvent, abnormalType);
                            suitEvent.addOriginalExceptionEvent(subAttackEvent);
                        }
                        continue;
                    }
                    LOGGER.info((Object)("Drop a alert log by bidId=0 or isDesZone or isNeedDrop: " + event.toString()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stream error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private int parseAlert(UnsignedDataInputStream stream, OriginalExceptionEvent event, List<OriginalExceptionEvent> subAttackEventList) throws IOException {
        int type = stream.readUnsignedByte();
        int state = stream.readUnsignedByte();
        stream.readUnsignedShort();
        int protocol = stream.readUnsignedByte();
        int ppsOrKbps = stream.readUnsignedByte();
        int port = stream.readUnsignedShort();
        event.setPortData(port);
        port = 0;
        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(type, protocol, port);
        if (attackType.isCustomServiceAttack()) {
            long bizId = FoundIDUtil.getInstance().getBizId(event.getIdentifier().getZoneId(), EventUtil.getCustomProtocolStr(attackType.getProtocol()), port, event.getIdentifier().getDeviceIp());
            EventIdentifier identifer = event.getIdentifierCopy();
            identifer.setBizId(bizId);
            event.setIdentifer(identifer);
        }
        event.setAttackType(attackType);
        stream.readUnsignedInt();
        if (state == 3) {
            event.setDropKbits(stream.readUnsignedLong());
            event.setDropPkgs(stream.readUnsignedLong());
        } else {
            stream.readUnsignedLong();
            stream.readUnsignedLong();
        }
        long normalKbps = stream.readUnsignedLong();
        long normalPps = stream.readUnsignedLong();
        long realKbps = stream.readUnsignedLong();
        long realPps = stream.readUnsignedLong();
        if (event.isConnectionFlood()) {
            event.setNormalValue(normalKbps);
            event.setRealValue(realKbps);
            event.setPpsOrKbps(3);
            event.setNormalValue1(normalPps);
            event.setRealValue1(realPps);
            event.setPpsOrKbps1(4);
        } else if (27 == type) {
            event.setNormalValue(normalPps);
            event.setRealValue(realPps);
            event.setPpsOrKbps(2);
        } else {
            if (ppsOrKbps == 1) {
                event.setNormalValue(normalKbps);
                event.setRealValue(realKbps);
                event.setNormalValue1(normalPps);
                event.setRealValue1(realPps);
                event.setPpsOrKbps1(0);
            } else {
                event.setNormalValue(normalPps);
                event.setRealValue(realPps);
                event.setNormalValue1(normalKbps);
                event.setRealValue1(realKbps);
                event.setPpsOrKbps1(1);
            }
            event.setPpsOrKbps(ppsOrKbps);
        }
        long attackKbps = stream.readUnsignedLong();
        long attackPpsOrQps = stream.readUnsignedLong();
        long ipCurKbps = stream.readUnsignedLong();
        long ipCurPps = stream.readUnsignedLong();
        long ipAttackKbps = stream.readUnsignedLong();
        long ipAttackPps = stream.readUnsignedLong();
        long tcpNewConnNum = stream.readUnsignedLong();
        long tcpCurConnNum = stream.readUnsignedLong();
        event.setAttackPeakKbps(attackKbps);
        event.setAttackPeakPpsOrQps(attackPpsOrQps);
        event.setIpInPeakKbps(ipCurKbps);
        event.setIpInPeakPps(ipCurPps);
        event.setIpAttackPeakKbps(ipAttackKbps);
        event.setIpAttackPeakPps(ipAttackPps);
        event.setTcpNewConnNum(tcpNewConnNum);
        event.setTcpCurConnNum(tcpCurConnNum);
        event.setAlertStartTime(event.getLogTime());
        event.setAlertEndTime(event.getLogTime());
        int ucExtInfoType = stream.readUnsignedByte();
        stream.readUnsignedByte();
        int expandLen = stream.readUnsignedShort();
        stream.readUnsignedInt();
        if (0 == ucExtInfoType && expandLen > 0) {
            long ipv4Count;
            int ucExtInfoType7 = stream.readUnsignedByte();
            int devenEventPaserType = ucExtInfoType7 >> 4;
            int sevenHeadLogNum = stream.readUnsignedByte();
            stream.readUnsignedShort();
            if ((ucExtInfoType7 &= 0xF) == 0 || ucExtInfoType7 == 1) {
                ipv4Count = stream.readUnsignedInt();
                int i = 0;
                while ((long)i < ipv4Count) {
                    long ip = stream.readUnsignedInt();
                    String ipStr = IpTransformer.long2StringFormat(ip);
                    if (IPUtil.isIpv4(ipStr)) {
                        event.addAttacker(ipStr);
                    }
                    ++i;
                }
                long ipv6Count = stream.readUnsignedInt();
                int i2 = 0;
                while ((long)i2 < ipv6Count) {
                    byte[] b = new byte[16];
                    if (stream.read(b) != 16) {
                        LOGGER.error((Object)"stream read error");
                    }
                    event.addAttacker(IpTransformer.byte2String(b, 6));
                    ++i2;
                }
            } else if (ucExtInfoType7 == 2 || ucExtInfoType7 == 3) {
                long ipv6Count;
                ipv4Count = stream.readUnsignedInt();
                if (ipv4Count != 0L) {
                    AttackEventUtil.readIpv4AddrAndPort(stream, event, ipv4Count);
                }
                if ((ipv6Count = stream.readUnsignedInt()) != 0L) {
                    AttackEventUtil.readIpv6AddrAndPort(stream, event, ipv6Count);
                }
            }
            if (SevenEventPaserUtil.getInstance().needPaserSevenPacket(event)) {
                if (sevenHeadLogNum > 0 && devenEventPaserType == 0) {
                    List<OriginalExceptionEvent> tempSubAttackEventList = SevenEventPaserUtil.getInstance().parseSevenPacketV7(stream, event, sevenHeadLogNum, true);
                    if (!tempSubAttackEventList.isEmpty()) {
                        subAttackEventList.addAll(tempSubAttackEventList);
                    }
                } else if (sevenHeadLogNum > 0 && (devenEventPaserType == 1 || devenEventPaserType == 2)) {
                    List<OriginalExceptionEvent> tempSubAttackEventList = SevenEventPaserUtil.getInstance().parseSevenPacketV7New(stream, event, sevenHeadLogNum, devenEventPaserType == 2);
                    if (!tempSubAttackEventList.isEmpty()) {
                        subAttackEventList.addAll(tempSubAttackEventList);
                    }
                } else {
                    List<OriginalExceptionEvent> tempSubAttackEventList;
                    if (state == 1 || state == 3) {
                        LOGGER.info((Object)("the attackType=" + type + "; event=" + event.toString()));
                    }
                    if (!(tempSubAttackEventList = SevenEventPaserUtil.getInstance().processAbnormalOrEndSubAttackEvent(event, state)).isEmpty()) {
                        subAttackEventList.addAll(tempSubAttackEventList);
                    }
                }
            }
        } else {
            List<OriginalExceptionEvent> tempSubAttackEventList;
            if (expandLen > 0 && stream.skip(expandLen) != (long)expandLen) {
                LOGGER.error((Object)"stream read error");
            }
            if (SevenEventPaserUtil.getInstance().needPaserSevenPacket(event) && !(tempSubAttackEventList = SevenEventPaserUtil.getInstance().processAbnormalOrEndSubAttackEvent(event, state)).isEmpty()) {
                subAttackEventList.addAll(tempSubAttackEventList);
            }
        }
        return state;
    }
}

