/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.FilterType;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.BizAttackEvent;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ExceptionEventSumRepositoryThread
extends EventHandler<ChangeEvent<AbnormalEvent>, ChangeEvent<AbnormalEvent>>
implements Runnable {
    private static final long SLEEPING_TIME = 5000L;
    private static final String IP_ATTACK_EVENT = "com.hs.atic.collector.entity.event.IpAttackEvent";
    private static AtomicBoolean needRepository = new AtomicBoolean(false);
    private static final int TIMES = 5;
    protected ReentrantLock lock = new ReentrantLock();
    List<AbnormalEvent> attacked = new ArrayList<AbnormalEvent>();
    private Repository repository;
    private String eventName;
    private Map<Type, AbnormalEvent> attacking = new HashMap<Type, AbnormalEvent>();
    private Map<Type, AbnormalEvent> attackStart = new HashMap<Type, AbnormalEvent>();

    public ExceptionEventSumRepositoryThread(String eventName1) {
        super.setLogger(LogManager.getInstance().getDBLog());
        this.eventName = eventName1;
        this.repository = RepositoryFactory.getInstance().getRepository(this.eventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ChangeEvent<AbnormalEvent>> handelEvents(List<ChangeEvent<AbnormalEvent>> events) {
        if (!events.isEmpty()) {
            if (needRepository.get()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("Thread.sleep InterruptedException error!" + e.getMessage()));
                }
            }
            this.lock.lock();
            try {
                for (ChangeEvent<AbnormalEvent> each : events) {
                    AbnormalEvent source = each.getSource();
                    FilterType type = source instanceof IpAttackEvent ? new IpType(each.getIdentifier()) : (source instanceof BizAttackEvent ? new BizType(each.getIdentifier()) : new ZoneType(each.getIdentifier()));
                    if (source.isNormal()) {
                        this.attacking.remove(type);
                        this.attackStart.remove(type);
                        this.attacked.add(source);
                        continue;
                    }
                    if (!source.isSaved() && !this.attackStart.containsKey(type)) {
                        this.attacking.remove(type);
                        this.attackStart.put(type, source);
                    }
                    if (!source.isSaved() || this.attackStart.containsKey(type) || this.attacking.containsKey(type)) continue;
                    this.attacking.put(type, source);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return new ArrayList<ChangeEvent<AbnormalEvent>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<AbnormalEvent> attackedTemp = null;
        ArrayList<AbnormalEvent> ulist = new ArrayList<AbnormalEvent>();
        ArrayList<AbnormalEvent> clist = new ArrayList<AbnormalEvent>();
        Map<Type, AbnormalEvent> attackingTemp = null;
        Map<Type, AbnormalEvent> attackStartTemp = null;
        int time = 0;
        while (true) {
            needRepository.set(true);
            ++time;
            this.lock.lock();
            try {
                attackedTemp = this.attacked;
                this.attacked = new ArrayList<AbnormalEvent>();
                attackStartTemp = this.attackStart;
                this.attackStart = new HashMap<Type, AbnormalEvent>();
                if (time == 5) {
                    attackingTemp = this.attacking;
                    this.attacking = new HashMap<Type, AbnormalEvent>();
                    time = 0;
                }
            }
            finally {
                this.lock.unlock();
            }
            needRepository.set(false);
            try {
                this.processData4AttackedAndList(attackedTemp, ulist, clist, attackStartTemp);
                this.processData4AttackingAndList(attackingTemp, ulist, clist, attackStartTemp);
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("exception events into db error! " + e.getMessage()));
                ulist.clear();
                clist.clear();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)("Thread.sleep InterruptedException error!" + e1.getMessage()));
                }
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("Thread.sleep InterruptedException error!" + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private void processData4AttackingAndList(Map<Type, AbnormalEvent> attackingTemp, List<AbnormalEvent> ulist, List<AbnormalEvent> clist, Map<Type, AbnormalEvent> attackStartTemp) {
        if (null != attackingTemp && !attackingTemp.isEmpty()) {
            for (AbnormalEvent event : attackingTemp.values()) {
                if (event.isSaved()) {
                    ulist.add(event);
                    continue;
                }
                clist.add(event);
            }
            attackingTemp.clear();
        }
        if (!ulist.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("update abnormal events :" + ulist));
            }
            this.repository.updateObjects(ulist);
            ulist.clear();
        }
        if (!clist.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("create abnormal events :" + clist));
            }
            this.repository.createObjects(clist);
            clist.clear();
        }
    }

    private void processData4AttackedAndList(List<AbnormalEvent> attackedTemp, List<AbnormalEvent> ulist, List<AbnormalEvent> clist, Map<Type, AbnormalEvent> attackStartTemp) {
        if (!attackedTemp.isEmpty()) {
            for (AbnormalEvent e : attackedTemp) {
                if (e.isSaved()) {
                    ulist.add(e);
                    continue;
                }
                clist.add(e);
            }
        }
        if (!attackStartTemp.isEmpty()) {
            for (AbnormalEvent event : attackStartTemp.values()) {
                if (event.isSaved()) {
                    ulist.add(event);
                    continue;
                }
                clist.add(event);
            }
        }
    }
}

