/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.nfa.NfaAttackSrcFlow;
import com.hs.atic.collector.biz.event.process.ChangeEvent;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.GeneratePrimalKey;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExceptionLifeHandler
extends EventHandler<OriginalExceptionEvent, ChangeEvent<ExceptionEvent>> {
    private Map<Type, ExceptionEvent> exceptionRecords = new HashMap<Type, ExceptionEvent>();
    private boolean clean;

    public ExceptionLifeHandler(boolean isFromCleanDevice) {
        this.clean = isFromCleanDevice;
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    public void init(List<ExceptionEvent> events) {
        for (ExceptionEvent event : events) {
            IpType type = new IpType(event.getType(), event.getIdentifier());
            this.exceptionRecords.put(type, event);
        }
        this.logger.info((Object)("init ok, cache data are " + this.exceptionRecords));
    }

    private List<ChangeEvent<ExceptionEvent>> proceedOriginalExceptionEvent(List<OriginalExceptionEvent> events) {
        if (!events.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" before proceed cache exception events :" + LogManager.NEXT_LINE + this.exceptionRecords));
        }
        ArrayList<ChangeEvent<ExceptionEvent>> changed = new ArrayList<ChangeEvent<ExceptionEvent>>();
        changed.addAll(this.updateExceptionEvents(events));
        changed.addAll(this.updateTimeOutExceptionEvents());
        if (!events.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" after update exception  events :cache is " + LogManager.NEXT_LINE + this.exceptionRecords));
        }
        Map<Type, List<ChangeEvent<ExceptionEvent>>> groupEventsByIp = EventUtil.groupEventsByZoneIp(changed);
        return this.mergeByIp(groupEventsByIp);
    }

    public void setExceptionRecords(Map<Type, ExceptionEvent> exceptionRecords) {
        this.exceptionRecords = exceptionRecords;
    }

    public Map<Type, ExceptionEvent> getExceptionRecords() {
        return this.exceptionRecords;
    }

    @Override
    protected List<ChangeEvent<ExceptionEvent>> handelEvents(List<OriginalExceptionEvent> events) {
        ArrayList<OriginalExceptionEvent> list = new ArrayList<OriginalExceptionEvent>();
        for (OriginalExceptionEvent event : events) {
            if (this.clean) {
                if (!event.isFromCleanDevice()) continue;
                list.add(event);
                continue;
            }
            if (event.isFromCleanDevice()) continue;
            list.add(event);
        }
        return this.proceedOriginalExceptionEvent(list);
    }

    private List<OriginalExceptionEvent> createEndOriginalEvent(ExceptionEvent each) {
        ArrayList<OriginalExceptionEvent> normalOriginalEvents = new ArrayList<OriginalExceptionEvent>();
        long timeOutPoint = each.getAlertEndTime() + ExceptionEvent.getTimeOutPeroid();
        for (int cpu : each.getAbnormalCpus()) {
            EventIdentifier identifier = each.getIdentifierCopy();
            identifier.setCpu(cpu);
            OriginalExceptionEvent event = new OriginalExceptionEvent(identifier);
            event.setAttackType(each.getAttackType());
            event.setCurrentState(0);
            event.setDropPkgs(0L);
            event.setAlertStartTime(timeOutPoint);
            event.setAlertEndTime(timeOutPoint);
            normalOriginalEvents.add(event);
        }
        return normalOriginalEvents;
    }

    private ExceptionEvent getExceptionEvents(Type type, OriginalExceptionEvent originalExceptionEvent) {
        if (this.exceptionRecords.containsKey(type)) {
            return this.exceptionRecords.get(type);
        }
        if (!originalExceptionEvent.isNormal() && !originalExceptionEvent.isAttackSrcEvent()) {
            EventIdentifier identifier = originalExceptionEvent.getIdentifierCopy();
            identifier.setZoneIpType();
            ExceptionEvent event = new ExceptionEvent(identifier);
            event.setAttackType(originalExceptionEvent.getAttackType());
            event.setAbnormalPkId(GeneratePrimalKey.getInstance().getOriginalKey());
            this.exceptionRecords.put(type, event);
            return event;
        }
        return null;
    }

    private List<ChangeEvent<ExceptionEvent>> updateExceptionEvents(List<OriginalExceptionEvent> events) {
        ArrayList<ChangeEvent<ExceptionEvent>> changed = new ArrayList<ChangeEvent<ExceptionEvent>>();
        for (OriginalExceptionEvent original : events) {
            IpType type = new IpType(original.getType(), original.getIdentifier());
            ExceptionEvent exceptionEvent = this.getExceptionEvents(type, original);
            if (null == exceptionEvent) continue;
            ArrayList<OriginalExceptionEvent> temp = new ArrayList<OriginalExceptionEvent>();
            temp.add(original);
            Event changeEvent = exceptionEvent.sumElement(temp);
            if (original.isAttackSrcEvent()) {
                this.processAttackSrcTopnFlowData(original, exceptionEvent);
            }
            ChangeEvent<Event> change = new ChangeEvent<Event>(exceptionEvent, changeEvent);
            if (exceptionEvent.isNormal()) {
                this.exceptionRecords.remove(type);
            }
            changed.add(change);
        }
        return changed;
    }

    private void processAttackSrcTopnFlowData(OriginalExceptionEvent original, ExceptionEvent exceptionEvent) {
        int i;
        ArrayList<NfaAttackSrcFlow> allAttakcFlow = new ArrayList<NfaAttackSrcFlow>();
        allAttakcFlow.addAll(original.getAttackerFlowData());
        allAttakcFlow.addAll(exceptionEvent.getAttackerFlowData());
        if (allAttakcFlow.isEmpty()) {
            exceptionEvent.addAttackers(original.getAttackers());
            return;
        }
        for (i = 0; i < allAttakcFlow.size(); ++i) {
            for (int j = allAttakcFlow.size() - 1; j > i; --j) {
                if (!((NfaAttackSrcFlow)allAttakcFlow.get(i)).getAttackSrcIp().equals(((NfaAttackSrcFlow)allAttakcFlow.get(j)).getAttackSrcIp())) continue;
                if (((NfaAttackSrcFlow)allAttakcFlow.get(i)).getKbps() < ((NfaAttackSrcFlow)allAttakcFlow.get(j)).getKbps()) {
                    ((NfaAttackSrcFlow)allAttakcFlow.get(i)).setKbps(((NfaAttackSrcFlow)allAttakcFlow.get(j)).getKbps());
                    ((NfaAttackSrcFlow)allAttakcFlow.get(i)).setPps(((NfaAttackSrcFlow)allAttakcFlow.get(j)).getPps());
                }
                allAttakcFlow.remove(j);
            }
        }
        Collections.sort(allAttakcFlow);
        if (allAttakcFlow.size() > 100) {
            for (i = allAttakcFlow.size() - 1; i >= 100; --i) {
                allAttakcFlow.remove(i);
            }
        }
        HashSet<String> attackers = new HashSet<String>();
        for (NfaAttackSrcFlow nfaAttackSrcFlowItem : allAttakcFlow) {
            attackers.add(nfaAttackSrcFlowItem.getAttackSrcIp());
        }
        exceptionEvent.setAttackers(attackers);
        exceptionEvent.setAttackerFlowData(allAttakcFlow);
    }

    private List<ChangeEvent<ExceptionEvent>> mergeByIp(Map<Type, List<ChangeEvent<ExceptionEvent>>> groupsByIp) {
        ArrayList<ChangeEvent<ExceptionEvent>> afterMerge = new ArrayList<ChangeEvent<ExceptionEvent>>();
        for (Map.Entry<Type, List<ChangeEvent<ExceptionEvent>>> entry : groupsByIp.entrySet()) {
            List<ChangeEvent<ExceptionEvent>> eventsOfSameIp = entry.getValue();
            if (eventsOfSameIp.isEmpty()) continue;
            ChangeEvent<ExceptionEvent> first = eventsOfSameIp.get(0);
            eventsOfSameIp.remove(0);
            first.merge(eventsOfSameIp);
            afterMerge.add(first);
        }
        return afterMerge;
    }

    private List<ChangeEvent<ExceptionEvent>> updateTimeOutExceptionEvents() {
        ArrayList<ChangeEvent<ExceptionEvent>> changedEvents = new ArrayList<ChangeEvent<ExceptionEvent>>();
        Iterator<Map.Entry<Type, ExceptionEvent>> itor = this.exceptionRecords.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry<Type, ExceptionEvent> entry = itor.next();
            ExceptionEvent each = entry.getValue();
            if (!each.isTimeOut()) continue;
            List<OriginalExceptionEvent> endEvents = this.createEndOriginalEvent(each);
            Event changeEvent = each.sumElement((List)endEvents);
            ChangeEvent<Event> changed = new ChangeEvent<Event>(each, changeEvent);
            itor.remove();
            this.logger.info((Object)("exception is stop because timeout!" + LogManager.NEXT_LINE + each));
            changedEvents.add(changed);
        }
        return changedEvents;
    }
}

