/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.ContentTopnEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HourDnsEventHandler<E extends Event>
extends EventHandler<E, E> {
    private static final int COUNT = 12;
    private long previousTime;
    private Map<Type, E> cache = new HashMap<Type, E>();

    public HourDnsEventHandler() {
        this.initStartTime();
    }

    private void initStartTime() {
        this.refreshTime();
    }

    public synchronized void doHourTask() {
        ArrayList<E> sums = new ArrayList<E>();
        sums.addAll(this.cache.values());
        this.cache.clear();
        MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.clearHourEvent();
        this.refreshSumEvents(sums);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" sum event size is " + sums.size() + " content is " + LogManager.NEXT_LINE));
        }
        EventUtil.createEvents(sums);
        this.notifyFollowHandlers(sums);
    }

    private Map<Type, List<E>> groupEvents(List<E> events) {
        HashMap<Type, List<E>> map = new HashMap<Type, List<E>>();
        for (Event e : events) {
            BizType type = new BizType(e);
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(e);
            map.put(type, array);
        }
        return map;
    }

    @Override
    protected synchronized List<E> handelEvents(List<E> events) {
        if (!events.isEmpty()) {
            try {
                this.sumEvents(events);
            }
            catch (OutOfMemoryError error) {
                this.logger.error((Object)"out of memory ,then I clear the hour cache data");
            }
        }
        if (System.currentTimeMillis() - this.getPreviousTime() >= 3600000L) {
            this.doHourTask();
            this.refreshTime();
        }
        return new ArrayList();
    }

    private void mergeEvent(Map.Entry<? extends Type, List<E>> entry) {
        Type sameType = entry.getKey();
        List<E> sameTypeEvents = entry.getValue();
        if (!sameTypeEvents.isEmpty()) {
            if (this.cache.containsKey(sameType)) {
                Event temp = (Event)this.cache.get(sameType);
                temp.merge(sameTypeEvents);
            } else {
                Event temp = ((Event)sameTypeEvents.get(0)).getCopyEvent();
                temp.merge(sameTypeEvents);
                this.cache.put(sameType, temp);
                MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.add1hourEvent(temp);
            }
        }
    }

    protected void refreshSumEvents(List<E> sums) {
        for (Event e : sums) {
            e.setLogTime(this.getPreviousTime());
            e.average(12);
            e.setHourEvent(true);
            e.setMaxEvent(false);
        }
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.setPreviousTime(calendar.getTimeInMillis());
    }

    public void sumEvents(List<E> events) {
        this.logger.info((Object)new Date(System.currentTimeMillis()));
        if (this.logger.isDebugEnabled()) {
            for (Event each : events) {
                if (!(each instanceof ContentTopnEvent)) continue;
                this.logger.debug((Object)(" ------------after parse ,hour events are------------ " + each));
            }
        }
        Map<Type, List<E>> groups = this.groupEvents(events);
        for (Map.Entry<Type, List<E>> entry : groups.entrySet()) {
            this.mergeEvent(entry);
        }
    }

    public long getPreviousTime() {
        return this.previousTime;
    }

    private void setPreviousTime(long previousTime) {
        this.previousTime = previousTime;
    }
}

