/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.IPReputationEvent;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class IPReputationParserV1
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int IP_REPUTATION_EVENT = 17;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (17 == type) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parseEvent((UnsignedDataInputStream)stream, suitEvent);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stram error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parseEvent(UnsignedDataInputStream stream, IpSuitEvent event) throws IOException {
        IPReputationEvent ipReputationEvent = new IPReputationEvent(event.getIdentifier());
        ipReputationEvent.setReportTime(stream.readInt());
        ipReputationEvent.setSrcIpType((char)stream.readUnsignedByte());
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        stream.readUnsignedByte();
        byte[] srcIpByte = new byte[16];
        if (stream.available() >= 16) {
            if (stream.read(srcIpByte) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            String srcIpString = IpTransformer.byte2String(srcIpByte, 4);
            ipReputationEvent.setSrcIp(srcIpString);
        }
        ipReputationEvent.setZoneIpRptnEnableTime1(stream.readUnsignedLong());
        ipReputationEvent.setZoneIpRptnEnableTime2(stream.readUnsignedLong());
        ipReputationEvent.setAtkHitTime1(stream.readUnsignedLong());
        ipReputationEvent.setAtkHitTime2(stream.readUnsignedLong());
        ipReputationEvent.setAtkBlockTime1(stream.readUnsignedLong());
        ipReputationEvent.setAtkBlockTime2(stream.readUnsignedLong());
        ipReputationEvent.setPeaceHitTime1(stream.readUnsignedLong());
        ipReputationEvent.setPeaceHitTime2(stream.readUnsignedLong());
        ipReputationEvent.setAtkHitCount(stream.readInt());
        ipReputationEvent.setAtkBlockCount(stream.readInt());
        ipReputationEvent.setPeaceHitCount(stream.readInt());
        ipReputationEvent.setAtkSvcType1((char)stream.readUnsignedByte());
        ipReputationEvent.setAtkSvcType2((char)stream.readUnsignedByte());
        ipReputationEvent.setPeaceSvcType1((char)stream.readUnsignedByte());
        ipReputationEvent.setPeaceSvcType2((char)stream.readUnsignedByte());
        byte[] atkDestIp1Byte = new byte[16];
        if (stream.available() >= 16) {
            if (stream.read(atkDestIp1Byte) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            String atkDestIp1String = IpTransformer.byte2String(atkDestIp1Byte, 4);
            ipReputationEvent.setAtkDestIp1(atkDestIp1String);
        }
        byte[] atkDestIp2Byte = new byte[16];
        if (stream.available() >= 16) {
            if (stream.read(atkDestIp2Byte) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            String atkDestIp2String = IpTransformer.byte2String(atkDestIp2Byte, 4);
            ipReputationEvent.setAtkDestIp2(atkDestIp2String);
        }
        byte[] peaceDestIp1Byte = new byte[16];
        if (stream.available() >= 16) {
            if (stream.read(peaceDestIp1Byte) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            String peaceDestIp1Strig = IpTransformer.byte2String(peaceDestIp1Byte, 4);
            ipReputationEvent.setPeaceDestIp1(peaceDestIp1Strig);
        }
        byte[] peaceDestIp2Byte = new byte[16];
        if (stream.available() >= 16) {
            if (stream.read(peaceDestIp2Byte) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            String peaceDestIp2String = IpTransformer.byte2String(peaceDestIp2Byte, 4);
            ipReputationEvent.setPeaceDestIp2(peaceDestIp2String);
        }
        ipReputationEvent.setAtkType1(stream.readUnsignedLong());
        ipReputationEvent.setAtkType2(stream.readUnsignedLong());
        event.setIpReputationEvent(ipReputationEvent);
    }
}

