/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.entity.event.IPReputationEvent;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class IPReputationThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    protected ReentrantLock lock = new ReentrantLock();
    protected int fileRollBackCount = 100;
    protected int fileMaxLineCount = 10000;
    private List<IPReputationEvent> ipReputationList = new ArrayList<IPReputationEvent>();
    private static final String IPREPURU_FILE_HEAD = "ipReputation_";
    private static final String IPREPURU_FILE_TAIL = ".log";
    private static final String IPREPURU_FILE_PATH = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "ipReputation";
    private static final String DEFAULT_IPREPURU_FILE = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "ipReputation" + File.separator + "ipReputation_" + "1" + ".log";

    @Override
    public void run() {
        LOGGER.info((Object)"IPReputationThread: start");
        List<IPReputationEvent> ipReputationListTemp = null;
        this.createIPReputationDirectory();
        while (true) {
            if (!this.ipReputationList.isEmpty()) {
                this.lock.lock();
                try {
                    ipReputationListTemp = this.ipReputationList;
                    this.ipReputationList = new ArrayList<IPReputationEvent>();
                }
                finally {
                    this.lock.unlock();
                }
                this.createIPReputationFileAndWrite(ipReputationListTemp);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"sleep error");
                continue;
            }
            break;
        }
    }

    public void addIPReputation(List<IPReputationEvent> ipReputationListParam) {
        this.lock.lock();
        try {
            this.ipReputationList.addAll(ipReputationListParam);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void createIPReputationDirectory() {
        try {
            File file = new File(IPREPURU_FILE_PATH);
            if (!file.exists() && !file.mkdir()) {
                LOGGER.error((Object)"when IPReputation directory,fail.");
            }
        }
        catch (SecurityException e) {
            LOGGER.error((Object)("when IPReputation directory,fail." + e.getMessage()));
        }
        catch (RuntimeException e1) {
            LOGGER.error((Object)("when IPReputation directory,runtime Exception." + e1.getMessage()));
        }
    }

    private void createIPReputationFileAndWrite(List<IPReputationEvent> events) {
        try {
            int i = 0;
            String[] lines = new String[events.size()];
            for (IPReputationEvent each : events) {
                lines[i] = this.getEventLineString(each) + LogManager.NEXT_LINE;
                ++i;
            }
            LOGGER.debug((Object)("IPReputationEvent line num=" + i));
            this.writeIPReputationLinesToFile(lines);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Wirte IPReputationEvent Error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIPReputationFileLineNum() {
        int lineNumber = 0;
        String filePath = DEFAULT_IPREPURU_FILE;
        InputStreamReader reader = null;
        BufferedReader lineNumberReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            reader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            lineNumberReader = new LineNumberReader(reader);
            long oldLineNum = ((LineNumberReader)lineNumberReader).skip(Long.MAX_VALUE);
            lineNumber = oldLineNum < 0L ? 0 : ((LineNumberReader)lineNumberReader).getLineNumber() + 1;
        }
        catch (FileNotFoundException e) {
            lineNumber = -1;
            LOGGER.error((Object)("file.getFileLineNum() e" + e));
        }
        catch (IOException e) {
            lineNumber = -1;
            LOGGER.error((Object)("file.getFileLineNum() e" + e));
        }
        finally {
            try {
                if (lineNumberReader != null) {
                    lineNumberReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"reader.close() IOException", (Throwable)e);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"reader.close() IOException", (Throwable)e);
            }
        }
        return lineNumber;
    }

    private OutputStreamWriter getIPReputationFileOutStream() {
        OutputStreamWriter fileOut = null;
        try {
            String filePath = DEFAULT_IPREPURU_FILE;
            File file = new File(filePath);
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    LOGGER.error((Object)"create new file error");
                    return null;
                }
                LOGGER.debug((Object)"file.createNewFile()");
            }
            fileOut = new OutputStreamWriter((OutputStream)new FileOutputStream(DEFAULT_IPREPURU_FILE, true), "UTF-8");
        }
        catch (IOException e) {
            LOGGER.error((Object)("write to srcTopnEvents IOException." + e.getMessage()));
        }
        return fileOut;
    }

    private void closeIPReputationFileOutStream(OutputStreamWriter fileOut) {
        try {
            if (fileOut != null) {
                fileOut.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"closeIPReputationFileOutStream.close() IOException", (Throwable)e);
        }
    }

    private String getRollingFileName(int i) {
        return AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "ipReputation" + File.separator + IPREPURU_FILE_HEAD + i + IPREPURU_FILE_TAIL;
    }

    private void rollbackIPReputationFile() {
        try {
            for (int i = this.fileRollBackCount; i > 1; --i) {
                String oldFileString;
                File oldFile;
                String newFileString = this.getRollingFileName(i);
                File newFile = new File(newFileString);
                if (newFile.exists()) {
                    if (newFile.delete()) {
                        LOGGER.info((Object)("rollbackIPReputationFile delete file success " + newFile.getName()));
                    } else {
                        LOGGER.error((Object)("rollbackIPReputationFile delete file failed " + newFile.getName()));
                    }
                }
                if (!(oldFile = new File(oldFileString = this.getRollingFileName(i - 1))).exists()) continue;
                if (oldFile.renameTo(newFile)) {
                    LOGGER.info((Object)("rollbackIPReputationFile renameTo file success " + newFile.getName()));
                    continue;
                }
                LOGGER.error((Object)("rollbackIPReputationFile renameTo file failed " + oldFile.getName()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"closeIPReputationFileOutStream.close() IOException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIPReputationLinesToFile(String[] lines) {
        OutputStreamWriter fileOut = this.getIPReputationFileOutStream();
        try {
            int fileLastLine = IPReputationThread.getIPReputationFileLineNum();
            if (fileLastLine < 0) {
                LOGGER.error((Object)"writeIPReputationLinesToFile fileLastLine < 0");
                return;
            }
            int currentLine = fileLastLine;
            for (int i = 0; i < lines.length; ++i) {
                if (++currentLine > this.fileMaxLineCount) {
                    this.closeIPReputationFileOutStream(fileOut);
                    this.rollbackIPReputationFile();
                    fileOut = this.getIPReputationFileOutStream();
                    currentLine = 0;
                }
                fileOut.append(lines[i]);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("write to srcTopnEvents IOException." + e.getMessage()));
        }
        finally {
            this.closeIPReputationFileOutStream(fileOut);
        }
    }

    private String getEventLineString(IPReputationEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getLogTime() / 1000L);
        buffer.append(";");
        buffer.append(event.getDeviceIp());
        buffer.append(";");
        buffer.append(event.getDeviceType());
        buffer.append(";");
        buffer.append(event.getSrcIp());
        buffer.append(";");
        buffer.append(event.getReportTime());
        buffer.append(";");
        buffer.append(event.getSrcIpType());
        buffer.append(";");
        buffer.append(event.getSrcIp());
        buffer.append(";");
        buffer.append(event.getZoneIpRptnEnableTime1());
        buffer.append(";");
        buffer.append(event.getZoneIpRptnEnableTime2());
        buffer.append(";");
        buffer.append(event.getAtkHitTime1());
        buffer.append(";");
        buffer.append(event.getAtkHitTime2());
        buffer.append(";");
        buffer.append(event.getAtkBlockTime1());
        buffer.append(";");
        buffer.append(event.getAtkBlockTime2());
        buffer.append(";");
        buffer.append(event.getPeaceHitTime1());
        buffer.append(";");
        buffer.append(event.getPeaceHitTime2());
        buffer.append(";");
        buffer.append(event.getAtkHitCount());
        buffer.append(";");
        buffer.append(event.getAtkBlockCount());
        buffer.append(";");
        buffer.append(event.getPeaceHitCount());
        buffer.append(";");
        buffer.append(event.getAtkSvcType1());
        buffer.append(";");
        buffer.append(event.getAtkSvcType2());
        buffer.append(";");
        buffer.append(event.getPeaceSvcType1());
        buffer.append(";");
        buffer.append(event.getPeaceSvcType2());
        buffer.append(";");
        buffer.append(event.getAtkDestIp1());
        buffer.append(";");
        buffer.append(event.getAtkDestIp2());
        buffer.append(";");
        buffer.append(event.getPeaceDestIp1());
        buffer.append(";");
        buffer.append(event.getPeaceDestIp2());
        buffer.append(";");
        buffer.append(event.getAtkType1());
        buffer.append(";");
        buffer.append(event.getAtkType2());
        buffer.append(";");
        return buffer.toString();
    }
}

