/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process.IntelligentDefense;

import com.hs.atic.collector.biz.event.process.IntelligentDefense.IntelligentDefenseThread;
import com.hs.atic.collector.entity.event.IntelligentDefenseEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.intelligentdefense.entity.LogicOperator;
import com.hs.atic.intelligentdefense.entity.Operator;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleConditionRelationship;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleDetail;
import com.hs.atic.rmi.ConditionEvaluationResult;
import com.hs.atic.rmi.StreamMonitorAlarmInfo;
import com.hs.atic.rmi.StreamMonitorRuleManagementService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IntelligentDefenseRuleManage {
    private static final IntelligentDefenseRuleManage INSTANCE = new IntelligentDefenseRuleManage();
    private static final Logger LOGGER = LogManager.getInstance().getAttackLog();
    private static final String STREAM_MONITOR_RULEMANAGEMENT_SERVICE = "StreamMonitorRuleManagementService";
    private static final String EVENT_ATTACK_TYPE = "attackTypeSet";
    private static final String EVENT_BLACK_TYPE = "blackTypeSet";
    private static final String TARGET_VALUE_NOT_EXIST = "notExist";
    private static final String CHECK_EVENT_NUM = EventUtil.getEventConfigProperty("checkEventNum");
    private static final int DEFAULT_CHECK_EVENT_NUM = 3;
    private static final float PCENTAGE = 0.01f;
    private static final String UDP_FALSE_NEGATIVE_RULE_NAME = "UDP False Negative Check";
    private static final String ATCKTYPE_UDPLIMIT = "22";
    private static Map<Integer, StreamMonitorRuleDetail> initializedRules = new ConcurrentHashMap<Integer, StreamMonitorRuleDetail>();
    private static Map<Integer, ConditionEvaluationResult> currentConditionResults = new ConcurrentHashMap<Integer, ConditionEvaluationResult>();
    private static Map<String, String> measureThresholds = new HashMap<String, String>();
    private Set<Long> zoneIdSet = new HashSet<Long>();
    private StreamMonitorRuleManagementService ruleManagementService = null;

    private IntelligentDefenseRuleManage() {
    }

    public static IntelligentDefenseRuleManage getInstance() {
        return INSTANCE;
    }

    public List<StreamMonitorRuleDetail> loadRules() throws RemoteException {
        this.ruleManagementService = (StreamMonitorRuleManagementService)CommonUtil.retreiveAticRmiService(STREAM_MONITOR_RULEMANAGEMENT_SERVICE);
        List<StreamMonitorRuleDetail> details = this.ruleManagementService.loadRules();
        return details;
    }

    public boolean initialzieRules() throws RemoteException {
        List<StreamMonitorRuleDetail> ruleDetails = this.loadRules();
        for (StreamMonitorRuleDetail ruleDetail : ruleDetails) {
            initializedRules.put(ruleDetail.getRuleId(), ruleDetail);
        }
        if (!initializedRules.isEmpty()) {
            LOGGER.info((Object)("get all rules sucess, rules.size=" + initializedRules.size()));
            this.resetZoneIdSet();
            IntelligentDefenseThread.getInstance().start();
            IntelligentDefenseThread.getInstance().setStart(true);
        } else {
            LOGGER.info((Object)"get all rules return empty.");
        }
        return true;
    }

    public static List<StreamMonitorAlarmInfo> evaluate(List<IntelligentDefenseEvent> currentEvents) throws NoSuchElementException {
        ArrayList<StreamMonitorAlarmInfo> results = new ArrayList<StreamMonitorAlarmInfo>();
        IntelligentDefenseRuleManage.refreshConditionResults(currentEvents);
        for (StreamMonitorRuleDetail rule : initializedRules.values()) {
            boolean ruleResult = IntelligentDefenseRuleManage.evaluateRule(rule, currentEvents);
            if (!ruleResult) continue;
            StreamMonitorAlarmInfo alarmInfo = new StreamMonitorAlarmInfo();
            alarmInfo.setZoneId(currentEvents.get(0).getZoneId());
            alarmInfo.setDeviceIp(currentEvents.get(0).getDeviceIp());
            alarmInfo.setDefendIp(currentEvents.get(0).getZoneIp());
            alarmInfo.setDeviceName(currentEvents.get(0).getDeviceTypeName());
            alarmInfo.setRuleName(rule.getRuleName());
            Integer alarmType = rule.getConditionRelationships().get(0).getType();
            alarmInfo.setAlarmType(alarmType);
            ArrayList conditionResults = new ArrayList();
            rule.getConditionRelationships().stream().map(r -> r.getConditionId()).forEach(c -> conditionResults.add(currentConditionResults.get(c)));
            List<ConditionEvaluationResult> trueConditionResults = conditionResults.stream().filter(c -> c.isMatched()).collect(Collectors.toList());
            alarmInfo.setConEvaluationResult(trueConditionResults);
            results.add(alarmInfo);
        }
        return results;
    }

    public static boolean evaluateRule(StreamMonitorRuleDetail ruleDetail, List<IntelligentDefenseEvent> currentEvents) {
        boolean result = false;
        if (ruleDetail == null || currentEvents == null || currentEvents.isEmpty()) {
            return result;
        }
        int tempGroupId = -1;
        int firstGroupId = 0;
        LogicOperator firstItemLogicOperator = null;
        List<StreamMonitorRuleConditionRelationship> relationships = ruleDetail.getConditionRelationships();
        if (ruleDetail.getZoneIds() != null && ruleDetail.getZoneIds().contains(currentEvents.get(0).getZoneId())) {
            for (StreamMonitorRuleConditionRelationship relationship : relationships) {
                if (tempGroupId == relationship.getGroupId()) continue;
                tempGroupId = relationship.getGroupId();
                List tempGroupItems = relationships.stream().filter(g -> g.getGroupId().equals(relationship.getGroupId())).collect(Collectors.toList());
                boolean tempGroupResult = false;
                if (tempGroupItems != null && tempGroupItems.size() > 1) {
                    StreamMonitorRuleConditionRelationship firstItem = (StreamMonitorRuleConditionRelationship)tempGroupItems.get(0);
                    int firstItemIndex = firstItem.getConditionId();
                    firstItemLogicOperator = firstItem.getLogicOperator();
                    tempGroupResult = currentConditionResults.get(firstItemIndex) != null ? currentConditionResults.get(firstItemIndex).isMatched() : false;
                    for (int i = 1; i < tempGroupItems.size(); ++i) {
                        StreamMonitorRuleConditionRelationship tempItem = (StreamMonitorRuleConditionRelationship)tempGroupItems.get(i);
                        int index = tempItem.getConditionId();
                        boolean tempItemResult = false;
                        if (currentConditionResults.get(index) != null) {
                            tempItemResult = currentConditionResults.get(index).isMatched();
                        }
                        LogicOperator tempOperator = tempItem.getLogicOperator();
                        tempGroupResult = IntelligentDefenseRuleManage.join(tempGroupResult, tempItemResult, tempOperator);
                    }
                } else if (tempGroupItems != null && tempGroupItems.size() == 1) {
                    int index = relationship.getConditionId();
                    tempGroupResult = currentConditionResults.get(index) != null ? currentConditionResults.get(index).isMatched() : false;
                    firstItemLogicOperator = relationship.getLogicOperator();
                }
                result = firstGroupId == 0 ? tempGroupResult : IntelligentDefenseRuleManage.join(result, tempGroupResult, firstItemLogicOperator);
                ++firstGroupId;
            }
        }
        if (ruleDetail.getRuleName().equals(UDP_FALSE_NEGATIVE_RULE_NAME)) {
            result = result && IntelligentDefenseRuleManage.isNotUdpSpeedLimitAttackConfig(ruleDetail, currentEvents);
        }
        return result;
    }

    private static boolean isNotUdpSpeedLimitAttackConfig(StreamMonitorRuleDetail ruleDetail, List<IntelligentDefenseEvent> currentEvents) {
        String secondValueString;
        String[] curAtakBlackType;
        List<String> curAtakBlackTypeList;
        boolean isNotSpeedLimitAttack = false;
        Map<String, List<String>> currentValues = IntelligentDefenseRuleManage.initializeCurrentEvents(currentEvents);
        List<String> currentMeasureValues = currentValues.get(EVENT_ATTACK_TYPE);
        if (currentMeasureValues != null && !(curAtakBlackTypeList = Arrays.asList(curAtakBlackType = (secondValueString = currentMeasureValues.get(1)).split(","))).contains(ATCKTYPE_UDPLIMIT)) {
            isNotSpeedLimitAttack = true;
        }
        return isNotSpeedLimitAttack;
    }

    private static boolean join(boolean leftItem, boolean rightItem, LogicOperator logicOperator) {
        boolean result = false;
        switch (logicOperator) {
            case AND: {
                result = leftItem && rightItem;
                break;
            }
            case OR: {
                result = leftItem || rightItem;
            }
        }
        return result;
    }

    public static List<StreamMonitorAlarmInfo> applyRules(List<IntelligentDefenseEvent> currentEvents) {
        List<StreamMonitorAlarmInfo> alarmInfoList = IntelligentDefenseRuleManage.evaluate(currentEvents);
        return alarmInfoList;
    }

    public static Map<String, List<String>> initializeCurrentEvents(List<IntelligentDefenseEvent> currentEvents) {
        HashMap<String, List<String>> currentValues = new HashMap<String, List<String>>();
        for (IntelligentDefenseEvent event : currentEvents) {
            Map<String, String> item = event.eventsToCheck();
            for (Map.Entry<String, String> entry : item.entrySet()) {
                if (currentValues.keySet().contains(entry.getKey())) {
                    ((List)currentValues.get(entry.getKey())).add(entry.getValue());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(entry.getValue());
                currentValues.put(entry.getKey(), values);
            }
        }
        return currentValues;
    }

    public static void refreshConditionResults(List<IntelligentDefenseEvent> currentEvents) {
        Map<String, List<String>> currentValues = IntelligentDefenseRuleManage.initializeCurrentEvents(currentEvents);
        initializedRules.values().stream().flatMap(d -> d.getConditionRelationships().stream()).forEach(r -> {
            ConditionEvaluationResult result = IntelligentDefenseRuleManage.evaluateCondition(r, currentValues);
            currentConditionResults.put(r.getConditionId(), result);
        });
    }

    public static ConditionEvaluationResult evaluateCondition(StreamMonitorRuleConditionRelationship relationship, Map<String, List<String>> currentValues) {
        ConditionEvaluationResult result = new ConditionEvaluationResult();
        boolean matched = false;
        if (currentValues != null && relationship != null) {
            String measureName = relationship.getMeasureName();
            Operator operator = relationship.getOperator();
            String targetValue = relationship.getTargetValue();
            if (measureName.contains(EVENT_ATTACK_TYPE) || measureName.contains(EVENT_BLACK_TYPE)) {
                String[] measureNameList = measureName.split("_");
                if (measureNameList.length > 1) {
                    measureName = measureNameList[0];
                    List<String> attackValues = Arrays.asList(Arrays.copyOfRange(measureNameList, 1, measureNameList.length));
                    targetValue = String.join((CharSequence)",", attackValues);
                } else {
                    LOGGER.error((Object)String.format("measure name %s is not in correct format", measureName));
                    targetValue = TARGET_VALUE_NOT_EXIST;
                    result.setConditionId(relationship.getConditionId());
                    result.setMeasure(relationship.getMeasureName());
                    result.setTargetValue(targetValue);
                    result.setMatched(matched);
                    return result;
                }
            }
            List<String> currentMeasureValues = currentValues.get(measureName);
            int countElementsToCheck = -1;
            countElementsToCheck = CHECK_EVENT_NUM != null ? Integer.parseInt(CHECK_EVENT_NUM) : 3;
            if (currentMeasureValues != null && currentMeasureValues.size() == countElementsToCheck) {
                Long thirdValue;
                String secondValueString = currentMeasureValues.get(1);
                if (measureName.contains(EVENT_ATTACK_TYPE) || measureName.contains(EVENT_BLACK_TYPE)) {
                    String[] curAtakBlackType = secondValueString.split(",");
                    ArrayList<String> curAtakBlackTypeList = new ArrayList<String>(Arrays.asList(curAtakBlackType));
                    if (targetValue.contains(",")) {
                        curAtakBlackTypeList.retainAll(Arrays.asList(targetValue.split(",")));
                    } else {
                        curAtakBlackTypeList.retainAll(Collections.singletonList(targetValue));
                    }
                    matched = curAtakBlackTypeList.size() > 0;
                    result.setMeasure(relationship.getMeasureName());
                    result.setTargetValue(targetValue);
                    result.setCurrentValue(secondValueString);
                    result.setConditionId(relationship.getConditionId());
                    result.setMatched(matched);
                    return result;
                }
                String measureThresholdKey = relationship.getType() + "." + relationship.getMeasureName();
                String measureThresholdValue = measureThresholds.get(measureThresholdKey);
                Long threasholdValue = 0L;
                if (!StringUtils.isEmpty((String)measureThresholdValue)) {
                    threasholdValue = Long.parseLong(measureThresholdValue);
                }
                thirdValue = (thirdValue = Long.valueOf(Long.parseLong(currentMeasureValues.get(2)))) == 0L ? 1L : Long.parseLong(currentMeasureValues.get(2));
                Long secondValue = Long.parseLong(currentMeasureValues.get(1));
                secondValue = secondValue == 0L ? 1L : Long.parseLong(currentMeasureValues.get(1));
                Long firstValue = Long.parseLong(currentMeasureValues.get(0));
                firstValue = firstValue == 0L ? 1L : Long.parseLong(currentMeasureValues.get(0));
                Long trgtValue = 0L;
                if (targetValue.matches("^[0-9]+$")) {
                    int percentile = Integer.parseInt(targetValue);
                    float tempTrgtValue = 0.0f;
                    if (relationship.getType() == 0) {
                        boolean bl = matched = secondValue > threasholdValue;
                    }
                    if (relationship.getType() == 1) {
                        matched = firstValue > threasholdValue;
                    }
                    switch (operator) {
                        case GreaterEqualThan: {
                            tempTrgtValue = (float)firstValue.longValue() * (1.0f + (float)percentile * 0.01f);
                            trgtValue = (long)tempTrgtValue;
                            matched = matched && secondValue >= trgtValue && thirdValue >= trgtValue;
                            break;
                        }
                        case LessEqualThan: {
                            tempTrgtValue = (float)firstValue.longValue() * (1.0f - (float)percentile * 0.01f);
                            trgtValue = (long)tempTrgtValue;
                            matched = matched && secondValue <= trgtValue && thirdValue <= trgtValue;
                            break;
                        }
                    }
                } else {
                    LOGGER.error((Object)String.format("target value %s doesn't in correct format", trgtValue));
                    result.setConditionId(relationship.getConditionId());
                    result.setMeasure(relationship.getMeasureName());
                    result.setTargetValue(targetValue);
                    result.setCurrentValue(secondValueString);
                    result.setMatched(matched);
                    return result;
                }
                result.setTargetValue(String.valueOf(trgtValue));
                result.setCurrentValue(String.valueOf(secondValue));
            } else {
                LOGGER.error((Object)String.format("cannot find the measure %s defined in relationship from current events", measureName));
            }
            result.setConditionId(relationship.getConditionId());
            result.setMeasure(relationship.getMeasureName());
        }
        result.setMatched(matched);
        return result;
    }

    public synchronized void addRule(StreamMonitorRuleDetail rule) {
        if (null == rule) {
            return;
        }
        initializedRules.put(rule.getRuleId(), rule);
        this.zoneIdSet.addAll(rule.getZoneIds());
        if (!IntelligentDefenseThread.getInstance().isStart()) {
            IntelligentDefenseThread.getInstance().start();
            IntelligentDefenseThread.getInstance().setStart(true);
        }
        LOGGER.info((Object)("addRule:" + rule.toString()));
    }

    public synchronized void removeRule(List<Integer> ruleIds) {
        if (null == ruleIds || ruleIds.isEmpty()) {
            LOGGER.error((Object)"input ruleIds is empty");
            return;
        }
        for (Integer ruleId : ruleIds) {
            initializedRules.remove(ruleId);
        }
        this.resetZoneIdSet();
        LOGGER.info((Object)("removeRule:" + ruleIds.toString()));
    }

    public synchronized void updateRule(StreamMonitorRuleDetail rule) {
        if (null == rule) {
            return;
        }
        initializedRules.put(rule.getRuleId(), rule);
        this.resetZoneIdSet();
        LOGGER.info((Object)("updateRule:" + rule.toString()));
    }

    private synchronized void resetZoneIdSet() {
        this.zoneIdSet.clear();
        for (Map.Entry<Integer, StreamMonitorRuleDetail> entry : initializedRules.entrySet()) {
            StreamMonitorRuleDetail rule = entry.getValue();
            this.zoneIdSet.addAll(rule.getZoneIds());
        }
    }

    public boolean isHaveRules() {
        return !initializedRules.isEmpty();
    }

    public synchronized boolean isCheckZoneId(Long zoneId) {
        return this.zoneIdSet.contains(zoneId);
    }

    public static Map<String, String> getMeasureThreshold() {
        return measureThresholds;
    }
}

