/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.SumCycEvent;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AttackTypeEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IpAttackTypeOriginalHandler
extends EventHandler<OriginalExceptionEvent, AttackTypeEvent> {
    private static final long CYC = 64L;
    private long lastTime;
    private final int period;
    private long lastCycTime;
    private Map<Type, SumCycEvent<AttackTypeEvent>> ipEventMaps = new HashMap<Type, SumCycEvent<AttackTypeEvent>>();

    public IpAttackTypeOriginalHandler(int period) {
        this.period = period;
        this.refreshLastTime();
        super.setLogger(LogManager.getInstance().getAttackLog());
        this.lastCycTime = System.currentTimeMillis() / 1000L;
    }

    protected boolean isTimeToSumOnCyc() {
        return System.currentTimeMillis() / 1000L - this.lastCycTime >= 64L;
    }

    protected void sumOnOneCyc() {
        for (Map.Entry<Type, SumCycEvent<AttackTypeEvent>> entry : this.ipEventMaps.entrySet()) {
            entry.getValue().sumOnOneCyc();
        }
    }

    @Override
    public void handel(List<OriginalExceptionEvent> events) {
        try {
            if (this.isTimeToSumOnCyc()) {
                this.lastCycTime = System.currentTimeMillis() / 1000L;
                this.sumOnOneCyc();
            }
            if (this.isTimeToMerge()) {
                ArrayList<AttackTypeEvent> list = new ArrayList<AttackTypeEvent>();
                ArrayList<Type> remove = new ArrayList<Type>();
                for (Map.Entry<Type, SumCycEvent<AttackTypeEvent>> entry : this.ipEventMaps.entrySet()) {
                    AttackTypeEvent t = entry.getValue().getInEvent();
                    if (null != t && t.isValid()) {
                        t.getIdentifier().setZoneIpType();
                        list.add(t);
                    }
                    entry.getValue().reset();
                    if (!entry.getValue().isCanDestroy()) continue;
                    remove.add(entry.getKey());
                }
                for (Type type : remove) {
                    this.ipEventMaps.remove(type);
                }
                this.refreshLogTime(list);
                this.refreshLastTime();
                EventUtil.createEvents(list);
                this.notifyFollowHandlers(list);
            }
            this.handelEvents(events);
        }
        catch (OutOfMemoryError error) {
            this.ipEventMaps.clear();
            this.logger.error((Object)"out of memory ,then I clear the  data");
        }
    }

    @Override
    protected List<AttackTypeEvent> handelEvents(List<OriginalExceptionEvent> events) {
        for (OriginalExceptionEvent event : events) {
            AttackTypeEvent e = new AttackTypeEvent(event.getIdentifierCopy(), event.getAttackType());
            e.setDropPackets(event.getDropPkgs());
            e.setDropBytes(event.getDropKbits());
            e.setDropPps(event.getAttackPeakPpsOrQps());
            e.setDropKbps(event.getAttackPeakKbps());
            e.setIpAttackPeakKbps(event.getIpAttackPeakKbps());
            e.setIpAttackPeakPps(event.getIpAttackPeakPps());
            e.setIpInPeakKbps(event.getIpInPeakKbps());
            e.setIpInPeakPps(event.getIpInPeakPps());
            e.setTcpCurConnNum(event.getTcpCurConnNum());
            e.setTcpNewConnNum(event.getTcpNewConnNum());
            e.setPortData(event.getPortData());
            e.setPorts(event.getPorts());
            IpType type = new IpType((Type)e.getAttackType(), e.getIdentifier(), false);
            if (this.ipEventMaps.containsKey(type)) {
                this.ipEventMaps.get(type).addEvent(e);
                continue;
            }
            this.ipEventMaps.put(type, new SumCycEvent<AttackTypeEvent>(e));
        }
        return new ArrayList<AttackTypeEvent>();
    }

    public Map<Type, SumCycEvent<AttackTypeEvent>> getIpEventMaps() {
        return this.ipEventMaps;
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    private void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(this.period);
    }

    private void refreshLogTime(List<AttackTypeEvent> eventsAfterMergeByIp) {
        for (AttackTypeEvent event : eventsAfterMergeByIp) {
            event.setLogTime(this.lastTime);
        }
    }
}

