/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class IpFlowEventHandler<T extends Event>
extends EventHandler<T, T> {
    public IpFlowEventHandler() {
        super.setLogger(LogManager.getInstance().getFlowLog());
    }

    public List<T> mergeByMultiCpu(List<T> list) {
        Map<Type, List<T>> groupsByIp = EventUtil.groupEventsByZoneIpAndBizIdIgnoreZoneId(list);
        ArrayList<Event> merge = new ArrayList<Event>();
        for (Map.Entry<Type, List<T>> entry : groupsByIp.entrySet()) {
            List<T> each = entry.getValue();
            if (each.isEmpty()) continue;
            Collections.sort(each, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    long anotherVal;
                    long thisVal = ((Event)o1).getLogTime();
                    return thisVal > (anotherVal = ((Event)o2).getLogTime()) ? -1 : (thisVal == anotherVal ? 0 : 1);
                }
            });
            Event first = (Event)each.get(0);
            Event copy = first.getCopyEvent();
            EventIdentifier identifier = copy.getIdentifierCopy();
            if (!identifier.isZoneEvent()) {
                identifier.setZoneIpType();
            }
            copy.setIdentifer(identifier);
            copy.merge(each);
            if (!copy.isValid()) continue;
            merge.add(copy);
        }
        return merge;
    }
}

