/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.conn.ConnectionRmiThread;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.NotifyCaptureTaskFinshedService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class NotifyPcapTaskFinishedHanlder
extends Thread {
    private static NotifyPcapTaskFinishedHanlder handler = new NotifyPcapTaskFinishedHanlder();
    private static final String SERVICE_NAME = "notifyCaptureTaskFinshedService";
    private static final long SLEEP_TIME = 10000L;
    private Logger logger;
    private NotifyCaptureTaskFinshedService listener;
    private List<Long> pcapTaskStates = new ArrayList<Long>();

    private NotifyPcapTaskFinishedHanlder() {
        this.logger = LogManager.getInstance().getPcapLogger();
    }

    public static NotifyPcapTaskFinishedHanlder getInstance() {
        return handler;
    }

    public synchronized void refreshNotifyList(long pcapTaskId) {
        this.pcapTaskStates.add(pcapTaskId);
    }

    @Override
    public void run() {
        while (true) {
            if (null == this.listener && ConnectionRmiThread.getInstance().getRmiConnection().booleanValue()) {
                this.listener = (NotifyCaptureTaskFinshedService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
            }
            try {
                if (null != this.listener) {
                    this.notifyCaptureTaskOver();
                } else {
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("when notify capture task over ,error happend!" + e.getMessage()));
                this.listener = null;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("when sleep ,interrupted by unknow reason!" + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private synchronized void notifyCaptureTaskOver() {
        if (this.pcapTaskStates.isEmpty()) {
            return;
        }
        Iterator<Long> itor = this.pcapTaskStates.iterator();
        while (itor.hasNext()) {
            long pcapTaskId = itor.next();
            this.logger.info((Object)("Capture task is finished !" + this.pcapTaskStates + " listener is " + this.listener));
            try {
                this.listener.notifyCaptureTaskFinshed(pcapTaskId);
            }
            catch (RemoteException e) {
                this.logger.error((Object)("listener.notifyCaptureTaskFinshed() RemoteException, pcapTaskId:" + pcapTaskId + ". " + e.getMessage()));
            }
            itor.remove();
            this.logger.info((Object)("Notify capture task over success!Task id is" + pcapTaskId));
        }
    }
}

