/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Buffer;
import com.hs.atic.collector.biz.Consumer;
import com.hs.atic.collector.biz.PacketParser;
import com.hs.atic.collector.biz.SortBuffer;
import com.hs.atic.collector.biz.event.process.GeneratePacketsKey;
import com.hs.atic.collector.biz.event.process.TimeDatagramPacket;
import com.hs.atic.collector.entity.event.BizEvent;
import com.hs.atic.collector.entity.event.ContentTopnEvent;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.entity.event.DnsStatisEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.IPReputationEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.entity.event.SecondFlowEvent;
import com.hs.atic.collector.entity.event.SrcTopnEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.Collection;
import java.util.List;

public class ParseConsumer
extends Consumer<TimeDatagramPacket> {
    private Buffer<Event> flowBuff;
    private SortBuffer<OriginalExceptionEvent> sortExceptionBuffer;
    private SortBuffer<ZoneBlackListEvent> sortBlackIpBuffer;
    private List<SortBuffer<OriginalExceptionEvent>> exceptionBufferSortList;
    private List<SortBuffer<ZoneBlackListEvent>> blackIpBufferSortList;
    private Buffer<BizEvent> bizEventBuffer;
    private Buffer<Event> dnsEventBuffer;
    private Buffer<DnsDefendEvent> dnsDefendEventBuffer;
    private Buffer<SecondFlowEvent> secondFlowBuffer;
    private Buffer<IPReputationEvent> ipReputationFlowBuffer;
    private PacketParser<Event> packetParser;
    private int wildIpLimit = 1000;
    private int zoneIpLimit = 4000;
    private int wildIpSize = 0;
    private int zoneIpSize = 0;
    private int dropWildIpSize = 0;
    private int dropZoneIpSize = 0;
    private long timeOutPeroid = 300000L;
    private GeneratePacketsKey generatePacketsKey;
    private GeneratePacketsKey generateBlacksKey;

    public ParseConsumer(PacketParser<Event> packetParser) {
        this.logger = LogManager.getInstance().getReceiveLog();
        this.packetParser = packetParser;
        try {
            this.zoneIpLimit = Integer.parseInt(EventUtil.getEventConfigProperty("MostZoneIpSize"));
            this.wildIpLimit = Integer.parseInt(EventUtil.getEventConfigProperty("MostWildIpSize"));
            this.timeOutPeroid = Long.parseLong(EventUtil.getEventConfigProperty("TimeOutLength"));
        }
        catch (Exception e) {
            this.logger.warn((Object)("read config value fail!" + e.getMessage()));
        }
    }

    private void addEvents(Collection<Event> all, boolean wildInBound, boolean zoneInBound) {
        for (Event event : all) {
            if (event instanceof OriginalExceptionEvent) {
                this.sortExceptionBuffer.addPacket((OriginalExceptionEvent)event);
                this.logger.info((Object)"event instanceof OriginalExceptionEvent");
                continue;
            }
            if (event instanceof ZoneBlackListEvent) {
                this.sortBlackIpBuffer.addPacket((ZoneBlackListEvent)event);
                continue;
            }
            if (event instanceof BizEvent) {
                this.bizEventBuffer.addPacket((BizEvent)event);
                continue;
            }
            if (event instanceof DnsStatisEvent) {
                this.dnsEventBuffer.addPacket((DnsStatisEvent)event);
                continue;
            }
            if (event instanceof SrcTopnEvent) {
                this.dnsEventBuffer.addPacket((SrcTopnEvent)event);
                continue;
            }
            if (event instanceof ContentTopnEvent) {
                this.dnsEventBuffer.addPacket((ContentTopnEvent)event);
                continue;
            }
            if (event instanceof DnsDefendEvent) {
                this.dnsDefendEventBuffer.addPacket((DnsDefendEvent)event);
                continue;
            }
            if (event instanceof SecondFlowEvent) {
                this.secondFlowBuffer.addPacket((SecondFlowEvent)event);
                continue;
            }
            if (event instanceof IPReputationEvent) {
                this.ipReputationFlowBuffer.addPacket((IPReputationEvent)event);
                continue;
            }
            if (event == null) continue;
            if (event.isDefaultZone()) {
                if (wildInBound) {
                    ++this.wildIpSize;
                    this.flowBuff.addPacket(event);
                    if (!event.isDeviceEvent()) continue;
                    this.logger.warn((Object)("addEvent isDeviceEvent maxType = " + event.isIsMaxEvent() + " dropType = " + event.isIsDropFlow() + event.toString()));
                    continue;
                }
                ++this.dropWildIpSize;
                this.logger.error((Object)("drop a flow packet for wildInBound, dropWildIpSize=" + this.dropWildIpSize));
                if (!event.isDeviceEvent()) continue;
                this.logger.warn((Object)("addEvent isDeviceEvent maxType = " + event.isIsMaxEvent() + " dropType = " + event.isIsDropFlow() + event.toString()));
                continue;
            }
            if (zoneInBound) {
                ++this.zoneIpSize;
                this.flowBuff.addPacket(event);
                if (!event.isDeviceEvent()) continue;
                this.logger.warn((Object)("addEvent isDeviceEvent maxType = " + event.isIsMaxEvent() + " dropType = " + event.isIsDropFlow() + event.toString()));
                continue;
            }
            ++this.dropZoneIpSize;
            this.logger.error((Object)("drop a flow packet for zoneInBound, dropZoneIpSize=" + this.dropZoneIpSize));
            if (!event.isDeviceEvent()) continue;
            this.logger.warn((Object)("addEvent isDeviceEvent maxType = " + event.isIsMaxEvent() + " dropType = " + event.isIsDropFlow() + event.toString()));
        }
    }

    private void clearFlag() {
        if (this.dropWildIpSize + this.dropZoneIpSize > 0) {
            this.logger.warn((Object)("Drop wild ip size is " + this.dropWildIpSize));
            this.logger.warn((Object)("Drop zone ip size is " + this.dropZoneIpSize));
        }
        if (this.zoneIpSize > 0) {
            this.logger.info((Object)("zone ip size is: " + this.zoneIpSize));
        }
        this.wildIpSize = 0;
        this.zoneIpSize = 0;
        this.dropWildIpSize = 0;
        this.dropZoneIpSize = 0;
    }

    public Buffer<BizEvent> getBizEventBuffer() {
        return this.bizEventBuffer;
    }

    public Buffer<Event> getDnsEventBuffer() {
        return this.dnsEventBuffer;
    }

    public Buffer<Event> getFlowBuff() {
        return this.flowBuff;
    }

    @Override
    protected void proceedPacket(List<TimeDatagramPacket> packets) {
        if (!packets.isEmpty()) {
            long currentNum = this.generatePacketsKey.getKey();
            long currentBlackNum = this.generateBlacksKey.getKey();
            this.sortExceptionBuffer = new SortBuffer();
            this.sortBlackIpBuffer = new SortBuffer();
            for (TimeDatagramPacket packet : packets) {
                if (!this.isTimeOut(packet)) {
                    Collection<Event> all = this.packetParser.parsePacket(packet);
                    if (all.isEmpty()) continue;
                    this.addEvents(all, this.wildIpSize < this.wildIpLimit, this.zoneIpSize < this.zoneIpLimit);
                    continue;
                }
                this.logger.error((Object)("Drop a packet for timeout from device " + packet.getAddress()));
            }
            this.sortExceptionBuffer.setTag(currentNum);
            this.sortBlackIpBuffer.setTag(currentBlackNum);
            this.addBlackIpBuffer(this.sortBlackIpBuffer);
            this.addExcptionBuffer(this.sortExceptionBuffer);
            this.clearFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBlackIpBuffer(SortBuffer<ZoneBlackListEvent> sortBuffer) {
        List<SortBuffer<ZoneBlackListEvent>> list = this.blackIpBufferSortList;
        synchronized (list) {
            this.blackIpBufferSortList.add(sortBuffer);
            this.logger.info((Object)("blackIpBufferSortList.size(): " + this.blackIpBufferSortList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExcptionBuffer(SortBuffer<OriginalExceptionEvent> sort) {
        List<SortBuffer<OriginalExceptionEvent>> list = this.exceptionBufferSortList;
        synchronized (list) {
            this.exceptionBufferSortList.add(sort);
            this.logger.info((Object)("exceptionBufferSortList.size(): " + this.exceptionBufferSortList.size()));
        }
    }

    public boolean isTimeOut(TimeDatagramPacket packet) {
        return System.currentTimeMillis() - packet.getTime() >= this.timeOutPeroid;
    }

    public void setBizEventBuffer(Buffer<BizEvent> bizEventBuffer) {
        this.bizEventBuffer = bizEventBuffer;
    }

    public void setDnsEventBuffer(Buffer<Event> dnsEventBuffer) {
        this.dnsEventBuffer = dnsEventBuffer;
    }

    public void setFlowBuff(Buffer<Event> flowBuff) {
        this.flowBuff = flowBuff;
    }

    public Buffer<DnsDefendEvent> getDnsDefendEventBuffer() {
        return this.dnsDefendEventBuffer;
    }

    public void setDnsDefendEventBuffer(Buffer<DnsDefendEvent> dnsDefendEventBuffer) {
        this.dnsDefendEventBuffer = dnsDefendEventBuffer;
    }

    public void setExceptionBufferSortList(List<SortBuffer<OriginalExceptionEvent>> exceptionBufferSortList) {
        this.exceptionBufferSortList = exceptionBufferSortList;
    }

    public void setBlackIpBufferSortList(List<SortBuffer<ZoneBlackListEvent>> blackIpBufferSortList) {
        this.blackIpBufferSortList = blackIpBufferSortList;
    }

    public GeneratePacketsKey getGeneratePacketsKey() {
        return this.generatePacketsKey;
    }

    public void setGeneratePacketsKey(GeneratePacketsKey generatePacketsKey) {
        this.generatePacketsKey = generatePacketsKey;
    }

    public GeneratePacketsKey getGenerateBlacksKey() {
        return this.generateBlacksKey;
    }

    public void setGenerateBlacksKey(GeneratePacketsKey generateBlackKey) {
        this.generateBlacksKey = generateBlackKey;
    }

    public void setSecondFlowBuffer(Buffer<SecondFlowEvent> secondFlowBuffer) {
        this.secondFlowBuffer = secondFlowBuffer;
    }

    public Buffer<SecondFlowEvent> getSecondFlowBuffer() {
        return this.secondFlowBuffer;
    }

    public Buffer<IPReputationEvent> getIpReputationFlowBuffer() {
        return this.ipReputationFlowBuffer;
    }

    public void setIpReputationFlowBuffer(Buffer<IPReputationEvent> ipReputationFlowBuffer) {
        this.ipReputationFlowBuffer = ipReputationFlowBuffer;
    }
}

