/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.alarm.SyslogThread;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.SecondFlowEvent;
import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.entity.homepage.DashboardQueryBean;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SecondFLowHandler
extends EventHandler<SecondFlowEvent, SecondFlowEvent>
implements Processor<SecondFlowEvent> {
    private static final SecondFLowHandler INSTANCE = new SecondFLowHandler();
    private static final Long LOG_CACHE_TIME = 20000L;
    private static final Long CHECK_PERIOD = 2000L;
    private static final int CHECKED_FLAG = 1;
    private static Map<IpType, SecondFlowEvent> secondFlowMap = new HashMap<IpType, SecondFlowEvent>();
    private static Map<IpType, Long> lastLogTimeMap = new HashMap<IpType, Long>();
    private SyslogThread syslogThread = SyslogThread.getInstance();
    private long lastCheckTime = 0L;

    private SecondFLowHandler() {
        this.initSysConfig();
    }

    public static SecondFLowHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void processMetaData(List<SecondFlowEvent> datas) {
        this.handelEvents(datas);
    }

    @Override
    protected List<SecondFlowEvent> handelEvents(List<SecondFlowEvent> events) {
        this.checkLogOutTime();
        if (null != events && !events.isEmpty()) {
            Map<String, Object> keysAndValuesMap = this.syslogThread.getSyslogClienMapKeysAndValues();
            List keys = (List)keysAndValuesMap.get("keys");
            List values = (List)keysAndValuesMap.get("values");
            HashMap syslogClienMap = new HashMap();
            if (null == keys || keys.size() == 0) {
                syslogClienMap = null;
            } else {
                for (int i = 0; i < keys.size(); ++i) {
                    syslogClienMap.put(keys.get(i), values.get(i));
                }
            }
            SysLog sysLog = null;
            for (SecondFlowEvent event : events) {
                IpType ipType = new IpType(null, event.getIdentifier(), true, true);
                secondFlowMap.put(ipType, event);
                lastLogTimeMap.put(ipType, event.getLogTime());
                if (null == syslogClienMap || syslogClienMap.isEmpty()) continue;
                for (Map.Entry syslogClientEntry : syslogClienMap.entrySet()) {
                    SyslogServerEntity server = ((SyslogClientAbstrat)syslogClientEntry.getValue()).getSyslogServerEntity();
                    if (1 != server.getDefaultZoneSyslog() && FoundIDUtil.getInstance().isDefaultZone(event.getZoneId()) || 1 != server.getIpFlowSecondsSyslog()) continue;
                    ArrayList<SysLog> logList = new ArrayList<SysLog>();
                    sysLog = new SysLog(event);
                    logList.add(sysLog);
                    this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), logList);
                }
            }
        }
        return new ArrayList<SecondFlowEvent>();
    }

    private void checkLogOutTime() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastCheckTime < CHECK_PERIOD) {
            return;
        }
        Iterator<Map.Entry<IpType, SecondFlowEvent>> iterator = secondFlowMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IpType, SecondFlowEvent> logEntry = iterator.next();
            IpType ipType = logEntry.getKey();
            Long lastTime = lastLogTimeMap.get(ipType);
            if (null == lastTime) {
                lastLogTimeMap.put(ipType, logEntry.getValue().getLogTime());
                continue;
            }
            if (currTime - lastTime < LOG_CACHE_TIME) continue;
            this.logger.info((Object)("remove second flow for donot receive event over " + LOG_CACHE_TIME + "s, event=" + logEntry.getValue().toString()));
            iterator.remove();
            lastLogTimeMap.remove(ipType);
        }
        this.lastCheckTime = currTime;
    }

    public void getSecondFlowEvent(DashboardQueryBean bean) {
        if (null == bean) {
            return;
        }
        EventIdentifier identifier = new EventIdentifier();
        identifier.setDeviceIp(bean.getDevIp());
        identifier.setDeviceType(bean.getDevType());
        identifier.setZoneIp(IpTransformer.formatIpAddress(bean.getZoneIp()));
        identifier.setDirection(bean.getDirection());
        IpType ipType = new IpType(null, identifier, true, true);
        SecondFlowEvent secondFlowEvent = secondFlowMap.get(ipType);
        if (null != secondFlowEvent) {
            long inFlowKbps = secondFlowEvent.getMaxInKbps();
            bean.setInFlowKbps(inFlowKbps);
            bean.setOutFlowKbps(inFlowKbps - secondFlowEvent.getMaxDropKbps());
            long inFlowPps = secondFlowEvent.getMaxInPps();
            bean.setInFlowPps(inFlowPps);
            bean.setOutFlowPps(inFlowPps - secondFlowEvent.getMaxDropPps());
        }
    }

    public void initSysConfig() {
    }
}

