/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventDataParser;
import com.hs.atic.collector.entity.event.IpSuitEvent;
import com.hs.atic.collector.entity.event.SecondFlowEvent;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SecondFlowParserV1
implements EventDataParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static final int SECOND_FLOW_EVENT = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseData(byte[] data, IpSuitEvent suitEvent, int type, int number) throws IOException {
        if (16 == type) {
            FilterInputStream stream = null;
            try {
                stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
                for (int i = 0; i < number; ++i) {
                    this.parse((UnsignedDataInputStream)stream, suitEvent);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("when close stram error!" + e.getMessage()));
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
        }
    }

    private void parse(UnsignedDataInputStream stream, IpSuitEvent event) throws IOException {
        SecondFlowEvent secondFlowEvent = new SecondFlowEvent(event.getIdentifier());
        secondFlowEvent.setMaxInKbps(stream.readUnsignedLong());
        secondFlowEvent.setMaxDropKbps(stream.readUnsignedLong());
        secondFlowEvent.setMaxInPps(stream.readUnsignedLong());
        secondFlowEvent.setMaxDropPps(stream.readUnsignedLong());
        secondFlowEvent.setMaxKbpsTime(stream.readUnsignedInt());
        secondFlowEvent.setMaxPpsTime(stream.readUnsignedInt());
        secondFlowEvent.setInFlowKbps(stream.readUnsignedLong());
        secondFlowEvent.setDropFlowKbps(stream.readUnsignedLong());
        secondFlowEvent.setInFlowPps(stream.readUnsignedLong());
        secondFlowEvent.setDropFlowPps(stream.readUnsignedLong());
        event.setSecondFlowEvent(secondFlowEvent);
    }
}

