/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.ServiceLearningTaskWrapper;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.condition.AllCondition;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.condition.ServiceLearningConditionField;
import com.hs.atic.collector.entity.ServiceLearningTask;
import com.hs.atic.collector.entity.event.BizEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public final class ServiceLearningEvnetHanlder
extends EventHandler<BizEvent, BizEvent>
implements Processor<BizEvent> {
    private static final Logger LOGGER = LogManager.getInstance().getBizEventLog();
    private static final Repository<BizEvent> RESULT_REPOSITORY = RepositoryFactory.getInstance().getRepository(BizEvent.class.getName());
    private static final Repository<ServiceLearningTaskWrapper> TASK_REPOSITORY = RepositoryFactory.getInstance().getRepository(ServiceLearningTaskWrapper.class.getName());
    private static final int DEFAULT_BIZ_PERIOD = 300000;
    private static ServiceLearningEvnetHanlder instance = new ServiceLearningEvnetHanlder();
    private static final long CYC = 70L;
    private final int period;
    private long lastTime;
    private long lastCycTime;
    private Set<ServiceLearningTaskWrapper> wrappers = new HashSet<ServiceLearningTaskWrapper>();
    private List<ServiceLearningTaskWrapper> waitWrapperLearn = new ArrayList<ServiceLearningTaskWrapper>();

    private ServiceLearningEvnetHanlder() {
        this.period = this.getBizPeroid();
        this.refreshLastTime();
        this.lastCycTime = System.currentTimeMillis() / 1000L;
        this.wrappers.addAll(TASK_REPOSITORY.queryObject(new AllCondition()));
    }

    public static ServiceLearningEvnetHanlder getInstance() {
        if (null == instance) {
            instance = new ServiceLearningEvnetHanlder();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServicelearningEvnetTask(ServiceLearningTask taskEvnet) {
        List<ServiceLearningTaskWrapper> list = this.waitWrapperLearn;
        synchronized (list) {
            ServiceLearningTaskWrapper wrapper = new ServiceLearningTaskWrapper(taskEvnet);
            wrapper.setStartUpLearn(true);
            this.waitWrapperLearn.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServicelearningEvnetTask(ServiceLearningTask taskEvnet) {
        List<ServiceLearningTaskWrapper> list = this.waitWrapperLearn;
        synchronized (list) {
            ServiceLearningTaskWrapper wrapper = new ServiceLearningTaskWrapper(taskEvnet);
            wrapper.setStartUpLearn(false);
            this.waitWrapperLearn.add(wrapper);
        }
    }

    protected Condition getCondition(ServiceLearningTaskWrapper wrapper) {
        ConditionClause idCondition = new ConditionClause();
        idCondition.setField(new ServiceLearningConditionField("zoneId"));
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        idCondition.setSeparator(separator);
        idCondition.setValue(wrapper.getZoneId());
        idCondition.addValueList(idCondition.getValue());
        ConditionClause ipCondition = new ConditionClause();
        ipCondition.setField(new ServiceLearningConditionField("devIp"));
        ipCondition.setSeparator(separator);
        ipCondition.setValue(wrapper.getDeviceIp());
        idCondition.addValueList(ipCondition.getValue());
        idCondition.andCondtion(ipCondition);
        return idCondition;
    }

    protected void addWrapper(ServiceLearningTaskWrapper wrapper) {
        Condition condition = this.getCondition(wrapper);
        if (this.wrappers.contains(wrapper)) {
            this.wrappers.remove(wrapper);
            TASK_REPOSITORY.deleteObject(condition);
        }
        TASK_REPOSITORY.createObject(wrapper);
        this.wrappers.add(wrapper);
        RESULT_REPOSITORY.deleteObject(condition);
    }

    protected void removeWrapper(ServiceLearningTaskWrapper wrapper) {
        Condition condition = this.getCondition(wrapper);
        this.wrappers.remove(wrapper);
        TASK_REPOSITORY.deleteObject(condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshWrappers() {
        List<ServiceLearningTaskWrapper> list = this.waitWrapperLearn;
        synchronized (list) {
            for (ServiceLearningTaskWrapper wrapper : this.waitWrapperLearn) {
                if (wrapper.isStartUpLearn()) {
                    this.addWrapper(wrapper);
                    continue;
                }
                this.removeWrapper(wrapper);
            }
            this.waitWrapperLearn.clear();
        }
    }

    @Override
    protected synchronized List<BizEvent> handelEvents(List<BizEvent> events) {
        try {
            this.refreshWrappers();
            if (this.isTimeToSumOnCyc()) {
                this.lastCycTime = System.currentTimeMillis() / 1000L;
                for (ServiceLearningTaskWrapper serviceLearningTaskWrapper : this.wrappers) {
                    serviceLearningTaskWrapper.sumOnOneCyc();
                }
            }
            if (this.isTimeToMerge()) {
                ArrayList<BizEvent> list = new ArrayList<BizEvent>();
                for (ServiceLearningTaskWrapper wrapper : this.wrappers) {
                    list.addAll(wrapper.getEvent());
                }
                this.refreshLastTime();
                this.notifyFollowHandlers(list);
            }
            Iterator<ServiceLearningTaskWrapper> it = this.wrappers.iterator();
            while (it.hasNext()) {
                ServiceLearningTaskWrapper serviceLearningTaskWrapper = it.next();
                if (serviceLearningTaskWrapper.isTimeOut()) {
                    Condition condition = this.getCondition(serviceLearningTaskWrapper);
                    TASK_REPOSITORY.deleteObject(condition);
                    it.remove();
                    continue;
                }
                if (events.isEmpty()) continue;
                serviceLearningTaskWrapper.sumEvent(events);
            }
        }
        catch (OutOfMemoryError error) {
            LOGGER.error((Object)"out of memory ,then I clear the  data");
        }
        return new ArrayList<BizEvent>();
    }

    public synchronized int getAllTaskNum() {
        return this.wrappers.size();
    }

    public synchronized int getAllResultSize() {
        int num = 0;
        for (ServiceLearningTaskWrapper wrapper : this.wrappers) {
            num += wrapper.getResultSize();
        }
        return num;
    }

    protected boolean isTimeToSumOnCyc() {
        return System.currentTimeMillis() / 1000L - this.lastCycTime >= 70L;
    }

    protected void refreshLogTime(List<Event> eventsAfterMergeByIp) {
        long time = EventUtil.getIntegralTime(this.period);
        time -= (long)this.period;
        for (Event event : eventsAfterMergeByIp) {
            event.setLogTime(time);
        }
    }

    protected void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(this.period);
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    @Override
    public void processMetaData(List<BizEvent> datas) {
        this.handelEvents(datas);
    }

    protected int getBizPeroid() {
        int periods = 300000;
        try {
            periods = Integer.parseInt(EventUtil.getEventConfigProperty("BizThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is DnsThreadPeriod");
        }
        return periods;
    }
}

