/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.SeviceLearningEventType;
import com.hs.atic.collector.biz.event.process.SumCycEvent;
import com.hs.atic.collector.entity.ServiceLearningTask;
import com.hs.atic.collector.entity.event.BizEvent;
import com.hs.atic.collector.util.GeneratePrimalKey;
import com.hs.atic.collector.util.TimeTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceLearningTaskWrapper {
    protected Map<SeviceLearningEventType, SumCycEvent<BizEvent>> bizEventMaps = new HashMap<SeviceLearningEventType, SumCycEvent<BizEvent>>();
    private String startTime;
    private String stopTime;
    private String deviceIp;
    private long zoneId;
    private boolean startUpLearn;

    public ServiceLearningTaskWrapper(long zoneId, String deviceIp, String startTime, String stopTime) {
        this.zoneId = zoneId;
        this.deviceIp = deviceIp;
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public ServiceLearningTaskWrapper(ServiceLearningTask task) {
        this.zoneId = task.getZoneId();
        this.deviceIp = task.getDeviceIp();
        this.startTime = task.getStartTime();
        this.stopTime = task.getStopTime();
    }

    public void sumEvent(List<BizEvent> events) {
        for (BizEvent t : events) {
            if (!this.isMatch(t)) continue;
            SeviceLearningEventType bizSumType = new SeviceLearningEventType(t);
            if (this.bizEventMaps.containsKey(bizSumType) && null != this.bizEventMaps.get(bizSumType)) {
                this.bizEventMaps.get(bizSumType).addEvent(t);
                continue;
            }
            this.bizEventMaps.put(bizSumType, new SumCycEvent<BizEvent>(t));
        }
    }

    public void sumOnOneCyc() {
        for (Map.Entry<SeviceLearningEventType, SumCycEvent<BizEvent>> entry : this.bizEventMaps.entrySet()) {
            if (null == entry.getValue()) continue;
            entry.getValue().sumOnOneCyc();
        }
    }

    public List<BizEvent> getEvent() {
        ArrayList<BizEvent> list = new ArrayList<BizEvent>();
        ArrayList<SeviceLearningEventType> remove = new ArrayList<SeviceLearningEventType>();
        for (Map.Entry<SeviceLearningEventType, SumCycEvent<BizEvent>> entry : this.bizEventMaps.entrySet()) {
            BizEvent t = entry.getValue() == null ? null : entry.getValue().getInEvent();
            if (null == t) continue;
            if (entry.getKey().isSaved()) {
                t.setPkid(entry.getKey().getPkidEvent());
                t.setSaved(true);
            } else {
                long pkid = GeneratePrimalKey.getInstance().getServiceLearningKey();
                t.setPkid(pkid);
                entry.getKey().setPkidEvent(pkid);
                entry.getKey().setSaved(true);
            }
            if (t.isValid()) {
                list.add(t);
            }
            entry.getValue().reset();
            if (!entry.getValue().isCanDestroy()) continue;
            remove.add(entry.getKey());
        }
        for (SeviceLearningEventType type : remove) {
            this.bizEventMaps.put(type, null);
        }
        return list;
    }

    protected boolean isMatch(BizEvent event) {
        return event.getDeviceIp().equals(this.deviceIp) && event.getZoneId() == this.zoneId;
    }

    public boolean isTimeOut() {
        long current = System.currentTimeMillis() / 1000L;
        return current > TimeTransformer.convertTimeString(this.stopTime);
    }

    public int getResultSize() {
        return this.bizEventMaps.size();
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(String stopTime) {
        this.stopTime = stopTime;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public boolean isStartUpLearn() {
        return this.startUpLearn;
    }

    public void setStartUpLearn(boolean startUp) {
        this.startUpLearn = startUp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deviceIp == null ? 0 : this.deviceIp.hashCode());
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceLearningTaskWrapper other = (ServiceLearningTaskWrapper)obj;
        if (this.deviceIp == null ? other.deviceIp != null : !this.deviceIp.equals(other.deviceIp)) {
            return false;
        }
        return this.zoneId == other.zoneId;
    }

    public String toString() {
        return "ServiceLearningTaskWrapper [deviceIp=" + this.deviceIp + ", startTime=" + this.startTime + ", stopTime=" + this.stopTime + ", zoneId=" + this.zoneId + "]";
    }
}

