/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.SlotFlowCycEvent;
import com.hs.atic.collector.biz.event.process.SlotType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.SlotTotalFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlotSumHandler<T extends Event>
extends EventHandler<T, T> {
    private static final long CYC = 64L;
    protected Map<Type, SlotFlowCycEvent<T>> ipEventMaps = new HashMap<Type, SlotFlowCycEvent<T>>();
    private final int period;
    private long lastTime;
    private long lastCycTime;

    public SlotSumHandler(int period) {
        this.period = period;
        this.refreshLastTime();
        this.lastCycTime = System.currentTimeMillis() / 1000L;
        super.setLogger(LogManager.getInstance().getFlowLog());
    }

    private void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(this.period);
    }

    protected boolean isTimeToSumOnCyc() {
        return System.currentTimeMillis() / 1000L - this.lastCycTime >= 64L;
    }

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event t : events) {
            if (t.getIdentifier().isDesZone() || t.isIsMaxEvent() || t.getIdentifier().isIpLocation() || "NFA".equals(t.getIdentifier().getDeviceTypeName()) || !t.isZoneEvent()) continue;
            result.add(t);
        }
        return result;
    }

    protected List<T> sumEvents(List<T> events) {
        for (Event t : events) {
            if (!t.isNeedSum()) continue;
            SlotType type = new SlotType(t.getIdentifier());
            SlotTotalFlowEvent slotEvent = new SlotTotalFlowEvent(t.getIdentifierCopy(), t.isIsDropFlow());
            if (t instanceof InFlowEvent) {
                slotEvent.mergeInFlowEvent((InFlowEvent)t);
            }
            if (t instanceof DiscardFlowEvent) {
                slotEvent.mergeDiscardFlowEvent((DiscardFlowEvent)t);
            }
            if (t instanceof TcpBizFlowEvent) {
                slotEvent.mergeTcpBizFlowEvent((TcpBizFlowEvent)t);
            }
            if (t instanceof UdpBizFlowEvent) {
                slotEvent.mergeUdpBizFlowEvent((UdpBizFlowEvent)t);
            }
            if (t instanceof OtherBizFlowEvent) {
                slotEvent.mergeOtherBizFlowEvent((OtherBizFlowEvent)t);
            }
            if (this.ipEventMaps.containsKey(type)) {
                this.ipEventMaps.get(type).addEvent(slotEvent);
                continue;
            }
            this.ipEventMaps.put(type, new SlotFlowCycEvent<SlotTotalFlowEvent>(slotEvent));
        }
        return new ArrayList();
    }

    protected void sumOnOneCyc() {
        for (Map.Entry<Type, SlotFlowCycEvent<T>> entry : this.ipEventMaps.entrySet()) {
            entry.getValue().sumOnOneCyc();
        }
    }

    private boolean isTimeToMerge() {
        return System.currentTimeMillis() - this.lastTime >= (long)this.period;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        try {
            if (this.isTimeToSumOnCyc()) {
                this.lastCycTime = System.currentTimeMillis() / 1000L;
                this.sumOnOneCyc();
            }
            if (this.isTimeToMerge()) {
                ArrayList<T> list = new ArrayList<T>();
                ArrayList<Type> remove = new ArrayList<Type>();
                for (Map.Entry<Type, SlotFlowCycEvent<T>> entry : this.ipEventMaps.entrySet()) {
                    T t = entry.getValue().getInEvent();
                    if (null != t && ((Event)t).isValid()) {
                        ((Event)t).getIdentifier().setSlotType();
                        list.add(t);
                    }
                    if (null != (t = entry.getValue().getOutEvent()) && ((Event)t).isValid()) {
                        ((Event)t).getIdentifier().setSlotType();
                        list.add(t);
                    }
                    entry.getValue().reset();
                    if (!entry.getValue().isCanDestroy()) continue;
                    remove.add(entry.getKey());
                }
                for (Type type : remove) {
                    this.ipEventMaps.remove(type);
                }
                this.refreshLastTime();
                this.refreshLogTime(list);
                EventUtil.createEvents(list);
                this.notifyFollowHandlers(list);
            }
            this.sumEvents(events);
        }
        catch (OutOfMemoryError error) {
            this.ipEventMaps.clear();
            this.logger.error((Object)"out of memory ,then I clear the  data");
        }
        return new ArrayList();
    }

    protected void refreshLogTime(List<T> eventsAfterMergeByIp) {
        long time = EventUtil.getIntegralTime(this.period);
        time -= (long)this.period;
        for (Event event : eventsAfterMergeByIp) {
            event.setLogTime(time);
        }
    }
}

