/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.entity.event.SrcTopnEvent;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class SrcTopnWirteFileThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final long FILE_PERIED_TIME = 87381000L;
    private static final String FILE_NAME_START = "SrcTopnEvent_";
    private static final String FILE_PATH = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "srcTopnEvents";
    protected ReentrantLock lock = new ReentrantLock();
    private List<SrcTopnEvent> srcTopnList = new ArrayList<SrcTopnEvent>();
    private long lastFileTime = 0L;
    private String curFileName = "";
    private long timePeriod;

    public long getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(long timePeriod) {
        this.timePeriod = timePeriod;
    }

    public void addSrcTopnEvent(List<SrcTopnEvent> srcTopnList2) {
        this.lock.lock();
        try {
            this.srcTopnList.addAll(srcTopnList2);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        LOGGER.info((Object)"SrcTopnWirteFileThread: start");
        List<SrcTopnEvent> srcTopnListTemp = null;
        this.createDirectory();
        while (true) {
            if (!this.srcTopnList.isEmpty()) {
                this.lock.lock();
                try {
                    srcTopnListTemp = this.srcTopnList;
                    this.srcTopnList = new ArrayList<SrcTopnEvent>();
                }
                finally {
                    this.lock.unlock();
                }
                this.createFileAndWrite(srcTopnListTemp);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"sleep error");
                continue;
            }
            break;
        }
    }

    private void createDirectory() {
        try {
            File file = new File(FILE_PATH);
            if (!file.exists() && !file.mkdir()) {
                LOGGER.error((Object)"when srcTopnEvents directory,fail.");
            }
        }
        catch (SecurityException e) {
            LOGGER.error((Object)("when srcTopnEvents directory,fail." + e.getMessage()));
        }
        catch (RuntimeException e1) {
            LOGGER.error((Object)("when srcTopnEvents directory,runtime Exception." + e1.getMessage()));
        }
    }

    private void createFileAndWrite(List<SrcTopnEvent> events) {
        try {
            String fileName = this.getFileName();
            String[] lines = new String[events.size()];
            int i = 0;
            for (SrcTopnEvent each : events) {
                lines[i] = this.getDbString(each) + LogManager.NEXT_LINE;
                ++i;
            }
            LOGGER.debug((Object)("src topn events line num=" + i));
            this.writeLinesToFile(fileName, lines);
        }
        catch (Exception e) {
            LOGGER.error((Object)"wirte src topn event error", (Throwable)e);
        }
    }

    private String getFileName() {
        long currTime = System.currentTimeMillis();
        if (0L == this.lastFileTime || currTime - this.lastFileTime >= 87381000L) {
            this.lastFileTime = currTime;
            String time = new SimpleDateFormat("yyyyMMdd_HHmmss").format(currTime - this.timePeriod);
            this.curFileName = FILE_PATH + File.separator + FILE_NAME_START + time + ".txt";
        }
        return this.curFileName;
    }

    private String getDbString(SrcTopnEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getLogTime() / 1000L);
        buffer.append(";");
        buffer.append(event.getDeviceIp());
        buffer.append(";");
        buffer.append(event.getDeviceType());
        buffer.append(";");
        buffer.append(event.getSrcIp());
        buffer.append(";");
        buffer.append(event.getRequestPps());
        buffer.append(";");
        buffer.append(event.getRequestKbps());
        buffer.append(";");
        buffer.append(event.getAttackDstIp());
        buffer.append(";");
        buffer.append(event.getUnAttackDstIp());
        buffer.append(";");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLinesToFile(String fileName, String[] lines) {
        OutputStreamWriter out = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    LOGGER.error((Object)"create new file error");
                }
                LOGGER.debug((Object)"file.createNewFile()");
            }
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), "UTF-8");
            for (int i = 0; i < lines.length; ++i) {
                out.append(lines[i]);
            }
            LOGGER.debug((Object)"File.write() over.");
        }
        catch (IOException e) {
            LOGGER.error((Object)("write to srcTopnEvents IOException." + e.getMessage()));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"out.close() IOException", (Throwable)e);
            }
        }
    }
}

