/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.SumDiscardEvent;
import com.hs.atic.collector.entity.event.SumEvent;
import com.hs.atic.collector.entity.event.SumForwardFlowEvent;
import com.hs.atic.collector.entity.event.SumInFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SumEventHandler<S extends Event, E extends Event>
extends EventHandler<E, S> {
    private static Map<String, String> sumClassNames = new HashMap<String, String>();
    private static final int COUNT = 12;
    private long previousTime;
    private Map<Type, S> cache = new HashMap<Type, S>();

    public SumEventHandler() {
        super.setLogger(LogManager.getInstance().getHourTaskLog());
        this.initStartTime();
    }

    public synchronized void doHourTask() {
        ArrayList<S> sums = new ArrayList<S>();
        sums.addAll(this.cache.values());
        this.cache.clear();
        this.clearIpNum2JmxMonitor();
        this.refreshSumEvents(sums);
        EventUtil.createEvents(sums);
        this.notifyFollowHandlers(sums);
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.previousTime = calendar.getTimeInMillis();
    }

    public void initStartTime() {
        this.refreshTime();
    }

    public Map<Type, S> getCache() {
        return this.cache;
    }

    @Override
    public void handel(List<E> events) {
        List<E> e = this.debugEvents(events);
        this.handelEvents(e);
    }

    public void sumEvents(List<E> events) {
        Map<Type, List<E>> groups = this.groupEvents(events);
        for (Map.Entry<Type, List<E>> entry : groups.entrySet()) {
            Event event;
            S sum;
            List<E> sameTypeEvents = entry.getValue();
            if (sameTypeEvents.isEmpty() || (sum = this.getSumSuitEvent(event = (Event)sameTypeEvents.get(0))) == null) continue;
            ((SumEvent)sum).sumElement(sameTypeEvents);
        }
        if (!events.isEmpty()) {
            this.logger.info((Object)"add events to sum cache completed ");
        }
    }

    protected S createSumEvent(E event) {
        EventIdentifier identifer = this.getEventIdentifer(event);
        String clazzName = this.getSumClassName(event.getClass().getName());
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(EventIdentifier.class);
            Event sum = (Event)constructor.newInstance(identifer);
            return (S)sum;
        }
        catch (InstantiationException e) {
            this.logger.error((Object)("createSumEvent " + clazzName + " is error :" + e.getMessage()));
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)("createSumEvent " + clazzName + " is error :" + e.getMessage()));
            return null;
        }
        catch (InvocationTargetException e) {
            this.logger.error((Object)("createSumEvent " + clazzName + " is error :" + e.getMessage()));
            return null;
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("createSumEvent " + clazzName + " is error :" + e.getMessage()));
            return null;
        }
        catch (NoSuchMethodException e) {
            this.logger.error((Object)("createSumEvent " + clazzName + " is error :" + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)("createSumEvent " + clazzName + " is error :" + e.getMessage()));
            return null;
        }
    }

    protected abstract EventIdentifier getEventIdentifer(E var1);

    protected abstract Type getEventType(E var1);

    protected abstract void addIpNum2JmxMonitor(E var1);

    protected abstract void clearIpNum2JmxMonitor();

    @Override
    protected synchronized List<S> handelEvents(List<E> events) {
        if (!events.isEmpty()) {
            try {
                this.sumEvents(events);
            }
            catch (OutOfMemoryError error) {
                this.cache.clear();
                this.logger.error((Object)"out of memory ,then I clear the hour cache data");
            }
        }
        if (System.currentTimeMillis() - this.previousTime >= 3600000L) {
            this.doHourTask();
            this.refreshTime();
        }
        return new ArrayList();
    }

    public long getPreviousTime() {
        return this.previousTime;
    }

    protected void refreshSumEvents(List<S> sums) {
        for (Event t : sums) {
            t.setLogTime(this.previousTime);
            t.average(12);
        }
    }

    private String getSumClassName(String clazzName) {
        return sumClassNames.get(clazzName);
    }

    private S getSumSuitEvent(E event) {
        Type eventType = this.getEventType(event);
        if (this.cache.containsKey(eventType)) {
            return (S)((Event)this.cache.get(eventType));
        }
        S sum = this.createSumEvent(event);
        if (null != sum) {
            this.cache.put(eventType, sum);
            this.addIpNum2JmxMonitor(event);
        }
        return sum;
    }

    private Map<Type, List<E>> groupEvents(List<E> events) {
        HashMap<Type, List<E>> map = new HashMap<Type, List<E>>();
        for (Event e : events) {
            Type type = this.getEventType(e);
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(e);
            map.put(type, array);
        }
        return map;
    }

    static {
        sumClassNames.put(InFlowEvent.class.getName(), SumInFlowEvent.class.getName());
        sumClassNames.put(DiscardFlowEvent.class.getName(), SumDiscardEvent.class.getName());
        sumClassNames.put(ForwardFlowEvent.class.getName(), SumForwardFlowEvent.class.getName());
    }
}

