/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.alarm.SyslogThread;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.FoundIDUtil;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.entity.event.ToSysLog;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.SyslogServerUtil;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SysLogHandler<T extends Event>
extends EventHandler<T, T> {
    private static final int CHECKED_FLAG = 1;
    private static SysLogHandler instance = new SysLogHandler();
    private List<String> logServers = new ArrayList<String>();
    private Map<IpType, SysLog> maxSyslogMap = new HashMap<IpType, SysLog>();
    private Map<IpType, List<String>> avgSyslogMap = new HashMap<IpType, List<String>>();
    private boolean syslogFlowEnabled = true;
    private boolean syslogOutboundFlowEnabled = false;
    private SyslogThread syslogThread = SyslogThread.getInstance();

    private SysLogHandler() {
        super.setLogger(LogManager.getInstance().getSysLogLogger());
        this.loadLogServersFromDb();
    }

    public static SysLogHandler getInstance() {
        return instance;
    }

    public void loadLogServersFromDb() {
        this.logger.info((Object)"begin loadLogServersFromDb");
        this.logServers.clear();
        Map<String, Object> keysAndValuesMap = SyslogServerUtil.getInstance().getSyslogServerMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        HashMap<String, SyslogServerEntity> serverMap = new HashMap<String, SyslogServerEntity>();
        if (null == keys || keys.size() == 0) {
            serverMap = null;
        } else {
            for (int i = 0; i < keys.size(); ++i) {
                serverMap.put((String)keys.get(i), (SyslogServerEntity)values.get(i));
            }
        }
        if (null != serverMap && !serverMap.isEmpty()) {
            this.syslogThread.setLogServers(serverMap);
            for (Map.Entry map : serverMap.entrySet()) {
                this.logServers.add(((String)map.getKey()).split(",")[0]);
                SyslogServerEntity server = (SyslogServerEntity)map.getValue();
                if (1 == server.getFlowSyslog()) {
                    this.syslogFlowEnabled = true;
                }
                if (1 != server.getFlowSyslogOutbound()) continue;
                this.syslogOutboundFlowEnabled = true;
            }
        }
    }

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        if ((this.syslogFlowEnabled || this.syslogOutboundFlowEnabled) && !this.logServers.isEmpty()) {
            for (Event t : events) {
                if (t instanceof UdpDnsUserDefTypeEvent || !t.isNeedSum() || t.isIsForwardFlow()) continue;
                int direction = t.getDirection();
                if (1 == direction && this.syslogFlowEnabled) {
                    result.add(t);
                }
                if (2 != direction || !this.syslogOutboundFlowEnabled) continue;
                result.add(t);
            }
            if (!result.isEmpty()) {
                this.logger.debug((Object)("* debugEvents * result.size:" + result.size()));
            }
        }
        return result;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        if (!events.isEmpty()) {
            HashMap<String, List<SysLog>> logListMap = new HashMap<String, List<SysLog>>();
            String timeStamp = EventUtil.getTimeStamp(System.currentTimeMillis());
            for (int i = 0; i < events.size(); ++i) {
                Event event = (Event)events.get(i);
                this.processFlowSyslog(event, timeStamp, logListMap);
            }
            if (!logListMap.isEmpty()) {
                for (Map.Entry map : logListMap.entrySet()) {
                    String key = (String)map.getKey();
                    String[] keys = key.split(",");
                    Long zoneId = Long.parseLong(keys[0]);
                    Integer direction = Integer.parseInt(keys[1]);
                    Map<String, Object> keysAndValuesMap = this.syslogThread.getSyslogClienMapKeysAndValues();
                    List keys1 = (List)keysAndValuesMap.get("keys");
                    List values = (List)keysAndValuesMap.get("values");
                    HashMap syslogClienMap = new HashMap();
                    if (null != keys1 && keys1.size() != 0) {
                        for (int i = 0; i < keys1.size(); ++i) {
                            syslogClienMap.put(keys1.get(i), values.get(i));
                        }
                    }
                    if (syslogClienMap.isEmpty()) continue;
                    for (Map.Entry syslogClientEntry : syslogClienMap.entrySet()) {
                        SyslogServerEntity server = ((SyslogClientAbstrat)syslogClientEntry.getValue()).getSyslogServerEntity();
                        if (1 != server.getDefaultZoneSyslog() && FoundIDUtil.getInstance().isDefaultZone(zoneId)) continue;
                        if (1 == direction && 1 == server.getFlowSyslog()) {
                            this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), (List)map.getValue());
                        }
                        if (2 != direction || 1 != server.getFlowSyslogOutbound()) continue;
                        this.syslogThread.addSyslog((String)syslogClientEntry.getKey(), (List)map.getValue());
                    }
                }
            }
        }
        return events;
    }

    private void processFlowSyslog(T event, String timeStamp, Map<String, List<SysLog>> logListMap) {
        IpType ipType = new IpType(((Event)event).getIdentifier());
        ipType.setDeviceEvent(((Event)event).isDeviceEvent());
        if (((Event)event).isIsMaxEvent()) {
            SysLog sysLog = new SysLog((ToSysLog)event);
            List<String> avgFlows = this.avgSyslogMap.get(ipType);
            if (null == avgFlows) {
                this.maxSyslogMap.put(ipType, sysLog);
            } else {
                sysLog.getContent().addAll(avgFlows);
                sysLog.setTimeStamp(timeStamp);
                this.addSyslogToSendMap(sysLog, event, logListMap);
                this.avgSyslogMap.remove(ipType);
            }
        } else {
            SysLog avgSysLog = new SysLog((ToSysLog)event);
            List<String> avgFlows = avgSysLog.getContent();
            SysLog sysLog = this.maxSyslogMap.get(ipType);
            if (null == sysLog) {
                this.avgSyslogMap.put(ipType, avgFlows);
            } else {
                sysLog.getContent().addAll(avgFlows);
                sysLog.setTimeStamp(timeStamp);
                this.addSyslogToSendMap(sysLog, event, logListMap);
                this.maxSyslogMap.remove(ipType);
            }
        }
    }

    private void addSyslogToSendMap(SysLog sysLog, T event, Map<String, List<SysLog>> logListMap) {
        long zoneId = ((Event)event).getZoneId();
        int direction = ((Event)event).getDirection();
        String key = zoneId + "," + direction;
        if (null == logListMap.get(key)) {
            ArrayList<SysLog> lst = new ArrayList<SysLog>();
            lst.add(sysLog);
            logListMap.put(key, lst);
        } else {
            logListMap.get(key).add(sysLog);
        }
    }
}

