/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AttackTypeEvent;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneAttackTypeOriginalHandler
extends EventHandler<AttackTypeEvent, AttackTypeEvent> {
    public ZoneAttackTypeOriginalHandler() {
        super.setLogger(LogManager.getInstance().getAttackLog());
    }

    @Override
    protected List<AttackTypeEvent> handelEvents(List<AttackTypeEvent> events) {
        Map<Type, List<AttackTypeEvent>> zones = this.groupEvents(events);
        ArrayList<AttackTypeEvent> zoneEvents = new ArrayList<AttackTypeEvent>();
        for (Map.Entry<Type, List<AttackTypeEvent>> entry : zones.entrySet()) {
            zoneEvents.add(this.mergeEvent(entry.getValue()));
        }
        EventUtil.createEvents(zoneEvents);
        return zoneEvents;
    }

    private Map<Type, List<AttackTypeEvent>> groupEvents(List<AttackTypeEvent> events) {
        HashMap<Type, List<AttackTypeEvent>> map = new HashMap<Type, List<AttackTypeEvent>>();
        for (AttackTypeEvent e : events) {
            BizType type = new BizType(e.getAttackType(), e);
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<AttackTypeEvent> array = new ArrayList<AttackTypeEvent>();
            array.add(e);
            map.put(type, array);
        }
        return map;
    }

    private AttackTypeEvent mergeEvent(List<AttackTypeEvent> sameTypeEvents) {
        AttackTypeEvent first = sameTypeEvents.get(0);
        EventIdentifier identifier = first.getIdentifierCopy();
        identifier.setZoneType();
        AttackTypeEvent event = new AttackTypeEvent(identifier, first.getAttackType());
        event.merge(sameTypeEvents);
        return event;
    }
}

