/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.Processor;
import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IntelligentDefense.IntelligentDefenseThread;
import com.hs.atic.collector.biz.event.process.ZoneBlacklistHistoryRepositoryThread;
import com.hs.atic.collector.db.DefaultRepositoryFactory;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.condition.AllCondition;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.event.ZoneBlackConditionField;
import com.hs.atic.collector.entity.BlackListData;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class ZoneBlackListEventHandler
extends EventHandler<ZoneBlackListEvent, ZoneBlackListEvent>
implements Processor<ZoneBlackListEvent> {
    private static final ZoneBlackListEventHandler INSTANCE = new ZoneBlackListEventHandler();
    private List<ZoneBlackListEvent> cache = new ArrayList<ZoneBlackListEvent>();
    private ReentrantLock lock = new ReentrantLock();
    private Repository<ZoneBlackListEvent> repository = DefaultRepositoryFactory.getInstance().getRepository(ZoneBlackListEvent.class.getName());
    private ZoneBlacklistHistoryRepositoryThread historyRepositoryThread;

    private ZoneBlackListEventHandler() {
        this.cache = this.repository.queryObject(new AllCondition());
        super.setLogger(LogManager.getInstance().getBlackLog());
    }

    public static ZoneBlackListEventHandler getInstance() {
        return INSTANCE;
    }

    public List<ZoneBlackListEvent> getCache() {
        return this.cache;
    }

    public ZoneBlacklistHistoryRepositoryThread getHistoryRepositoryThread() {
        return this.historyRepositoryThread;
    }

    public void setHistoryRepositoryThread(ZoneBlacklistHistoryRepositoryThread historyRepositoryThread) {
        this.historyRepositoryThread = historyRepositoryThread;
    }

    @Override
    protected List<ZoneBlackListEvent> handelEvents(List<ZoneBlackListEvent> events) {
        if (events.isEmpty()) {
            this.sumEvents(events);
            return events;
        }
        this.logger.info((Object)("handelEvents proess blackEvent.size=" + events.size()));
        int startPosition = 0;
        int endPosition = 0;
        boolean isHasValidEvent = false;
        for (int i = 0; i < events.size(); ++i) {
            if (events.get(i).isInvalid()) {
                if (isHasValidEvent) {
                    this.sumEvents(events.subList(startPosition, endPosition));
                    startPosition = endPosition;
                    isHasValidEvent = false;
                }
            } else {
                isHasValidEvent = true;
            }
            ++endPosition;
        }
        this.sumEvents(events.subList(startPosition, endPosition));
        events.clear();
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sumEvents(List<ZoneBlackListEvent> events) {
        ArrayList<ZoneBlackListEvent> deletes = new ArrayList<ZoneBlackListEvent>();
        ArrayList<ZoneBlackListEvent> creates = new ArrayList<ZoneBlackListEvent>();
        if (!events.isEmpty()) {
            this.logger.info((Object)("sumEvents begin proess blackList.size: " + events.size()));
            this.lock.lock();
            try {
                for (ZoneBlackListEvent event : events) {
                    if (event.isInvalid()) {
                        this.processInvalidBlacklist(event, deletes);
                        continue;
                    }
                    if (!event.isTimeOut()) {
                        this.processNormalBlacklist(event, creates, deletes);
                        continue;
                    }
                    event.setEndTime(System.currentTimeMillis());
                    this.historyRepositoryThread.addOneBlacklist(event);
                    this.logger.debug((Object)("delete a blackEvent for timeout before add to db." + event.toString()));
                }
            }
            finally {
                this.lock.unlock();
            }
            if (!deletes.isEmpty()) {
                ArrayList<Condition> conditionList = new ArrayList<Condition>();
                for (ZoneBlackListEvent event : deletes) {
                    conditionList.add(this.getCondition(event));
                }
                this.repository.deleteObjectList(conditionList);
                AlarmThread.getInstance().addDynBlistAlarmEntityEnd(deletes);
                this.historyRepositoryThread.addBlacklists(deletes);
            }
            AlarmThread.getInstance().addDynBlistAlarmEntityStart(creates);
            this.repository.createObjects(creates);
            this.logger.debug((Object)("after sum and befor timeout, cache.size=" + this.cache.size() + ", creates=" + creates.size() + ", deletes=" + deletes.size()));
        }
        this.processTimeOut(deletes);
    }

    private void processInvalidBlacklist(ZoneBlackListEvent event, List<ZoneBlackListEvent> deletes) {
        if (this.cache.contains(event)) {
            ZoneBlackListEvent e = this.cache.remove(this.cache.indexOf(event));
            event.setStatus(e.getStatus());
            event.setBlackListMode(e.getBlackListMode());
            event.setBlackListType(e.getBlackListType());
            event.setEndTime(event.getLogTime());
            event.setLogTime(e.getLogTime());
        } else {
            event.setEndTime(event.getLogTime());
        }
        deletes.add(event);
        IntelligentDefenseThread.getInstance().removeIpBlackInfo(event);
    }

    private void processNormalBlacklist(ZoneBlackListEvent event, List<ZoneBlackListEvent> creates, List<ZoneBlackListEvent> deletes) {
        if (!this.cache.contains(event)) {
            this.cache.add(event);
            creates.add(event);
            IntelligentDefenseThread.getInstance().addIpBlackInfo(event);
        } else if (this.cache.get(this.cache.indexOf(event)).getBlackListType() != event.getBlackListType()) {
            ZoneBlackListEvent deleteEvent = this.cache.remove(this.cache.indexOf(event));
            deleteEvent.setEndTime(event.getLogTime());
            deletes.add(deleteEvent);
            this.cache.add(event);
            creates.add(event);
            IntelligentDefenseThread.getInstance().addIpBlackInfo(event);
        } else {
            this.cache.get(this.cache.indexOf(event)).setLogTime(event.getLogTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeOut(List<ZoneBlackListEvent> deletes) {
        deletes.clear();
        this.lock.lock();
        try {
            for (ZoneBlackListEvent event : this.cache) {
                if (!event.isTimeOut()) continue;
                event.setEndTime(System.currentTimeMillis());
                deletes.add(event);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!deletes.isEmpty()) {
            ArrayList<Condition> conditionList = new ArrayList<Condition>();
            for (ZoneBlackListEvent event : deletes) {
                conditionList.add(this.getCondition(event));
            }
            this.repository.deleteObjectList(conditionList);
            AlarmThread.getInstance().addDynBlistAlarmEntityEnd(deletes);
            this.cache.removeAll(deletes);
            this.historyRepositoryThread.addBlacklists(deletes);
            this.logger.debug((Object)("after processTimeout, cache.size=" + this.cache.size() + ", deletes.size=" + deletes.size()));
        }
    }

    private Condition getCondition(ZoneBlackListEvent event) {
        ConditionSeparator equalSeparator = ConditionSeparatorFactory.getInstance().equal();
        ConditionClause zoneIdCondition = new ConditionClause();
        zoneIdCondition.setField(new ZoneBlackConditionField("zoneId"));
        zoneIdCondition.setSeparator(equalSeparator);
        zoneIdCondition.setValue(event.getZoneId());
        zoneIdCondition.addValueList(zoneIdCondition.getValue());
        ConditionClause blackIpCondtion = new ConditionClause();
        blackIpCondtion.setField(new ZoneBlackConditionField("blackIp"));
        blackIpCondtion.setSeparator(equalSeparator);
        blackIpCondtion.setValue(event.getBlackIp());
        zoneIdCondition.addValueList(blackIpCondtion.getValue());
        ConditionClause portConditon = new ConditionClause();
        portConditon.setField(new ZoneBlackConditionField("port"));
        portConditon.setSeparator(equalSeparator);
        portConditon.setValue(event.getPort());
        zoneIdCondition.addValueList(portConditon.getValue());
        ConditionClause typeCondtion = new ConditionClause();
        typeCondtion.setField(new ZoneBlackConditionField("protocol"));
        typeCondtion.setSeparator(equalSeparator);
        typeCondtion.setValue(event.getProtocol());
        zoneIdCondition.addValueList(typeCondtion.getValue());
        ConditionClause deviceCondtion = new ConditionClause();
        deviceCondtion.setField(new ZoneBlackConditionField("device"));
        deviceCondtion.setSeparator(equalSeparator);
        deviceCondtion.setValue(event.getDeviceIp());
        zoneIdCondition.addValueList(deviceCondtion.getValue());
        zoneIdCondition.andCondtion(blackIpCondtion);
        zoneIdCondition.andCondtion(portConditon);
        zoneIdCondition.andCondtion(typeCondtion);
        zoneIdCondition.andCondtion(deviceCondtion);
        return zoneIdCondition;
    }

    @Override
    public void processMetaData(List<ZoneBlackListEvent> datas) {
        this.handelEvents(datas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlacklistsByZone(long zoneId) {
        this.logger.debug((Object)("start to delete all blacklist from cache of zoneId=" + zoneId + ", cache.size=" + this.cache.size()));
        ArrayList<ZoneBlackListEvent> deletes = new ArrayList<ZoneBlackListEvent>();
        this.lock.lock();
        try {
            Iterator<ZoneBlackListEvent> iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                ZoneBlackListEvent event = iterator.next();
                if (zoneId != event.getZoneId()) continue;
                event.setEndTime(System.currentTimeMillis());
                deletes.add(event);
                iterator.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.logger.debug((Object)("end to delete all blacklist from cache of zoneId=" + zoneId + ", cache.size=" + this.cache.size()));
        this.logger.debug((Object)("delete blacklist size=" + deletes.size() + " from zoneId=" + zoneId));
        this.historyRepositoryThread.addBlacklists(deletes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlacklists(List<BlackListData> blacklists) {
        if (null == blacklists || blacklists.isEmpty()) {
            this.logger.error((Object)"input blacklists is empty.");
            return;
        }
        this.logger.debug((Object)("start to delete blacklists from cache, blacklists.size=" + blacklists.size() + ", cache.size=" + this.cache.size()));
        ArrayList<ZoneBlackListEvent> deletes = new ArrayList<ZoneBlackListEvent>();
        this.lock.lock();
        try {
            block3: for (BlackListData data : blacklists) {
                Iterator<ZoneBlackListEvent> iterator = this.cache.iterator();
                while (iterator.hasNext()) {
                    ZoneBlackListEvent event = iterator.next();
                    if (!event.isSameBlacklist(data)) continue;
                    event.setEndTime(System.currentTimeMillis());
                    deletes.add(event);
                    iterator.remove();
                    continue block3;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.logger.debug((Object)("end to delete blacklist cache.size=" + this.cache.size()));
        this.logger.debug((Object)("delete blacklist size=" + deletes.size()));
        this.historyRepositoryThread.addBlacklists(deletes);
    }
}

