/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ZoneFlowEventHandler<T extends Event>
extends EventHandler<T, T> {
    public ZoneFlowEventHandler() {
        super.setLogger(LogManager.getInstance().getFlowLog());
    }

    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event t : events) {
            if (!t.isZoneEvent()) continue;
            result.add(t);
        }
        return result;
    }

    public List<T> mergeByZone(List<T> eventsAfterMergeByIp) {
        Map<Type, List<T>> zones = EventUtil.groupEventsByBizAndEventType(eventsAfterMergeByIp);
        this.logger.info((Object)("group by zone completed ,group size are " + zones.size()));
        ArrayList<Event> zoneEvents = new ArrayList<Event>();
        for (Map.Entry<Type, List<T>> entry : zones.entrySet()) {
            this.logger.debug((Object)("zone type=" + entry.getKey().toString()));
            List<T> events = entry.getValue();
            if (events.isEmpty()) continue;
            Event first = (Event)events.get(0);
            EventIdentifier identifier = first.getIdentifierCopy();
            identifier.setZoneType();
            Event zoneEvent = first.getCopyEvent();
            zoneEvent.setIdentifer(identifier);
            zoneEvent.merge(events);
            zoneEvents.add(zoneEvent);
        }
        EventUtil.createEvents(zoneEvents);
        return zoneEvents;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        if (!events.isEmpty()) {
            return this.mergeByZone(events);
        }
        return new ArrayList();
    }
}

